/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.netbeans.modules.dlight.sendto.api.ConfigurationsModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

public final class ConfigurationNodes
extends Children.Keys<Configuration> {
    private final ChangeListener cl;

    public ConfigurationNodes(final ConfigurationsModel model) {
        this.cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfigurationNodes.this.setKeys(model.getConfigurations());
            }
        };
        model.addChangeListener(this.cl);
        this.cl.stateChanged(null);
    }

    protected Node[] createNodes(Configuration key) {
        return new ConfigurationNode[]{new ConfigurationNode(key)};
    }

    public static class ConfigurationNode
    extends AbstractNode {
        private final BufferedImage icon = new BufferedImage(15, 15, 2);

        public ConfigurationNode(Configuration cfg) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{cfg}));
            Graphics2D g = (Graphics2D)this.icon.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.black);
            g.fillOval(7, 4, 5, 5);
        }

        public Configuration getConfiguration() {
            return (Configuration)this.getLookup().lookup(Configuration.class);
        }

        public Image getOpenedIcon(int type) {
            return this.icon;
        }

        public void updateName() {
            this.fireDisplayNameChange(null, this.getConfiguration().getName());
            this.fireNameChange(null, this.getConfiguration().getName());
        }

        public Image getIcon(int type) {
            return this.icon;
        }

        public String getDisplayName() {
            return this.getConfiguration().getName();
        }
    }
}

