/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.util.ArrayList;
import java.util.Arrays;

public class JspNameUtil {
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
    public static final String JSP_PACKAGE_NAME = "org.apache.jsp";

    public static final String makeJavaPackage(String path) {
        String[] classNameComponents = JspNameUtil.split(path, "/");
        StringBuilder legalClassNames = new StringBuilder();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(JspNameUtil.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    private static final String[] split(String path, String pat) {
        ArrayList<String> comps = new ArrayList<String>();
        int pos = path.indexOf(pat);
        int start = 0;
        while (pos >= 0) {
            if (pos > start) {
                String comp = path.substring(start, pos);
                comps.add(comp);
            }
            start = pos + pat.length();
            pos = path.indexOf(pat, start);
        }
        if (start < path.length()) {
            comps.add(path.substring(start));
        }
        return comps.toArray(new String[comps.size()]);
    }

    public static final String makeJavaIdentifier(String identifier) {
        StringBuilder modifiedIdentifier = new StringBuilder(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(JspNameUtil.mangleChar(ch));
        }
        if (JspNameUtil.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    public static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    public static boolean isJavaKeyword(String key) {
        return Arrays.binarySearch(JAVA_KEYWORDS, key) >= 0;
    }
}

