/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgHistoryProvider;
import org.netbeans.modules.mercurial.remote.MercurialAnnotator;
import org.netbeans.modules.mercurial.remote.MercurialInterceptor;
import org.netbeans.modules.mercurial.remote.MercurialVCS;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.VersionsCache;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.RootsToFile;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Mercurial {
    public static final int HG_FETCH_20_REVISIONS = 20;
    public static final int HG_FETCH_50_REVISIONS = 50;
    public static final int HG_FETCH_ALL_REVISIONS = -1;
    public static final int HG_NUMBER_FETCH_OPTIONS = 3;
    public static final int HG_NUMBER_TO_FETCH_DEFAULT = 7;
    public static final int HG_MAX_REVISION_COMBO_SIZE = 10;
    public static final String MERCURIAL_OUTPUT_TAB_TITLE = NbBundle.getMessage(Mercurial.class, (String)"CTL_Mercurial_DisplayName");
    public static final String CHANGESET_STR = "changeset:";
    public static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    public static final String PROP_CHANGESET_CHANGED = "changesetChanged";
    static final String PROP_HEAD_CHANGED = "headChanged";
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial.remote");
    public static final Logger STATUS_LOG = Logger.getLogger("org.netbeans.modules.mercurial.remote.status");
    private static final int STATUS_DIFFABLE = 1272;
    private static final String MERCURIAL_SUPPORTED_VERSION_093 = "0.9.3";
    private static final String MERCURIAL_SUPPORTED_VERSION_094 = "0.9.4";
    private static final String MERCURIAL_SUPPORTED_VERSION_095 = "0.9.5";
    private static final String MERCURIAL_SUPPORTED_VERSION_100 = "1.0";
    private static Mercurial instance;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private RootsToFile rootsToFile;
    private static final List<String> allowableFolders;
    private MercurialAnnotator mercurialAnnotator;
    private MercurialInterceptor mercurialInterceptor;
    private HgHistoryProvider historyProvider;
    private FileStatusCache fileStatusCache;
    private HashMap<HgURL, RequestProcessor> processorsToUrl;
    private final Map<FileSystem, Version> versions = new HashMap<FileSystem, Version>();
    private final Object versionsLock = new Object();
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private RequestProcessor parallelRP;
    private final Set<VCSFileProxy> knownRoots = Collections.synchronizedSet(new HashSet());
    private final Set<VCSFileProxy> unversionedParents = Collections.synchronizedSet(new HashSet(20));

    public static synchronized Mercurial getInstance() {
        if (instance == null) {
            instance = new Mercurial();
            instance.init();
        }
        return instance;
    }

    private Mercurial() {
    }

    private void init() {
        int statisticsFrequency;
        this.fileStatusCache = new FileStatusCache(this);
        this.mercurialAnnotator = new MercurialAnnotator(this.fileStatusCache);
        this.mercurialInterceptor = new MercurialInterceptor(this, this.fileStatusCache);
        String s = System.getProperty("mercurial.root.stat.frequency", "0");
        try {
            statisticsFrequency = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            statisticsFrequency = 0;
        }
        this.rootsToFile = new RootsToFile(new RootsToFile.Callback(){

            public boolean repositoryExistsFor(VCSFileProxy file) {
                return HgUtils.hgExistsFor(file);
            }

            public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
                return Mercurial.this.getTopmostManagedAncestor(file);
            }
        }, Logger.getLogger("org.netbeans.modules.mercurial.RootsToFile"), statisticsFrequency);
        for (FileSystem fs : VCSFileProxySupport.getConnectedFileSystems()) {
            this.asyncInit(VCSFileProxy.createFileProxy((FileObject)fs.getRoot()));
        }
    }

    void register(MercurialVCS mvcs) {
        this.fileStatusCache.addPropertyChangeListener(mvcs);
        this.addPropertyChangeListener(mvcs);
    }

    public void asyncInit(final VCSFileProxy root) {
        this.getV(root).goodVersion = false;
        RequestProcessor rp = this.getRequestProcessor();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Remote '" + VCSFileProxySupport.getFileSystem((VCSFileProxy)root) + "' Mercurial subsystem initialized", new Exception());
        }
        Runnable init = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Mercurial mercurial = Mercurial.this;
                synchronized (mercurial) {
                    Mercurial.this.checkVersionIntern(root);
                }
            }
        };
        rp.post(init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Version getV(VCSFileProxy root) {
        Version v;
        FileSystem fileSystem = VCSFileProxySupport.getFileSystem((VCSFileProxy)root);
        Object object = this.versionsLock;
        synchronized (object) {
            v = this.versions.get(fileSystem);
            if (v == null) {
                v = new Version();
                this.versions.put(fileSystem, v);
            }
        }
        return v;
    }

    private void checkVersionIntern(VCSFileProxy root) {
        Version v = this.getV(root);
        v.version = HgCommand.getHgVersion(root);
        if (v.version != null) {
            v.goodVersion = this.isSupportedVersion(v.version);
        } else {
            v.goodVersion = false;
        }
        LOG.log(v.goodVersion ? Level.FINE : Level.INFO, "version: {0}", v.version);
        v.gotVersion = true;
    }

    private boolean isSupportedVersion(String version) {
        if (version.startsWith(MERCURIAL_SUPPORTED_VERSION_093) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_094) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_095) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_100)) {
            return true;
        }
        return !version.startsWith("0.");
    }

    public boolean isAvailable(VCSFileProxy root) {
        return this.isAvailable(root, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(VCSFileProxy root, boolean forceCheck, boolean notifyUI) {
        OutputLogger logger;
        if (!VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)root))) {
            return false;
        }
        Version v = this.getV(root);
        Mercurial mercurial = this;
        synchronized (mercurial) {
            if (!v.gotVersion) {
                LOG.log(Level.FINE, "Call to hg version not finished");
                if (forceCheck) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "isAvailable performed", new Exception());
                    }
                    this.checkVersionIntern(root);
                } else {
                    return true;
                }
            }
        }
        if (v.version != null && !v.goodVersion) {
            logger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_USING_UNRECOGNIZED_VERSION_MSG", (Object)v.version));
            logger.closeLog();
            LOG.log(Level.WARNING, "Using an unsupported hg version: {0}", v.version);
            v.goodVersion = true;
        } else if (v.version == null && notifyUI) {
            logger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_OUTPUT_MSG"));
            HgUtils.warningDialog(Mercurial.class, "MSG_VERSION_NONE_TITLE", "MSG_VERSION_NONE_MSG");
            logger.closeLog();
            LOG.warning("Hg is not available");
        }
        return v.goodVersion;
    }

    public MercurialAnnotator getMercurialAnnotator() {
        return this.mercurialAnnotator;
    }

    MercurialInterceptor getMercurialInterceptor() {
        return this.mercurialInterceptor;
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public <T> T runWithoutExternalEvents(VCSFileProxy repository, String commandName, Callable<T> callable) throws Exception {
        return this.getMercurialInterceptor().runWithoutExternalEvents(repository, commandName, callable);
    }

    public Set<VCSFileProxy> getSeenRoots(VCSFileProxy repositoryRoot) {
        return this.getMercurialInterceptor().getSeenRoots(repositoryRoot);
    }

    public boolean isManaged(VCSFileProxy file) {
        return VersioningSupport.getOwner((VCSFileProxy)file) instanceof MercurialVCS && !HgUtils.isPartOfMercurialMetadata(file);
    }

    public VCSFileProxy getRepositoryRoot(VCSFileProxy file) {
        return this.rootsToFile.getRepositoryRoot(file);
    }

    public String getMimeType(VCSFileProxy file) {
        String foMime;
        FileObject fo = file.toFileObject();
        if (fo == null) {
            foMime = "content/unknown";
        } else {
            foMime = fo.getMIMEType();
            if ("content/unknown".equals(foMime)) {
                foMime = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return HgUtils.isFileContentBinary(file) ? "application/octet-stream" : foMime;
        }
        return foMime;
    }

    public void versionedFilesChanged() {
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void refreshAnnotations(Set<VCSFileProxy> files) {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, files);
    }

    public void changesetChanged(VCSFileProxy repository) {
        this.support.firePropertyChange(PROP_CHANGESET_CHANGED, repository, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public MercurialVCS getMercurialVCS() {
        for (PropertyChangeListener listener : this.support.getPropertyChangeListeners()) {
            if (!(listener instanceof MercurialVCS)) continue;
            return (MercurialVCS)listener;
        }
        return null;
    }

    public void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        FileInformation info = this.fileStatusCache.getStatus(workingCopy);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getOriginalFile: {0} {1}", new Object[]{workingCopy, info});
        }
        if ((info.getStatus() & 0x4F8) == 0) {
            if ((info.getStatus() & 0x1000) != 0 && info.getStatus(null) != null && info.getStatus(null).getOriginalFile() != null) {
                workingCopy = info.getStatus(null).getOriginalFile();
            } else {
                return;
            }
        }
        try {
            VCSFileProxy original = VersionsCache.getInstance().getFileRevision(workingCopy, HgLogMessage.HgRevision.BASE);
            if (original == null) {
                return;
            }
            Utils.copyStreamsCloseAll((OutputStream)VCSFileProxySupport.getOutputStream((VCSFileProxy)originalFile), (InputStream)original.getInputStream(false));
            VCSFileProxySupport.delete((VCSFileProxy)original);
        }
        catch (IOException e) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.INFO, "Unable to get original file", e);
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor((HgURL)null);
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("Mercurial.ParallelRP", 5, true);
        }
        return this.parallelRP;
    }

    public RequestProcessor getRequestProcessor(VCSFileProxy file) {
        return this.getRequestProcessor(new HgURL(file));
    }

    public RequestProcessor getRequestProcessor(HgURL url) {
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(url)) == null) {
            String rpName = "MercurialRemote - " + (url != null ? url.toString() : "ANY_KEY");
            rp = new RequestProcessor(rpName, 1, true);
            this.processorsToUrl.put(url, rp);
        }
        return rp;
    }

    public void clearRequestProcessor(HgURL url) {
        if (this.processorsToUrl != null && url != null) {
            this.processorsToUrl.remove(url);
        }
    }

    public void notifyFileChanged(VCSFileProxy file) {
        this.fileStatusCache.notifyFileChanged(file);
    }

    public OutputLogger getLogger(String repositoryRoot) {
        return OutputLogger.getLogger(repositoryRoot);
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.emptyList();
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    public String getVersion(VCSFileProxy root) {
        return this.getV(root).version;
    }

    VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
        String homeDir;
        VCSFileProxy parent;
        if (file.toFile() != null) {
            return null;
        }
        if (!this.isAllowable(file)) {
            return null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        }
        if (!VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)file))) {
            return null;
        }
        long t = System.currentTimeMillis();
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        }
        if ((parent = this.getKnownParent(file)) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  getTopmostManagedParent returning known parent " + parent);
            }
            return parent;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            while (file != null) {
                if (HgUtils.isAdministrative(file)) {
                    file = file.getParentFile();
                    this.unversionedParents.remove(file);
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<VCSFileProxy> done = new HashSet<VCSFileProxy>();
        VCSFileProxy topmost = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (VersioningSupport.isExcluded((VCSFileProxy)file)) break;
            boolean forbiddenFolder = Utils.isForbiddenFolder((String)file.getPath());
            if (!forbiddenFolder && HgUtils.hgExistsFor(file)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                }
                done.clear();
                topmost = file;
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                }
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{topmost, System.currentTimeMillis() - t});
        }
        if (topmost != null && this.knownRoots.add(topmost) && (homeDir = System.getProperty("user.home")) != null && homeDir.startsWith(topmost.getPath())) {
            LOG.log(Level.WARNING, "Home folder {0} lies under a hg versioned root {1}.Expecting lots of performance issues.", new Object[]{homeDir, topmost});
        }
        return topmost;
    }

    private VCSFileProxy getKnownParent(VCSFileProxy file) {
        VCSFileProxy[] roots = this.knownRoots.toArray(new VCSFileProxy[this.knownRoots.size()]);
        VCSFileProxy knownParent = null;
        for (VCSFileProxy r : roots) {
            if (VersioningSupport.isExcluded((VCSFileProxy)file) || !VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)r, (VCSFileProxy)file) || knownParent != null && !VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)knownParent, (VCSFileProxy)r)) continue;
            knownParent = r;
        }
        return knownParent;
    }

    public void clearAncestorCaches() {
        this.unversionedParents.clear();
        this.knownRoots.clear();
        this.rootsToFile.clear();
    }

    public HgHistoryProvider getMercurialHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new HgHistoryProvider();
        }
        return this.historyProvider;
    }

    public void historyChanged(VCSFileProxy repository) {
        Set<VCSFileProxy> openFiles = HgUtils.getOpenedFiles(repository);
        if (!openFiles.isEmpty()) {
            this.support.firePropertyChange(PROP_HEAD_CHANGED, null, openFiles);
            if (this.historyProvider != null) {
                this.historyProvider.fireHistoryChange(openFiles.toArray(new VCSFileProxy[openFiles.size()]));
            }
        }
    }

    private boolean isAllowable(VCSFileProxy file) {
        String path = file.getPath() + "/";
        for (String s : allowableFolders) {
            if (!(s.endsWith("/") ? path.startsWith(s) : path.startsWith(s + "/"))) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<String> files = new ArrayList<String>();
        try {
            String allowable = System.getProperty("versioning.hg.allowableFolders", "/");
            files.addAll(Arrays.asList(allowable.split("\\;")));
            files.remove("");
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
        allowableFolders = files;
    }

    private static final class Version {
        private boolean goodVersion;
        private String version;
        private boolean gotVersion;

        private Version() {
        }
    }
}

