/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.config;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.util.HgRepositoryContextCache;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class HgConfigFiles {
    public static final String HG_EXTENSIONS = "extensions";
    public static final String HG_EXTENSIONS_HGK = "hgext.hgk";
    public static final String HG_EXTENSIONS_FETCH = "fetch";
    public static final String HG_UI_SECTION = "ui";
    public static final String HG_USERNAME = "username";
    public static final String HG_PATHS_SECTION = "paths";
    public static final String HG_DEFAULT_PUSH = "default-push";
    public static final String HG_DEFAULT_PUSH_VALUE = "default-push";
    public static final String HG_DEFAULT_PULL = "default-pull";
    public static final String HG_DEFAULT_PULL_VALUE = "default";
    private static final Map<FileSystem, HgConfigFiles> instance = new HashMap<FileSystem, HgConfigFiles>();
    private Ini hgrc = null;
    private VCSFileProxy dir;
    public static final String HG_RC_FILE = "hgrc";
    public static final String HG_REPO_DIR = ".hg";
    private static final String WINDOWS_HG_RC_FILE = "Mercurial.ini";
    private static final String WINDOWS_DEFAULT_MECURIAL_INI_PATH = "C:\\Mercurial\\Mercurial.ini";
    private final boolean bIsProjectConfig;
    private IOException initException;
    private String configFileName;
    private final FileSystem fileSystem;

    public static synchronized HgConfigFiles getSysInstance(VCSFileProxy root) {
        HgConfigFiles res;
        FileSystem fileSystem = null;
        if (root != null) {
            fileSystem = VCSFileProxySupport.getFileSystem((VCSFileProxy)root);
        }
        if ((res = instance.get(fileSystem)) == null) {
            res = new HgConfigFiles(fileSystem);
            instance.put(fileSystem, res);
        }
        return res;
    }

    private HgConfigFiles(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.bIsProjectConfig = false;
        Config.getGlobal().setEscape(false);
        this.hgrc = this.loadSystemAndGlobalFile(fileSystem, new String[]{HG_RC_FILE});
    }

    public HgConfigFiles(VCSFileProxy file) {
        this.fileSystem = VCSFileProxySupport.getFileSystem((VCSFileProxy)file);
        Config.getGlobal().setEscape(false);
        this.bIsProjectConfig = true;
        this.dir = file;
        this.hgrc = this.loadRepoHgrcFile(file);
    }

    public IOException getException() {
        return this.initException;
    }

    public void setProperty(String name, String value) {
        if (name.equals(HG_USERNAME)) {
            this.setProperty(HG_UI_SECTION, HG_USERNAME, value);
        } else if (name.equals("default-push")) {
            this.setProperty(HG_PATHS_SECTION, "default-push", HgConfigFiles.removeTrailingBackslahes(value));
            HgRepositoryContextCache.getInstance().reset();
        } else if (name.equals(HG_DEFAULT_PULL)) {
            this.setProperty(HG_PATHS_SECTION, HG_DEFAULT_PULL_VALUE, HgConfigFiles.removeTrailingBackslahes(value));
            HgRepositoryContextCache.getInstance().reset();
        } else if (name.equals(HG_EXTENSIONS_HGK)) {
            if (this.getProperty(HG_EXTENSIONS, HG_EXTENSIONS_HGK).equals("")) {
                this.setProperty(HG_EXTENSIONS, HG_EXTENSIONS_HGK, value, true);
            }
        } else if (name.equals(HG_EXTENSIONS_FETCH) && this.getProperty(HG_EXTENSIONS, HG_EXTENSIONS_FETCH).equals("")) {
            this.setProperty(HG_EXTENSIONS, HG_EXTENSIONS_FETCH, value, true);
        }
    }

    public void setProperty(String section, String name, String value, boolean allowEmpty) {
        if (!allowEmpty) {
            if (value.length() == 0) {
                this.removeProperty(section, name);
            } else {
                Profile.Section inisection = this.getSection(this.hgrc, section, true);
                inisection.put((Object)name, (Object)value);
            }
        } else {
            Profile.Section inisection = this.getSection(this.hgrc, section, true);
            inisection.put((Object)name, (Object)value);
        }
        this.storeIni(this.hgrc, this.configFileName);
    }

    public void setProperty(String section, String name, String value) {
        this.setProperty(section, name, value, false);
    }

    public void setUserName(String value) {
        this.setProperty(HG_UI_SECTION, HG_USERNAME, value);
    }

    public String getSysUserName() {
        return this.getUserName(true);
    }

    public String getSysPushPath() {
        return this.getDefaultPush(true);
    }

    public String getSysPullPath() {
        return this.getDefaultPull(true);
    }

    public Properties getProperties(String section) {
        Profile.Section inisection = this.getSection(this.hgrc, section, false);
        Properties props = new Properties();
        if (inisection != null) {
            Set keys = inisection.keySet();
            for (String key : keys) {
                props.setProperty(key, (String)inisection.get((Object)key));
            }
        }
        return props;
    }

    public void clearProperties(String section) {
        Profile.Section inisection = this.getSection(this.hgrc, section, false);
        if (inisection != null) {
            inisection.clear();
            this.storeIni(this.hgrc, this.configFileName);
        }
    }

    public void removeProperty(String section, String name) {
        Profile.Section inisection = this.getSection(this.hgrc, section, false);
        if (inisection != null) {
            inisection.remove((Object)name);
            this.storeIni(this.hgrc, this.configFileName);
        }
    }

    public String getDefaultPull(Boolean reload) {
        if (reload.booleanValue()) {
            this.doReload();
        }
        return this.getProperty(HG_PATHS_SECTION, HG_DEFAULT_PULL_VALUE);
    }

    public String getDefaultPush(Boolean reload) {
        String value;
        if (reload.booleanValue()) {
            this.doReload();
        }
        if ((value = this.getProperty(HG_PATHS_SECTION, "default-push")).length() == 0) {
            value = this.getProperty(HG_PATHS_SECTION, HG_DEFAULT_PULL_VALUE);
        }
        return value;
    }

    public String getUserName(Boolean reload) {
        if (reload.booleanValue()) {
            this.doReload();
        }
        return this.getProperty(HG_UI_SECTION, HG_USERNAME);
    }

    public String getProperty(String section, String name) {
        Profile.Section inisection = this.getSection(this.hgrc, section, true);
        String value = (String)inisection.get((Object)name);
        return value != null ? value : "";
    }

    public boolean containsProperty(String section, String name) {
        Profile.Section inisection = this.getSection(this.hgrc, section, true);
        return inisection.containsKey((Object)name);
    }

    public void doReload() {
        this.hgrc = this.dir == null ? this.loadSystemAndGlobalFile(this.fileSystem, new String[]{HG_RC_FILE}) : this.loadRepoHgrcFile(this.dir);
    }

    private Profile.Section getSection(Ini ini, String key, boolean create) {
        Profile.Section section = (Profile.Section)ini.get((Object)key);
        if (section == null && create) {
            return ini.add(key);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIni(Ini ini, String iniFile) {
        assert (this.initException == null);
        FilterOutputStream bos = null;
        try {
            VCSFileProxy filePath = this.dir != null ? VCSFileProxy.createFileProxy((VCSFileProxy)this.dir, (String)(".hg/" + iniFile)) : VCSFileProxy.createFileProxy((VCSFileProxy)this.getUserConfigPath(), (String)("." + iniFile));
            VCSFileProxy file = filePath.normalizeFile();
            VCSFileProxySupport.mkdirs((VCSFileProxy)file.getParentFile());
            bos = new BufferedOutputStream(VCSFileProxySupport.getOutputStream((VCSFileProxy)file));
            ini.store((OutputStream)bos);
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
            }
        }
    }

    private Ini createIni() {
        return this.createIni(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ini createIni(VCSFileProxy file) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Mercurial.class.getClassLoader());
        try {
            if (file == null) {
                Ini ini = new Ini();
                return ini;
            }
            Ini ini = new Ini((Reader)new InputStreamReader(file.getInputStream(false), "UTF-8"));
            return ini;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (InvalidFileFormatException ex) {
            Mercurial.LOG.log(Level.INFO, "Cannot parse configuration file", ex);
            this.initException = ex;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
        }
        catch (Exception ex) {
            Mercurial.LOG.log(Level.INFO, "Cannot parse configuration file", ex);
            this.initException = new IOException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return null;
    }

    private Ini loadRepoHgrcFile(VCSFileProxy dir) {
        VCSFileProxy filePath = VCSFileProxy.createFileProxy((VCSFileProxy)dir, (String)".hg/hgrc");
        this.configFileName = HG_RC_FILE;
        VCSFileProxy file = filePath.normalizeFile();
        Ini system = null;
        system = this.createIni(file);
        if (system == null) {
            system = this.createIni();
            Mercurial.LOG.log(Level.FINE, "Could not load the file " + filePath + ". Falling back on hg defaults.");
        }
        return system;
    }

    private Ini loadSystemAndGlobalFile(FileSystem fileSystem, String[] fileNames) {
        Ini system = null;
        for (String userConfigFileName : fileNames) {
            VCSFileProxy filePath = VCSFileProxy.createFileProxy((VCSFileProxy)this.getUserConfigPath(), (String)("." + userConfigFileName));
            VCSFileProxy file = filePath.normalizeFile();
            system = this.createIni(file);
            if (system != null) {
                this.configFileName = userConfigFileName;
                break;
            }
            Mercurial.LOG.log(Level.INFO, "Could not load the file {0}.", filePath);
        }
        if (system == null) {
            this.configFileName = fileNames[0];
            system = this.createIni();
            Mercurial.LOG.log(Level.INFO, "Could not load the user config file. Falling back on hg defaults.");
        }
        Ini global = null;
        VCSFileProxy gFile = VCSFileProxySupport.getResource((FileSystem)fileSystem, (String)(HgConfigFiles.getGlobalConfigPath() + "/" + fileNames[0]));
        global = this.createIni(gFile);
        if (global != null) {
            this.merge(global, system);
        }
        return system;
    }

    private void merge(Ini source, Ini target) {
        for (String sectionName : source.keySet()) {
            Profile.Section sourceSection = (Profile.Section)source.get((Object)sectionName);
            Profile.Section targetSection = (Profile.Section)target.get((Object)sectionName);
            if (targetSection == null) {
                targetSection = target.add(sectionName);
            }
            for (String key : sourceSection.keySet()) {
                if (targetSection.containsKey((Object)key)) continue;
                targetSection.put((Object)key, sourceSection.get((Object)key));
            }
        }
    }

    private VCSFileProxy getUserConfigPath() {
        return VCSFileProxySupport.getHome((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot()));
    }

    private static String getGlobalConfigPath() {
        return "/etc/mercurial";
    }

    private static String removeTrailingBackslahes(String value) {
        while (value.endsWith("\\")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

