/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;

public class WsitPojectOpenedHook
extends ProjectOpenedHook {
    private static Logger LOG = Logger.getLogger(WsitPojectOpenedHook.class.getCanonicalName());
    private Project project;

    public WsitPojectOpenedHook(Project project) {
        this.project = project;
    }

    protected void projectOpened() {
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        FileObject ddFolder = support.getDeploymentDescriptorFolder();
        if (ddFolder == null) {
            return;
        }
        FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        if (sunjaxwsFile == null) {
            return;
        }
        try {
            Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
            final Endpoint[] endpointsCollection = endpoints.getEndpoints();
            MetadataModel wsModel = support.getWebservicesMetadataModel();
            wsModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                public Void run(WebservicesMetadata metadata) {
                    for (Endpoint endpoint : endpointsCollection) {
                        Object isStsWs;
                        String implementation = endpoint.getImplementation();
                        FileObject fileObject = WsitPojectOpenedHook.this.getFileObjectFromClassName(implementation);
                        if (fileObject == null || (isStsWs = fileObject.getAttribute("sts-webservice")) == null || !isStsWs.toString().equals("true")) continue;
                        WsitPojectOpenedHook.this.addDescriptorsCleaner(fileObject, implementation, endpoint.getEndpointName());
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, null, e);
        }
    }

    private void addDescriptorsCleaner(FileObject fileObject, final String fqn, final String endpointName) {
        fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fe) {
                try {
                    JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)WsitPojectOpenedHook.this.project.getProjectDirectory());
                    support.removeNonJsr109Entries("MEXEndpoint");
                    support.removeNonJsr109Entries(fqn);
                    support.removeNonJsr109Entries(endpointName);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, null, e);
                }
            }
        });
    }

    public FileObject getFileObjectFromClassName(String fqn) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroups == null || sourceGroups.length == 0) {
            return null;
        }
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)sourceGroups[0].getRootFolder());
        ClassIndex ci = cpInfo.getClassIndex();
        int beginIndex = fqn.lastIndexOf(46) + 1;
        String simple = fqn.substring(beginIndex);
        Set handles = ci.getDeclaredTypes(simple, ClassIndex.NameKind.SIMPLE_NAME, Collections.singleton(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle handle : handles) {
            if (!fqn.equals(handle.getQualifiedName())) continue;
            return SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)cpInfo);
        }
        return null;
    }

    protected void projectClosed() {
    }
}

