/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.TrustStoreFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.MessageAuthentication;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class MessageAuthenticationProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature,
ValidatorsFeature,
AdvancedSecurityFeature,
TrustStoreFeature {
    private static final String DEFAULT_USERNAME = "wsit";
    private static final String DEFAULT_PASSWORD = "wsitPassword";

    @Override
    public int getId() {
        return 40;
    }

    @Override
    public String getDisplayName() {
        return ComboConstants.PROF_MSGAUTHSSL;
    }

    @Override
    public String getDescription() {
        return ComboConstants.PROF_MSGAUTHSSL_INFO;
    }

    @Override
    public boolean isCurrentProfile(WSDLComponent component) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(component));
    }

    @Override
    public void displayConfig(WSDLComponent component, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel model = component.getModel();
        model.addUndoableEditListener((UndoableEditListener)undoCounter);
        MessageAuthentication profConfigPanel = new MessageAuthentication(component, this);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)profConfigPanel, this.getDisplayName());
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    @Override
    public void setServiceDefaults(WSDLComponent component, Project p) {
        ProprietarySecurityPolicyModelHelper.clearValidators(component);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, false);
    }

    @Override
    public void setClientDefaults(WSDLComponent component, WSDLComponent serviceBinding, Project p) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)component);
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)component, "usernameHandler", null, DEFAULT_USERNAME, true);
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)component, "passwordHandler", null, DEFAULT_PASSWORD, true);
    }

    @Override
    public boolean isServiceDefaultSetupUsed(WSDLComponent component, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String keyAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, false);
        String trustAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, true);
        String trustLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, true);
        String keyLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, false);
        String keyPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, false);
        String trustPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, true);
        return keyAlias == null && trustAlias == null && trustLoc == null && keyLoc == null && trustPasswd == null && keyPasswd == null;
    }

    @Override
    public boolean isClientDefaultSetupUsed(WSDLComponent component, Binding serviceBinding, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String trustLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, true);
        String keyLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, false);
        String keyPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, false);
        String trustPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, true);
        String keyAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, false);
        String trustAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, true);
        if (keyAlias == null && trustAlias == null && trustLoc == null && keyLoc == null && trustPasswd == null && keyPasswd == null) {
            String user = ProprietarySecurityPolicyModelHelper.getDefaultUsername((Binding)component);
            String passwd = ProprietarySecurityPolicyModelHelper.getDefaultPassword((Binding)component);
            if (Util.isEqual(DEFAULT_PASSWORD, passwd) && Util.isEqual(DEFAULT_USERNAME, user)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSecureConversation(WSDLComponent component) {
        WSDLComponent endToken = SecurityTokensModelHelper.getSupportingToken(component, 2);
        return endToken != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableSecureConversation(WSDLComponent component, boolean enable) {
        ConfigVersion cfgVersion = PolicyModelHelper.getConfigVersion(component);
        SecurityTokensModelHelper stmh = SecurityTokensModelHelper.getInstance(cfgVersion);
        if (enable) {
            WSDLModel model = component.getModel();
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            try {
                SecurityPolicyModelHelper securityPolicyModelHelper = SecurityPolicyModelHelper.getInstance(cfgVersion);
                AlgoSuiteModelHelper asmh = AlgoSuiteModelHelper.getInstance(cfgVersion);
                RMModelHelper rmh = RMModelHelper.getInstance(cfgVersion);
                PolicyModelHelper ProprietarySecurityPolicyModelHelper2 = PolicyModelHelper.getInstance(cfgVersion);
                securityPolicyModelHelper.enableTrust(component, cfgVersion);
                SecurityTokensModelHelper.removeSupportingTokens(component);
                WSDLComponent suppToken = stmh.setSupportingTokens(component, ComboConstants.SECURECONVERSATION, 2);
                Policy p = (Policy)ProprietarySecurityPolicyModelHelper2.createElement(suppToken, PolicyQName.POLICY.getQName(cfgVersion), Policy.class, false);
                BootstrapPolicy bp = (BootstrapPolicy)ProprietarySecurityPolicyModelHelper2.createElement((WSDLComponent)p, SecurityPolicyQName.BOOTSTRAPPOLICY.getQName(cfgVersion), BootstrapPolicy.class, false);
                p = (Policy)ProprietarySecurityPolicyModelHelper2.createElement((WSDLComponent)bp, PolicyQName.POLICY.getQName(cfgVersion), Policy.class, false);
                TransportBinding tb = (TransportBinding)ProprietarySecurityPolicyModelHelper2.createElement((WSDLComponent)p, SecurityPolicyQName.TRANSPORTBINDING.getQName(cfgVersion), TransportBinding.class, false);
                boolean rm = rmh.isRMEnabled(component);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)p, true, rm);
                stmh.setTokenType((WSDLComponent)tb, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                securityPolicyModelHelper.setLayout((WSDLComponent)tb, ComboConstants.STRICT);
                securityPolicyModelHelper.enableIncludeTimestamp((WSDLComponent)tb, true);
                asmh.setAlgorithmSuite((WSDLComponent)tb, ComboConstants.BASIC128);
                if (ConfigVersion.CONFIG_1_0.equals((Object)cfgVersion)) {
                    stmh.setSupportingTokens((WSDLComponent)p, ComboConstants.USERNAME, 1);
                } else {
                    stmh.setSupportingTokens((WSDLComponent)p, ComboConstants.USERNAME, 5);
                }
                WssElement wss = securityPolicyModelHelper.enableWss((WSDLComponent)bp, true);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wss, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wss, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wss, true);
                TrustElement trust = securityPolicyModelHelper.enableTrust((WSDLComponent)bp, cfgVersion);
                securityPolicyModelHelper.enableMustSupportIssuedTokens(trust, true);
                securityPolicyModelHelper.enableRequireClientEntropy(trust, true);
                securityPolicyModelHelper.enableRequireServerEntropy(trust, true);
            }
            finally {
                if (!isTransaction) {
                    model.endTransaction();
                }
            }
        } else {
            SecurityTokensModelHelper.removeSupportingTokens(component);
            if (ConfigVersion.CONFIG_1_0.equals((Object)cfgVersion)) {
                stmh.setSupportingTokens(component, ComboConstants.USERNAME, 1);
            } else {
                stmh.setSupportingTokens(component, ComboConstants.USERNAME, 5);
            }
        }
    }

    @Override
    public void profileSelected(WSDLComponent component, boolean updateServiceUrl, ConfigVersion configVersion) {
        ProfilesModelHelper pmh = ProfilesModelHelper.getInstance(configVersion);
        RMModelHelper rmh = RMModelHelper.getInstance(configVersion);
        pmh.setSecurityProfile(component, this.getDisplayName(), updateServiceUrl);
        boolean isRM = rmh.isRMEnabled(component);
        if (isRM) {
            this.enableSecureConversation(component, true);
        }
    }

    @Override
    public boolean isValidatorSupported(ConfigVersion cfgVersion, String validatorType) {
        return true;
    }

    @Override
    public boolean isTrustStoreRequired(WSDLComponent component, boolean client) {
        ExtensibilityElement secBinding = null;
        WSDLComponent endToken = SecurityTokensModelHelper.getSupportingToken(component, 2);
        WSDLComponent secConvT = SecurityTokensModelHelper.getTokenElement(endToken, SecureConversationToken.class);
        boolean secConv = secConvT instanceof SecureConversationToken;
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(secConvT, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            Policy p = (Policy)secBinding.getParent();
            p = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
            WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)p, 2);
            if (tokenKind == null) {
                return false;
            }
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(component);
            WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken(component, 2);
            if (tokenKind == null) {
                return false;
            }
        }
        return true;
    }
}

