/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.cnd.asm.model.lang.instruction.Instruction;

public abstract class AbstractAsmModel
implements AsmModel {
    private final Map<String, Instruction> str2inst = new HashMap<String, Instruction>();
    private final Map<String, Register> str2reg = new HashMap<String, Register>();

    protected AbstractAsmModel() {
    }

    protected void init() {
        this.str2inst.clear();
        this.str2reg.clear();
        for (Instruction instr : this.getInstructionSet()) {
            AbstractAsmModel.splitAndAdd(instr.getName(), instr, this.str2inst);
        }
        for (Register reg : this.getRegisterSet()) {
            AbstractAsmModel.splitAndAdd(reg.getName(), reg, this.str2reg);
        }
    }

    public Instruction getInstructionByName(String name) {
        return this.str2inst.get(name);
    }

    public Register getRegisterByName(String name) {
        return this.str2reg.get(name);
    }

    private static <T> void splitAndAdd(String name, T value, Map<String, T> mapa) {
        for (String el : name.split(";")) {
            mapa.put(el, value);
        }
    }
}

