/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tigris.subversion.javahl.JavaHLObjectFactory;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class JavaHLDebugLog
extends SVNDebugLogAdapter {
    private static final String JAVAHL_LOGGER_NAME = "svnkit-javahl";
    private static JavaHLDebugLog ourInstance = new JavaHLDebugLog();
    private Map myHandlers = new HashMap();
    private Logger myLogger;

    public static JavaHLDebugLog getInstance() {
        return ourInstance;
    }

    public synchronized void enableLogging(int logLevel, File logPath, Formatter formatter) throws SVNException {
        logPath = logPath.getAbsoluteFile();
        if (logLevel == 0) {
            if (logPath == null) {
                this.resetLogHandlers();
            } else {
                Handler handler = (Handler)this.myHandlers.remove(logPath);
                if (handler != null) {
                    handler.close();
                    this.getLogger().removeHandler(handler);
                }
            }
            return;
        }
        Level level = JavaHLObjectFactory.getLoggingLevel(logLevel);
        Handler handler = (Handler)this.myHandlers.get(logPath);
        if (handler == null) {
            try {
                handler = new FileHandler(logPath.getAbsolutePath(), true);
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), e, SVNLogType.DEFAULT);
            }
            this.myHandlers.put(logPath, handler);
        }
        handler.setFormatter(formatter);
        handler.setLevel(level);
        this.getLogger().addHandler(handler);
    }

    private void resetLogHandlers() {
        if (this.getLogger().getHandlers() == null) {
            return;
        }
        for (int i = 0; i < this.getLogger().getHandlers().length; ++i) {
            Handler handler = this.getLogger().getHandlers()[i];
            handler.close();
            this.getLogger().removeHandler(handler);
        }
    }

    private Logger getLogger() {
        if (this.myLogger == null) {
            this.myLogger = Logger.getLogger(JAVAHL_LOGGER_NAME);
            this.myLogger.setUseParentHandlers(false);
            this.myLogger.setLevel(Level.ALL);
            this.resetLogHandlers();
        }
        return this.myLogger;
    }

    @Override
    public void log(SVNLogType logType, String message, byte[] data) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            try {
                this.getLogger().log(Level.FINEST, this.getMessage(message + "\n" + new String(data, "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().log(Level.FINEST, this.getMessage(message + "\n" + new String(data)));
            }
        }
    }

    @Override
    public void log(SVNLogType logType, Throwable th, Level logLevel) {
        if (this.getLogger().isLoggable(logLevel) && th != null) {
            this.getLogger().log(logLevel, this.getMessage(th.getMessage()), th);
        }
    }

    @Override
    public void log(SVNLogType logType, String message, Level logLevel) {
        if (this.getLogger().isLoggable(logLevel) && message != null) {
            this.getLogger().log(logLevel, this.getMessage(message));
        }
    }

    private String getMessage(String originalMessage) {
        return "JAVAHL: " + originalMessage;
    }
}

