/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.reveng.dialect.JDBCMetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;

public class MySQLMetaDataDialect
extends JDBCMetaDataDialect {
    @Override
    public Iterator getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        String sql = null;
        try {
            catalog = this.caseForSearch(catalog);
            schema = this.caseForSearch(schema);
            table = this.caseForSearch(table);
            this.log.debug("geSuggestedPrimaryKeyStrategyName(" + catalog + "." + schema + "." + table + ")");
            sql = "show table status " + (catalog == null ? "" : " from " + catalog + " ") + (table == null ? "" : " like '" + table + "' ");
            PreparedStatement statement = this.getConnection().prepareStatement(sql);
            final String sc = schema;
            final String cat = catalog;
            return new ResultSetIterator(statement.executeQuery(), this.getSQLExceptionConverter()){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                @Override
                protected Object convertRow(ResultSet tableRs) throws SQLException {
                    this.element.clear();
                    this.element.put("TABLE_NAME", tableRs.getString("NAME"));
                    this.element.put("TABLE_SCHEM", sc);
                    this.element.put("TABLE_CAT", cat);
                    String string = tableRs.getString("AUTO_INCREMENT");
                    if (string == null) {
                        this.element.put("HIBERNATE_STRATEGY", null);
                    } else {
                        this.element.put("HIBERNATE_STRATEGY", "identity");
                    }
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", sql);
        }
    }
}

