/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroCache;
import org.netbeans.modules.cnd.apt.impl.support.SnapshotHolderCache;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.MapSnapshot;
import org.netbeans.modules.cnd.utils.cache.TinyMaps;
import org.openide.util.CharSequences;

public final class APTMacroMapSnapshot
extends MapSnapshot<APTMacro> {
    public static final APTMacro UNDEFINED_MACRO = new UndefinedMacro();

    public APTMacroMapSnapshot(APTMacroMapSnapshot parent) {
        super((MapSnapshot)parent);
    }

    protected APTMacroMapSnapshot getParent() {
        return (APTMacroMapSnapshot)super.getParent();
    }

    private void prepareMacroMapToAddMacro(CharSequence name, APTMacro macro) {
        assert (!(this.storage instanceof MapSnapshot.Holder)) : "frozen snap can not be modified";
        if (this.storage == EMPTY) {
            return;
        }
        if (this.storage instanceof Map) {
            Map map = (Map)this.storage;
            this.storage = TinyMaps.expandForNextKey((Map)map, (Object)name);
        } else {
            CharSequence key;
            APTMacro value;
            if (this.storage instanceof APTMacro) {
                value = (APTMacro)this.storage;
                key = value.getName().getTextID();
            } else {
                assert (this.storage instanceof CharSequence);
                value = UNDEFINED_MACRO;
                key = (CharSequence)this.storage;
            }
            if (key.equals(name)) {
                this.storage = EMPTY;
            } else {
                this.storage = TinyMaps.createMap((int)2);
                Map map = (Map)this.storage;
                map.put(key, value);
            }
        }
    }

    final void putMacro(CharSequence name, APTMacro macro) {
        this.prepareMacroMapToAddMacro(name, macro);
        if (this.storage == EMPTY) {
            if (macro == UNDEFINED_MACRO) {
                this.storage = name;
            } else {
                assert (macro.getName().getTextID().equals(name));
                this.storage = macro;
            }
        } else {
            assert (this.storage instanceof Map) : "unexpected class " + this.storage.getClass();
            Map map = (Map)this.storage;
            map.put(name, macro);
        }
    }

    public final APTMacro getMacro(APTToken token) {
        return this.getMacro(token.getTextID());
    }

    final APTMacro getMacro(CharSequence key) {
        return (APTMacro)this.get(key);
    }

    protected APTMacro getImpl(CharSequence key) {
        if (this.storage == EMPTY) {
            return null;
        }
        if (this.storage instanceof CharSequence) {
            if (this.storage.equals(key)) {
                return UNDEFINED_MACRO;
            }
            return null;
        }
        if (this.storage instanceof APTMacro) {
            assert (this.storage != UNDEFINED_MACRO);
            if (((APTMacro)this.storage).getName().getTextID().equals(key)) {
                return (APTMacro)this.storage;
            }
            return null;
        }
        assert (this.storage instanceof Map) : "unexpected to have get from frozen" + this.storage.getClass();
        APTMacro map = (APTMacro)((Map)this.storage).get(key);
        return map;
    }

    public String toString() {
        Map tmpMap = this.getAll();
        return APTUtils.macros2String(tmpMap);
    }

    protected int size() {
        if (this.storage == EMPTY) {
            return 0;
        }
        if (this.storage instanceof Map) {
            return ((Map)this.storage).size();
        }
        if (this.storage instanceof MapSnapshot.Holder) {
            return ((MapSnapshot.Holder)this.storage).arr.length / 2;
        }
        return 1;
    }

    protected boolean isRemoved(APTMacro value) {
        return value == UNDEFINED_MACRO;
    }

    protected MapSnapshot.Holder cacheHolder(MapSnapshot.Holder holder) {
        return SnapshotHolderCache.getManager().getHolder(holder);
    }

    public Iterator<Map.Entry<CharSequence, APTMacro>> iterator() {
        if (this.storage instanceof CharSequence) {
            return new MapSnapshot.SingleItemIterator((CharSequence)this.storage, (Object)UNDEFINED_MACRO);
        }
        if (this.storage instanceof APTMacro) {
            APTMacro value = (APTMacro)this.storage;
            return new MapSnapshot.SingleItemIterator(value.getName().getTextID(), (Object)value);
        }
        return super.iterator();
    }

    public void write(RepositoryDataOutput output) throws IOException {
        APTSerializeUtils.writeSnapshot(this.getParent(), output);
        if (this.storage == EMPTY) {
            output.writeInt(0);
        } else if (this.storage instanceof CharSequence) {
            output.writeInt(-1);
            output.writeCharSequenceUTF((CharSequence)this.storage);
        } else if (this.storage instanceof APTMacro) {
            output.writeInt(-2);
            APTSerializeUtils.writeMacro((APTMacro)this.storage, output);
        } else {
            assert (this.storage instanceof MapSnapshot.Holder) : "unexpected object " + this.storage;
            output.writeInt(this.size());
            APTMacroMapSnapshot.writeMacros(((MapSnapshot.Holder)this.storage).arr, output);
        }
    }

    public static void writeMacros(Object[] storage, RepositoryDataOutput output) throws IOException {
        assert (storage != null);
        int collSize = storage.length / 2;
        for (int i = 0; i < collSize; ++i) {
            CharSequence key = (CharSequence)storage[i];
            assert (CharSequences.isCompact((CharSequence)key));
            output.writeCharSequenceUTF(key);
            APTMacro macro = (APTMacro)storage[i + collSize];
            assert (macro != null);
            APTSerializeUtils.writeMacro(macro, output);
        }
    }

    public APTMacroMapSnapshot(RepositoryDataInput input) throws IOException {
        super((MapSnapshot)APTSerializeUtils.readSnapshot(input));
        int collSize = input.readInt();
        if (collSize == -2) {
            this.storage = APTSerializeUtils.readMacro(input);
        } else if (collSize == -1) {
            this.storage = CharSequences.create((CharSequence)input.readCharSequenceUTF());
        } else if (collSize == 0) {
            this.storage = EMPTY;
        } else {
            Object[] arr = APTMacroMapSnapshot.readMacros(collSize, input);
            this.storage = SnapshotHolderCache.getManager().getHolder(new MapSnapshot.Holder(arr));
        }
    }

    private static Object[] readMacros(int collSize, RepositoryDataInput input) throws IOException {
        Object[] storage = new Object[collSize * 2];
        for (int i = 0; i < storage.length; ++i) {
            CharSequence key = CharSequences.create((CharSequence)input.readCharSequenceUTF());
            assert (key != null);
            APTMacro macro = APTSerializeUtils.readMacro(input);
            assert (macro != null);
            storage[i] = key;
            storage[i + collSize] = APTMacroCache.getManager().getMacro(macro);
        }
        return storage;
    }

    private static final class UndefinedMacro
    implements APTMacro {
        private UndefinedMacro() {
        }

        public String toString() {
            return "Macro undefined";
        }

        @Override
        public CharSequence getFile() {
            return CharSequences.empty();
        }

        @Override
        public APTMacro.Kind getKind() {
            return APTMacro.Kind.USER_SPECIFIED;
        }

        @Override
        public boolean isFunctionLike() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTToken getName() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public Collection<APTToken> getParams() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public TokenStream getBody() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTDefine getDefineNode() {
            throw new UnsupportedOperationException("Not supported in fake impl.");
        }
    }
}

