/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class ExportCommitCommand
extends GitCommand {
    private final ProgressMonitor monitor;
    private final OutputStream out;
    private final FileListener listener;
    private final String revisionStr;
    private static final char NL = '\n';

    public ExportCommitCommand(JGitRepository repository, GitClassFactory gitFactory, String revisionStr, OutputStream out, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.out = out;
        this.revisionStr = revisionStr;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "format-patch");
        this.addArgument(0, "--no-stat");
        this.addArgument(0, "--stdout");
        this.addArgument(0, "--keep-subject");
        this.addArgument(0, "-1");
        this.addArgument(0, this.revisionStr);
    }

    @Override
    protected void run() throws GitException {
        block15: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        try {
                            for (int i = 0; i < output.length(); ++i) {
                                ExportCommitCommand.this.out.write(output.charAt(i));
                            }
                        }
                        catch (Exception e) {
                            throw new GitException(e);
                        }
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) {
                    break block15;
                }
                throw new GitException(t);
            }
            finally {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

