/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.cli.GitConflictDescriptor;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitStatus;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StatusCommandBase;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.cli.progress.StatusListener;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class StatusCommand
extends StatusCommandBase {
    public static final boolean KIT = false;
    private final VCSFileProxy[] roots;
    private final ProgressMonitor monitor;
    private final String revision;
    private static final Logger LOG = Logger.getLogger(StatusCommand.class.getName());
    private static final Set<VCSFileProxy> logged = new HashSet<VCSFileProxy>();
    private final boolean isRevision;

    public StatusCommand(JGitRepository repository, String revision, VCSFileProxy[] roots, GitClassFactory gitFactory, ProgressMonitor monitor, StatusListener listener) {
        super(repository, revision, roots, gitFactory, monitor, listener);
        this.roots = roots;
        this.monitor = monitor;
        this.revision = revision;
        this.isRevision = !"HEAD".equals(revision);
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean exists = this.getRepository().getMetadataLocation().exists();
        if (exists) {
            this.prepare();
        }
        return exists;
    }

    @Override
    protected void prepare() throws GitException {
        if (this.isRevision) {
            this.setCommandsNumber(4);
        } else {
            this.setCommandsNumber(3);
        }
        super.prepare();
        if (this.isRevision) {
            this.addArgument(0, "diff");
            this.addArgument(0, "--cached");
            this.addArgument(0, "--raw");
            this.addArgument(0, "--name-status");
            this.addArgument(0, this.revision);
            this.addArgument(0, "--");
            this.addFiles(0, this.roots);
            this.addArgument(1, "diff");
            this.addArgument(1, "--raw");
            this.addArgument(1, "--name-status");
            this.addArgument(1, this.revision);
            this.addArgument(1, "--");
            this.addFiles(1, this.roots);
            this.addArgument(2, "status");
            this.addArgument(2, "--short");
            this.addArgument(2, "--ignored");
            this.addArgument(2, "--untracked-files=all");
            this.addArgument(2, "--");
            this.addFiles(2, this.roots);
            this.addArgument(3, "ls-files");
            this.addArgument(3, "--cached");
            this.addArgument(3, "--others");
            this.addArgument(3, "-t");
            this.addArgument(3, "--");
            this.addFiles(3, this.roots);
        } else {
            this.addArgument(0, "status");
            this.addArgument(0, "--short");
            this.addArgument(0, "--ignored");
            this.addArgument(0, "--untracked-files=all");
            this.addArgument(0, "--");
            this.addFiles(0, this.roots);
            this.addArgument(1, "diff");
            this.addArgument(1, "--raw");
            this.addArgument(1, "--name-status");
            this.addArgument(1, "HEAD");
            this.addArgument(1, "--");
            this.addFiles(1, this.roots);
            this.addArgument(2, "ls-files");
            this.addArgument(2, "--cached");
            this.addArgument(2, "--others");
            this.addArgument(2, "-t");
            this.addArgument(2, "--");
            this.addFiles(2, this.roots);
        }
    }

    @Override
    protected void run() throws GitException {
        block8: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                if (this.isRevision) {
                    final LinkedHashMap<String, StatusLine> list = new LinkedHashMap<String, StatusLine>();
                    new GitCommand.Runner(canceled, 0){

                        @Override
                        public void outputParser(String output) throws GitException {
                            StatusCommand.this.parseDiffOutput(output, 1, list);
                        }
                    }.runCLI();
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            StatusCommand.this.parseDiffOutput(output, 3, list);
                        }
                    }.runCLI();
                    new GitCommand.Runner(canceled, 2){

                        @Override
                        public void outputParser(String output) throws GitException {
                            StatusCommand.parseStatusOutput(output, list, true);
                        }
                    }.runCLI();
                    new GitCommand.Runner(canceled, 3){

                        @Override
                        public void outputParser(String output) throws GitException {
                            StatusCommand.this.parseLsOutput(output, list);
                        }
                    }.runCLI();
                    if (canceled.canceled()) {
                        return;
                    }
                    this.processOutput(list, canceled);
                } else {
                    final LinkedHashMap<String, StatusLine> list = new LinkedHashMap<String, StatusLine>();
                    new GitCommand.Runner(canceled, 0){

                        @Override
                        public void outputParser(String output) throws GitException {
                            StatusCommand.parseStatusOutput(output, list, false);
                        }
                    }.runCLI();
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            StatusCommand.this.parseDiffOutput(output, 3, list);
                        }

                        @Override
                        protected void errorParser(String error) throws GitException {
                            if (error.contains("fatal: bad revision 'HEAD'")) {
                                for (Map.Entry e : list.entrySet()) {
                                    char first = ((StatusLine)e.getValue()).first;
                                    if (first == '?' || first == '!') continue;
                                    ((StatusLine)e.getValue()).third = first;
                                }
                            }
                        }
                    }.runCLI();
                    new GitCommand.Runner(canceled, 2){

                        @Override
                        public void outputParser(String output) throws GitException {
                            StatusCommand.this.parseLsOutput(output, list);
                        }
                    }.runCLI();
                    if (canceled.canceled()) {
                        return;
                    }
                    this.processOutput(list, canceled);
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block8;
                throw new GitException(t);
            }
        }
    }

    static void parseStatusOutput(String output, Map<String, StatusLine> list, boolean onlyIndexWC) {
        for (String line : output.split("\n")) {
            StatusLine renamedToStatus;
            String file;
            if (line.length() <= 3) continue;
            char first = line.charAt(0);
            char second = line.charAt(1);
            String renamed = null;
            int i = line.indexOf("->");
            if (i > 0) {
                file = line.substring(2, i).trim();
                renamed = line.substring(i + 2).trim();
            } else {
                file = line.substring(2).trim();
            }
            StatusLine status = list.get(file);
            if (status == null) {
                status = new StatusLine();
                if (onlyIndexWC) {
                    if (first == '?' || first == '!') {
                        status.first = first;
                        status.second = second;
                    } else {
                        status.second = second;
                    }
                } else {
                    status.first = first;
                    status.second = second;
                    status.to = renamed;
                }
                list.put(file, status);
            } else if (onlyIndexWC) {
                if (first == '?' || first == '!') {
                    status.untracked = first;
                } else {
                    status.second = second;
                }
            } else {
                status.untracked = first;
            }
            if (renamed == null || (renamedToStatus = list.get(renamed)) != null) continue;
            renamedToStatus = new StatusLine();
            if (onlyIndexWC) {
                if (first == '?' || first == '!') {
                    renamedToStatus.first = (char)65;
                    renamedToStatus.second = second;
                } else {
                    renamedToStatus.second = second;
                }
            } else {
                renamedToStatus.first = (char)65;
                renamedToStatus.second = second;
                renamedToStatus.to = null;
            }
            list.put(renamed, renamedToStatus);
        }
    }

    private void parseDiffOutput(String output, int n, Map<String, StatusLine> list) {
        for (String line : output.split("\n")) {
            if (line.length() <= 2) continue;
            char c = line.charAt(0);
            String file = line.substring(2).trim();
            StatusLine status = list.get(file);
            if (status == null) {
                status = new StatusLine();
                if (n == 1) {
                    status.first = c;
                }
                if (n == 2) {
                    status.second = c;
                }
                if (n == 3) {
                    status.third = c;
                }
                list.put(file, status);
                continue;
            }
            if (n == 1) {
                status.first = c;
            }
            if (n == 2) {
                status.second = c;
            }
            if (n != 3) continue;
            status.third = c;
        }
    }

    private void parseLsOutput(String output, Map<String, StatusLine> list) {
        for (String line : output.split("\n")) {
            if (line.length() <= 0) continue;
            String file = line.trim();
            boolean cached = true;
            if (file.startsWith("H ")) {
                file = file.substring(2);
                cached = true;
            } else if (file.startsWith("? ")) {
                file = file.substring(2);
                cached = false;
            }
            StatusLine status = list.get(file);
            if (status != null) continue;
            if (cached) {
                status = new StatusLine();
            } else {
                status = new StatusLine();
                status.first = (char)33;
                status.second = (char)33;
                status.third = (char)33;
            }
            list.put(file, status);
        }
    }

    private void processOutput(LinkedHashMap<String, StatusLine> parseOutput, ProcessUtils.Canceler canceled) {
        StatusLine v;
        String file;
        HashMap<String, GitStatus.GitDiffEntry> renamedEntry = new HashMap<String, GitStatus.GitDiffEntry>();
        for (Map.Entry<String, StatusLine> entry : parseOutput.entrySet()) {
            file = entry.getKey();
            v = entry.getValue();
            String renamed = v.to;
            if (renamed == null) continue;
            GitStatus.GitDiffEntry renamedDiff = new GitStatus.GitDiffEntry(GitStatus.GitChangeType.RENAME, file);
            renamedEntry.put(renamed, renamedDiff);
        }
        for (Map.Entry<String, StatusLine> entry : parseOutput.entrySet()) {
            file = entry.getKey();
            v = entry.getValue();
            char first = v.first;
            char second = v.second;
            char third = v.third;
            char untracked = v.untracked;
            String renamed = v.to;
            boolean tracked = first != '?' && first != '!';
            GitStatus.Status statusHeadIndex = GitStatus.Status.STATUS_IGNORED;
            switch (first) {
                case 'A': 
                case 'C': {
                    statusHeadIndex = GitStatus.Status.STATUS_ADDED;
                    break;
                }
                case 'D': 
                case 'R': {
                    statusHeadIndex = GitStatus.Status.STATUS_REMOVED;
                    break;
                }
                case 'M': 
                case 'U': {
                    statusHeadIndex = GitStatus.Status.STATUS_MODIFIED;
                    break;
                }
                case ' ': {
                    statusHeadIndex = GitStatus.Status.STATUS_NORMAL;
                    break;
                }
                case '!': 
                case '?': {
                    statusHeadIndex = GitStatus.Status.STATUS_NORMAL;
                }
            }
            GitStatus.Status statusIndexWC = GitStatus.Status.STATUS_IGNORED;
            switch (second) {
                case 'A': {
                    statusIndexWC = GitStatus.Status.STATUS_ADDED;
                    break;
                }
                case 'D': {
                    statusIndexWC = GitStatus.Status.STATUS_REMOVED;
                    break;
                }
                case 'M': 
                case 'U': {
                    statusIndexWC = GitStatus.Status.STATUS_MODIFIED;
                    break;
                }
                case ' ': {
                    if (untracked == '?') {
                        statusIndexWC = GitStatus.Status.STATUS_ADDED;
                        break;
                    }
                    statusIndexWC = GitStatus.Status.STATUS_NORMAL;
                    break;
                }
                case '?': {
                    statusIndexWC = GitStatus.Status.STATUS_ADDED;
                    break;
                }
                case '!': {
                    statusIndexWC = GitStatus.Status.STATUS_IGNORED;
                }
            }
            GitStatus.Status statusHeadWC = GitStatus.Status.STATUS_IGNORED;
            switch (third) {
                case 'A': {
                    statusHeadWC = GitStatus.Status.STATUS_ADDED;
                    break;
                }
                case 'D': {
                    if (untracked == '?') {
                        statusHeadWC = GitStatus.Status.STATUS_MODIFIED;
                        break;
                    }
                    statusHeadWC = GitStatus.Status.STATUS_REMOVED;
                    break;
                }
                case 'M': 
                case 'U': {
                    statusHeadWC = GitStatus.Status.STATUS_MODIFIED;
                    break;
                }
                case ' ': {
                    if (first == '?' || first == '!') {
                        statusHeadWC = GitStatus.Status.STATUS_ADDED;
                        break;
                    }
                    statusHeadWC = GitStatus.Status.STATUS_NORMAL;
                    break;
                }
                case '?': {
                    statusHeadWC = GitStatus.Status.STATUS_ADDED;
                    break;
                }
                case '!': {
                    statusHeadWC = GitStatus.Status.STATUS_IGNORED;
                }
            }
            boolean isFolder = false;
            if (file.endsWith("/")) {
                file = file.substring(0, file.length() - 1);
                isFolder = true;
            }
            if (!tracked) {
                statusHeadWC = statusIndexWC == GitStatus.Status.STATUS_IGNORED && isFolder ? statusIndexWC : GitStatus.Status.STATUS_ADDED;
            }
            VCSFileProxy vcsFile = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file);
            long indexTimestamp = -1L;
            GitConflictDescriptor conflict = null;
            if (first == 'U' && second == 'U') {
                conflict = this.getClassFactory().createConflictDescriptor(GitConflictDescriptor.Type.BOTH_MODIFIED);
            } else if (first == 'D' && second == 'U') {
                conflict = this.getClassFactory().createConflictDescriptor(GitConflictDescriptor.Type.DELETED_BY_US);
            } else if (first == 'A' && second == 'U') {
                conflict = this.getClassFactory().createConflictDescriptor(GitConflictDescriptor.Type.ADDED_BY_US);
            } else if (first == 'U' && second == 'D') {
                conflict = this.getClassFactory().createConflictDescriptor(GitConflictDescriptor.Type.DELETED_BY_THEM);
            } else if (first == 'U' && second == 'A') {
                conflict = this.getClassFactory().createConflictDescriptor(GitConflictDescriptor.Type.ADDED_BY_THEM);
            } else if (first == 'D' && second == 'D') {
                conflict = this.getClassFactory().createConflictDescriptor(GitConflictDescriptor.Type.BOTH_DELETED);
            } else if (first == 'A' && second == 'A') {
                conflict = this.getClassFactory().createConflictDescriptor(GitConflictDescriptor.Type.BOTH_ADDED);
            }
            GitStatus status = this.getClassFactory().createStatus(tracked, file, this.getRepository().getLocation().getPath(), vcsFile, statusHeadIndex, statusIndexWC, statusHeadWC, conflict, isFolder, (GitStatus.GitDiffEntry)renamedEntry.get(file), indexTimestamp);
            this.addStatus(vcsFile, status);
        }
    }

    static final class StatusLine {
        char first = (char)32;
        char second = (char)32;
        char third = (char)32;
        char untracked = (char)32;
        String to;

        public String toString() {
            return "" + this.first + this.second + this.third + this.untracked;
        }
    }
}

