/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.callback.InheritedProplistCallback;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritedJhlProplistCallback
implements InheritedProplistCallback {
    private boolean isFile;
    List<ISVNProperty> props;

    public InheritedJhlProplistCallback(boolean file) {
        this.isFile = file;
        this.props = new ArrayList<ISVNProperty>();
    }

    public void singlePath(String path, Map<String, byte[]> properties, Collection<InheritedProplistCallback.InheritedItem> inherited_properties) {
        if (properties != null) {
            Set<String> keys = properties.keySet();
            for (String key : keys) {
                if (this.isFile) {
                    this.props.add(JhlPropertyData.newForFile(path, key, properties.get(key)));
                    continue;
                }
                this.props.add(JhlPropertyData.newForUrl(path, key, properties.get(key)));
            }
        }
        if (inherited_properties != null) {
            for (InheritedProplistCallback.InheritedItem inheritedItem : inherited_properties) {
                Set inheritedKeySet = inheritedItem.properties.keySet();
                for (String key : inheritedKeySet) {
                    if (this.isFile) {
                        this.props.add(JhlPropertyData.newForFile(inheritedItem.path_or_url, key, (byte[])inheritedItem.properties.get(key)));
                        continue;
                    }
                    this.props.add(JhlPropertyData.newForUrl(inheritedItem.path_or_url, key, (byte[])inheritedItem.properties.get(key)));
                }
            }
        }
    }

    public ISVNProperty[] getPropertyData() {
        ISVNProperty[] propArray = new ISVNProperty[this.props.size()];
        return this.props.toArray(propArray);
    }
}

