/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.metadata;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.metadata.MetadataSourceAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLMetadataSource
extends MetadataSourceAdapter {
    private Source xmlBindingsSource;
    private URL xmlBindingsURL;
    private String xmlBindingsLocation;

    public XMLMetadataSource(File xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsSource = new StreamSource(xmlBindings);
    }

    public XMLMetadataSource(InputStream xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsSource = new StreamSource(xmlBindings);
    }

    public XMLMetadataSource(Reader xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsSource = new StreamSource(xmlBindings);
    }

    public XMLMetadataSource(URL xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsURL = xmlBindings;
    }

    public XMLMetadataSource(XMLEventReader xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlBindingsSource = new StAXSource(xmlBindings);
        }
        catch (XMLStreamException e) {
            org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata(e);
        }
    }

    public XMLMetadataSource(XMLStreamReader xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsSource = new StAXSource(xmlBindings);
    }

    public XMLMetadataSource(Source xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsSource = xmlBindings;
    }

    public XMLMetadataSource(Node xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsSource = new DOMSource(xmlBindings);
    }

    public XMLMetadataSource(InputSource xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        this.xmlBindingsSource = new SAXSource(xmlBindings);
    }

    public XMLMetadataSource(String xmlBindings) {
        if (xmlBindings == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlBindingsURL = new URL(xmlBindings);
        }
        catch (MalformedURLException malformedURLException) {
            this.xmlBindingsLocation = xmlBindings;
        }
    }

    @Override
    public XmlBindings getXmlBindings(Map<String, ?> properties, ClassLoader classLoader) {
        try {
            JAXBContext jaxbContext = CompilerHelper.getXmlBindingsModelContext();
            JAXBUnmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (this.xmlBindingsSource != null) {
                return (XmlBindings)unmarshaller.unmarshal(this.xmlBindingsSource);
            }
            if (this.xmlBindingsURL != null) {
                return (XmlBindings)unmarshaller.unmarshal(this.xmlBindingsURL);
            }
            if (this.xmlBindingsLocation != null) {
                URL url = classLoader.getResource(this.xmlBindingsLocation);
                if (url == null) {
                    throw org.eclipse.persistence.exceptions.JAXBException.unableToLoadMetadataFromLocation(this.xmlBindingsLocation);
                }
                return (XmlBindings)unmarshaller.unmarshal(url);
            }
        }
        catch (JAXBException e) {
            throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)e));
        }
        return null;
    }
}

