/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WSDesignViewNavigatorContent
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private ExplorerManager explorerManager;
    private TreeView treeView;

    public WSDesignViewNavigatorContent() {
        this.setLayout(new BorderLayout());
        this.explorerManager = new ExplorerManager();
        this.treeView = new BeanTreeView();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void navigate(DataObject implClass) {
        this.add((Component)this.treeView, "Center");
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new WSChildFactory(implClass), (boolean)true));
        root.setName(NbBundle.getMessage(WSDesignViewNavigatorContent.class, (String)"LBL_Operations"));
        this.getExplorerManager().setRootContext((Node)root);
        this.revalidate();
        this.repaint();
    }

    public static class WSChildFactory
    extends ChildFactory<MethodModel> {
        DataObject implClass;

        public WSChildFactory(DataObject implClass) {
            this.implClass = implClass;
        }

        protected Node createNodeForKey(MethodModel key) {
            AbstractNode n = new AbstractNode(Children.LEAF);
            n.setName(key.getOperationName());
            return n;
        }

        protected boolean createKeys(List<MethodModel> list) {
            List<MethodModel> operations;
            ServiceModel model;
            if (this.implClass != null && (model = ServiceModel.getServiceModel(this.implClass.getPrimaryFile())) != null && (operations = model.getOperations()) != null) {
                list.addAll(model.getOperations());
            }
            return true;
        }
    }
}

