/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.cnd.search.ui.DirectoryChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class SearchBrowseHostScope {
    private static FileObject root;
    private final ExecutionEnvironment env;
    private SearchScopeDefinition browseScope = new BrowseHostScopeDefinition();
    private SearchScopeDefinition lastScope = new LastSearchBrowseHostScope();

    public SearchBrowseHostScope(ExecutionEnvironment env) {
        this.env = env;
    }

    public SearchScopeDefinition getBrowseScope() {
        return this.browseScope;
    }

    public SearchScopeDefinition getLastScope() {
        return this.lastScope;
    }

    private static class LastSearchBrowseHostScope
    extends SearchScopeDefinition {
        private LastSearchBrowseHostScope() {
        }

        public String getTypeId() {
            return SearchBrowseHostScope.class.getName();
        }

        public String getDisplayName() {
            if (root != null) {
                return NbBundle.getMessage(SearchBrowseHostScope.class, (String)"LBL_BrowseHostScopeBrowseName", (Object)root.getNameExt(), (Object)FileSystemProvider.getExecutionEnvironment((FileObject)root).getDisplayName());
            }
            return NbBundle.getMessage(SearchBrowseHostScope.class, (String)"LBL_NoSelection");
        }

        public boolean isApplicable() {
            return root != null;
        }

        public SearchInfo getSearchInfo() {
            return SearchInfoUtils.createSearchInfoForRoots((FileObject[])new FileObject[]{root});
        }

        public int getPriority() {
            return 700;
        }

        public void clean() {
        }
    }

    final class BrowseHostScopeDefinition
    extends SearchScopeDefinition {
        private final SearchInfo searchInfo = SearchInfoUtils.createForDefinition((SearchInfoDefinition)new BrowseHostInfoDefinition());

        public String getTypeId() {
            return SearchBrowseHostScope.class.getName();
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SearchBrowseHostScope.class, (String)"LBL_BrowseHostScopeDefinitionName", (Object)SearchBrowseHostScope.this.env.getDisplayName());
        }

        public boolean isApplicable() {
            return ConnectionManager.getInstance().isConnectedTo(SearchBrowseHostScope.this.env);
        }

        public SearchInfo getSearchInfo() {
            return this.searchInfo;
        }

        public int getPriority() {
            return 701;
        }

        public void clean() {
        }

        public void selected() {
            this.chooseRoots();
            this.notifyListeners();
        }

        private FileObject[] chooseRoots() {
            FileObject dir = DirectoryChooser.chooseDirectory(WindowManager.getDefault().getMainWindow(), SearchBrowseHostScope.this.env, null);
            if (dir != null) {
                root = dir;
                return new FileObject[]{root};
            }
            return new FileObject[0];
        }

        private class BrowseHostInfoDefinition
        extends SearchInfoDefinition {
            private SearchInfo delegate;

            private BrowseHostInfoDefinition() {
            }

            public boolean canSearch() {
                return true;
            }

            public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
                return this.getDelegate().getFilesToSearch(options, listener, terminated).iterator();
            }

            public List<SearchRoot> getSearchRoots() {
                return this.getDelegate().getSearchRoots();
            }

            private synchronized SearchInfo getDelegate() {
                if (this.delegate == null) {
                    this.delegate = this.createDelegate();
                }
                return this.delegate;
            }

            private SearchInfo createDelegate() {
                FileObject[] fileObjects = BrowseHostScopeDefinition.this.chooseRoots();
                return SearchInfoUtils.createSearchInfoForRoots((FileObject[])fileObjects);
            }
        }
    }
}

