/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class LocalizedBundleInfo {
    public static final String NAME = "OpenIDE-Module-Name";
    public static final String DISPLAY_CATEGORY = "OpenIDE-Module-Display-Category";
    public static final String SHORT_DESCRIPTION = "OpenIDE-Module-Short-Description";
    public static final String LONG_DESCRIPTION = "OpenIDE-Module-Long-Description";
    static final LocalizedBundleInfo EMPTY = new LocalizedBundleInfo(new EditableProperties[]{new EditableProperties(true)});
    private final EditableProperties[] props;
    private final File[] paths;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private boolean modified;

    public static LocalizedBundleInfo load(FileObject[] bundleFOs) throws IOException {
        return new LocalizedBundleInfo(bundleFOs);
    }

    public static LocalizedBundleInfo load(InputStream[] bundleISs) throws IOException {
        EditableProperties[] props = new EditableProperties[bundleISs.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = new EditableProperties(true);
            props[i].load(bundleISs[i]);
        }
        return new LocalizedBundleInfo(props);
    }

    private LocalizedBundleInfo(EditableProperties[] props) {
        this.props = props;
        this.paths = new File[props.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalizedBundleInfo(FileObject[] bundleFOs) throws IOException {
        if (bundleFOs == null || bundleFOs.length == 0) {
            throw new IllegalArgumentException();
        }
        this.props = new EditableProperties[bundleFOs.length];
        this.paths = new File[bundleFOs.length];
        for (int i = 0; i < bundleFOs.length; ++i) {
            InputStream bundleIS = bundleFOs[i].getInputStream();
            try {
                this.props[i] = new EditableProperties(true);
                this.props[i].load(bundleIS);
            }
            finally {
                bundleIS.close();
            }
            this.paths[i] = FileUtil.toFile((FileObject)bundleFOs[i]);
            bundleFOs[i].addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    try {
                        LocalizedBundleInfo.this.reload();
                    }
                    catch (IOException e) {
                        Util.err.log(16, "Cannot reload localized bundle info " + FileUtil.getFileDisplayName((FileObject)fe.getFile()));
                    }
                }
            });
        }
    }

    public void reload() throws IOException {
        String oldDisplayName = this.getDisplayName();
        for (int i = 0; i < this.paths.length; ++i) {
            FileObject bundleFO;
            this.props[i] = this.paths[i] == null ? new EditableProperties(true) : ((bundleFO = FileUtil.toFileObject((File)this.paths[i])) != null ? Util.loadProperties((FileObject)bundleFO) : new EditableProperties(true));
        }
        this.modified = false;
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
    }

    public void store() throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.paths[i] == null) continue;
            FileObject bundleFO = FileUtil.toFileObject((File)this.paths[i]);
            if (bundleFO == null) {
                return;
            }
            Util.storeProperties((FileObject)bundleFO, (EditableProperties)this.props[i]);
        }
        this.modified = false;
    }

    public EditableProperties toEditableProperties() {
        return this.props[0];
    }

    private String getProperty(String key) {
        for (int i = this.props.length - 1; i >= 0; --i) {
            if (!this.props[i].containsKey((Object)key)) continue;
            return this.props[i].getProperty(key);
        }
        return null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getDisplayName() {
        return this.getProperty(NAME);
    }

    public void setDisplayName(String name) {
        String oldDisplayName = this.getDisplayName();
        this.setProperty(NAME, name, false);
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
    }

    public String getCategory() {
        return this.getProperty(DISPLAY_CATEGORY);
    }

    public void setCategory(String category) {
        this.setProperty(DISPLAY_CATEGORY, category, false);
    }

    public String getShortDescription() {
        return this.getProperty(SHORT_DESCRIPTION);
    }

    public void setShortDescription(String shortDescription) {
        this.setProperty(SHORT_DESCRIPTION, shortDescription, false);
    }

    public String getLongDescription() {
        return this.getProperty(LONG_DESCRIPTION);
    }

    public void setLongDescription(String longDescription) {
        this.setProperty(LONG_DESCRIPTION, longDescription, true);
    }

    public File[] getPaths() {
        return this.paths;
    }

    private void setProperty(String name, String value, boolean split) {
        if (Utilities.compareObjects((Object)value, (Object)this.getProperty(name))) {
            return;
        }
        this.modified = true;
        if (value != null) {
            value = value.trim();
        }
        if (value != null && value.length() > 0) {
            if (split) {
                this.props[this.props.length - 1].setProperty(name, LocalizedBundleInfo.splitBySentence(value));
            } else {
                this.props[this.props.length - 1].setProperty(name, value);
            }
        } else {
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i].remove((Object)name);
            }
        }
    }

    private static String[] splitBySentence(String text) {
        int end;
        ArrayList<String> sentences = new ArrayList<String>();
        BreakIterator it = BreakIterator.getSentenceInstance(Locale.US);
        it.setText(text);
        int start = it.first();
        while ((end = it.next()) != -1) {
            sentences.add(text.substring(start, end));
            start = end;
        }
        return sentences.toArray(new String[sentences.size()]);
    }

    public void addPropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.addPropertyChangeListener(pchl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.removePropertyChangeListener(pchl);
    }

    private void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propName, oldValue, newValue);
    }

    public String toString() {
        return "LocalizedBundleInfo[" + this.getDisplayName() + "; " + this.getCategory() + "; " + this.getShortDescription() + "; " + this.getLongDescription() + "]";
    }

    public static interface Provider {
        @CheckForNull
        public LocalizedBundleInfo getLocalizedBundleInfo();
    }
}

