/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.proxysettings;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class ProxySettingsPanel
extends JPanel {
    static final String OD_LAYER_FOLDER_NAME = "OptionsDialog";
    static final String CATEGORY_NAME = "General";
    private OptionsPanelController controller = null;
    private final JComponent origPanel;
    private static final RequestProcessor RP = new RequestProcessor("ProxySettingsPanel", 1);
    private JPanel proxySettingPanel;

    public ProxySettingsPanel() {
        this.initComponents();
        this.origPanel = this.findGeneralOptionsPanel();
        if (this.origPanel != null) {
            this.hideUnwantedItems();
            this.proxySettingPanel.add((Component)this.origPanel, "Center");
        } else {
            this.proxySettingPanel.add(new JLabel(NbBundle.getMessage(ProxySettingsPanel.class, (String)"ProxySettingsPanel.error.noProxySettings")));
        }
    }

    public boolean isValidState() {
        if (this.controller == null) {
            return true;
        }
        return this.controller.isValid();
    }

    private void initComponents() {
        this.proxySettingPanel = new JPanel();
        this.proxySettingPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proxySettingPanel, -1, 401, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.proxySettingPanel, -1, 268, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void applyProxyChanges() {
        this.controller.applyChanges();
        this.controller.update();
        this.hideUnwantedItems();
    }

    public void applyProxyChangesIfNeed() {
        if (this.controller.isChanged() && this.controller.isValid()) {
            this.applyProxyChanges();
        }
    }

    private JComponent findGeneralOptionsPanel() {
        Lookup lookup = Lookups.forPath((String)OD_LAYER_FOLDER_NAME);
        Lookup.Result result = lookup.lookupResult(OptionsCategory.class);
        for (Lookup.Item item : result.allItems()) {
            String categoryID = item.getId().substring(OD_LAYER_FOLDER_NAME.length() + 1);
            if (!CATEGORY_NAME.equals(categoryID)) continue;
            this.controller = ((OptionsCategory)item.getInstance()).create();
            this.controller.update();
            return this.controller.getComponent(Lookup.EMPTY);
        }
        return null;
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.hideUnwantedItems();
        super.setVisible(aFlag);
    }

    private void hideUnwantedItems() {
        int cnt = this.origPanel.getAccessibleContext().getAccessibleChildrenCount();
        boolean visible = false;
        boolean firstLabel = false;
        int button = 0;
        for (int i = 0; i < cnt; ++i) {
            Accessible accessibleChild = this.origPanel.getAccessibleContext().getAccessibleChild(i);
            if (!(accessibleChild instanceof JComponent)) continue;
            JComponent elem = (JComponent)((Object)accessibleChild);
            if (elem instanceof JSeparator) {
                elem.setVisible(false);
                visible = !visible;
                firstLabel = true;
                continue;
            }
            if (firstLabel && elem instanceof JLabel) {
                firstLabel = false;
                elem.setVisible(false);
                continue;
            }
            if (!visible && elem.isVisible()) {
                elem.setVisible(false);
                continue;
            }
            if (!(elem instanceof JButton) || ++button != 3) continue;
            elem.setVisible(false);
        }
    }
}

