/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.setup;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openide.util.Exceptions;

public final class TextComponentWriter
extends PrintWriter {
    public TextComponentWriter(final JTextComponent textPane) {
        super(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                String value = new String(cbuf, off, len);
                TextComponentWriter.addOuputTextInUiThread(value, textPane);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
    }

    private static void addOuputTextInUiThread(final String value, final JTextComponent textPane) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                textPane.setText(textPane.getText() + value);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

