/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorComponent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorContent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.parsing.spi.support.CancelSupport;

public class NavigatorSourceFactoryTask
extends IndexingAwareParserResultTask<Parser.Result> {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
    private AtomicBoolean canceled = new AtomicBoolean(false);

    public NavigatorSourceFactoryTask() {
        super(TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        NavigatorContent content;
        NavigatorModel model;
        NavigatorSourceFactoryTask navigatorSourceFactoryTask = this;
        synchronized (navigatorSourceFactoryTask) {
            this.canceled.set(true);
            this.canceled = new AtomicBoolean(false);
        }
        if (this.cancel.isCancelled()) {
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (doc != null && doc.getProperty("macro-expansion-view-document") != null) {
            return;
        }
        long time = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "NavigatorSourceFactoryTask started");
            time = System.currentTimeMillis();
        }
        if ((model = (content = NavigatorComponent.getContent()).getModel()) != null) {
            CursorMovedSchedulerEvent cursorEvent = (CursorMovedSchedulerEvent)event;
            JTextComponent comp = EditorRegistry.lastFocusedComponent();
            if (comp instanceof JEditorPane) {
                model.setSelection(cursorEvent.getCaretOffset(), (JEditorPane)comp, this.canceled, result.getSnapshot().getText());
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "NavigatorSourceFactoryTask finished for {0}ms", System.currentTimeMillis() - time);
        }
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        NavigatorSourceFactoryTask navigatorSourceFactoryTask = this;
        synchronized (navigatorSourceFactoryTask) {
            this.canceled.set(true);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "NavigatorSourceFactoryTask canceled");
        }
    }

    public static class NavigatorSourceFactory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new NavigatorSourceFactoryTask());
        }
    }
}

