/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public final class WLProductProperties {
    private static final Logger LOGGER = Logger.getLogger(WLProductProperties.class.getName());
    private final WLDeploymentManager dm;
    private Properties props;
    private String rootProp;
    private File file;
    private FileChangeListener listener;

    public WLProductProperties(WLDeploymentManager dm) {
        this.dm = dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public String getMiddlewareHome() {
        WLProductProperties wLProductProperties = this;
        synchronized (wLProductProperties) {
            this.checkProperty();
            if (this.props == null) {
                this.props = this.parse();
            }
            return this.props.getProperty("MW_HOME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static String getMiddlewareHome(File serverRoot) {
        Properties ret = new Properties();
        File productProps = new File(serverRoot, ".product.properties");
        if (!productProps.exists() || !productProps.canRead()) {
            return null;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(productProps));
            try {
                ret.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
            return ret.getProperty("MW_HOME");
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties parse() {
        Properties ret = new Properties();
        InstanceProperties ip = this.dm.getInstanceProperties();
        this.rootProp = ip.getProperty("serverRoot");
        if (this.listener != null) {
            FileUtil.removeFileChangeListener((FileChangeListener)this.listener, (File)this.file);
        }
        this.file = null;
        if (this.rootProp != null) {
            this.file = new File(this.rootProp, ".product.properties");
            this.listener = new PropertiesChangeListener();
            FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)this.file);
        }
        if (this.file == null || !this.file.exists() || !this.file.canRead()) {
            return ret;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.file));
            try {
                ret.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
            return ret;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return new Properties();
        }
    }

    private void checkProperty() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        String root = ip.getProperty("serverRoot");
        if (root != null && !root.equals(this.rootProp) || root == null && this.rootProp != null) {
            this.reset();
        }
    }

    private synchronized void reset() {
        this.props = null;
    }

    private class PropertiesChangeListener
    implements FileChangeListener {
        private PropertiesChangeListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            WLProductProperties.this.reset();
        }

        public void fileDataCreated(FileEvent fe) {
            WLProductProperties.this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            WLProductProperties.this.reset();
        }

        public void fileRenamed(FileRenameEvent fe) {
            WLProductProperties.this.reset();
        }
    }
}

