/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.expression.SearchExpressionFacade;

public class CSVBuilder {
    protected StringBuilder buffer;
    protected FacesContext context;

    public CSVBuilder(FacesContext context) {
        this.context = context;
        this.buffer = new StringBuilder();
    }

    public CSVBuilder init() {
        this.buffer.append("if(PrimeFaces.vb({");
        return this;
    }

    public CSVBuilder source(String source) {
        if (source == null || source.equals("this")) {
            this.buffer.append("s:").append("this");
        } else {
            this.buffer.append("s:").append("'").append(source).append("'");
        }
        return this;
    }

    public CSVBuilder ajax(boolean value) {
        if (value) {
            this.buffer.append(",a:").append("true");
        }
        return this;
    }

    public CSVBuilder process(UIComponent component, String expressions) {
        if (expressions != null && expressions.trim().length() > 0) {
            String resolvedExpressions = SearchExpressionFacade.resolveComponentsForClient(this.context, component, expressions, 0);
            this.buffer.append(",p:'").append(resolvedExpressions).append("'");
        }
        return this;
    }

    public CSVBuilder update(UIComponent component, String expressions) {
        if (expressions != null && expressions.trim().length() > 0) {
            String resolvedExpressions = SearchExpressionFacade.resolveComponentsForClient(this.context, component, expressions, 1);
            this.buffer.append(",u:'").append(resolvedExpressions).append("'");
        }
        return this;
    }

    public CSVBuilder command(String command) {
        this.buffer.append("})){").append(command).append("}");
        return this;
    }

    public String build() {
        this.buffer.append("else{return false;}");
        String request = this.buffer.toString();
        this.reset();
        return request;
    }

    public void reset() {
        this.buffer.setLength(0);
    }
}

