/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.tree;

import ch.softenvironment.view.tree.NavigationTreeModel;
import ch.softenvironment.view.tree.TreeDragSource;
import ch.softenvironment.view.tree.TreeDropTarget;
import ch.softenvironment.view.tree.TreeNodeUtility;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JTree;

public class AutoScrollingTree
extends JTree
implements Autoscroll {
    private int margin = 12;
    private TreeDragSource ds = null;
    private TreeDropTarget dt = null;

    public AutoScrollingTree(int dndType) {
        if (dndType == 2) {
            this.ds = new TreeDragSource(this, dndType);
            this.dt = new TreeDropTarget(this);
        }
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.getClosestRowForLocation(p.x, p.y);
        Rectangle outer = this.getBounds();
        realrow = p.y + outer.y <= this.margin ? (realrow - 1 <= 0 ? 0 : realrow - 1) : (realrow + 1 >= this.getRowCount() - 1 ? this.getRowCount() - 1 : realrow + 1);
        this.scrollRowToVisible(realrow);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + this.margin, inner.x - outer.x + this.margin, outer.height - inner.height - inner.y + outer.y + this.margin, outer.width - inner.width - inner.x + outer.x + this.margin);
    }

    protected TreeNodeUtility getUtility() {
        return ((NavigationTreeModel)this.getModel()).getUtility();
    }
}

