/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.admin.indices.analyze.DetailAnalyzeResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAnalyzeAction
extends TransportSingleShardAction<AnalyzeRequest, AnalyzeResponse> {
    private final IndicesService indicesService;
    private final Environment environment;

    @Inject
    public TransportAnalyzeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Environment environment) {
        super(settings, "indices:admin/analyze", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, AnalyzeRequest::new, "index");
        this.indicesService = indicesService;
        this.environment = environment;
    }

    @Override
    protected AnalyzeResponse newResponse() {
        return new AnalyzeResponse();
    }

    @Override
    protected boolean resolveIndex(AnalyzeRequest request) {
        return request.index() != null;
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (request.concreteIndex() != null) {
            return super.checkRequestBlock(state, request);
        }
        return null;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (request.concreteIndex() == null) {
            return null;
        }
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected AnalyzeResponse shardOperation(AnalyzeRequest request, ShardId shardId) {
        try {
            IndexService indexService = shardId != null ? this.indicesService.indexServiceSafe(shardId.getIndex()) : null;
            String field = null;
            NamedAnalyzer analyzer = null;
            if (request.field() != null) {
                if (indexService == null) {
                    throw new IllegalArgumentException("No index provided, and trying to analyzer based on a specific field which requires the index parameter");
                }
                MappedFieldType fieldType = indexService.mapperService().fullName(request.field());
                if (fieldType != null) {
                    if (!fieldType.tokenized()) {
                        throw new IllegalArgumentException("Can't process field [" + request.field() + "], Analysis requests are only supported on tokenized fields");
                    }
                    analyzer = fieldType.indexAnalyzer();
                    field = fieldType.name();
                }
            }
            if (field == null) {
                field = indexService != null ? indexService.getIndexSettings().getDefaultField() : "_all";
            }
            AnalysisRegistry analysisRegistry = this.indicesService.getAnalysis();
            return TransportAnalyzeAction.analyze(request, field, (Analyzer)analyzer, indexService != null ? indexService.getIndexAnalyzers() : null, analysisRegistry, this.environment);
        }
        catch (IOException e) {
            throw new ElasticsearchException("analysis failed", (Throwable)e, new Object[0]);
        }
    }

    public static AnalyzeResponse analyze(AnalyzeRequest request, String field, Analyzer analyzer, IndexAnalyzers indexAnalyzers, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        boolean closeAnalyzer = false;
        if (analyzer == null && request.analyzer() != null) {
            if (indexAnalyzers == null) {
                analyzer = analysisRegistry.getAnalyzer(request.analyzer());
                if (analyzer == null) {
                    throw new IllegalArgumentException("failed to find global analyzer [" + request.analyzer() + "]");
                }
            } else {
                analyzer = indexAnalyzers.get(request.analyzer());
                if (analyzer == null) {
                    throw new IllegalArgumentException("failed to find analyzer [" + request.analyzer() + "]");
                }
            }
        } else if (request.tokenizer() != null) {
            IndexSettings indexSettings = indexAnalyzers == null ? null : indexAnalyzers.getIndexSettings();
            TokenizerFactory tokenizerFactory = TransportAnalyzeAction.parseTokenizerFactory(request, indexAnalyzers, analysisRegistry, environment);
            TokenFilterFactory[] tokenFilterFactories = new TokenFilterFactory[]{};
            tokenFilterFactories = TransportAnalyzeAction.getTokenFilterFactories(request, indexSettings, analysisRegistry, environment, tokenFilterFactories);
            CharFilterFactory[] charFilterFactories = new CharFilterFactory[]{};
            charFilterFactories = TransportAnalyzeAction.getCharFilterFactories(request, indexSettings, analysisRegistry, environment, charFilterFactories);
            analyzer = new CustomAnalyzer(tokenizerFactory, charFilterFactories, tokenFilterFactories);
            closeAnalyzer = true;
        } else if (analyzer == null) {
            analyzer = indexAnalyzers == null ? analysisRegistry.getAnalyzer("standard") : indexAnalyzers.getDefaultIndexAnalyzer();
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("failed to find analyzer");
        }
        List<AnalyzeResponse.AnalyzeToken> tokens = null;
        DetailAnalyzeResponse detail = null;
        if (request.explain()) {
            detail = TransportAnalyzeAction.detailAnalyze(request, analyzer, field);
        } else {
            tokens = TransportAnalyzeAction.simpleAnalyze(request, analyzer, field);
        }
        if (closeAnalyzer) {
            analyzer.close();
        }
        return new AnalyzeResponse(tokens, detail);
    }

    private static List<AnalyzeResponse.AnalyzeToken> simpleAnalyze(AnalyzeRequest request, Analyzer analyzer, String field) {
        ArrayList<AnalyzeResponse.AnalyzeToken> tokens = new ArrayList<AnalyzeResponse.AnalyzeToken>();
        int lastPosition = -1;
        int lastOffset = 0;
        for (String text : request.text()) {
            try (TokenStream stream = analyzer.tokenStream(field, text);){
                stream.reset();
                CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute posIncr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                OffsetAttribute offset = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
                TypeAttribute type = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
                while (stream.incrementToken()) {
                    int increment = posIncr.getPositionIncrement();
                    if (increment > 0) {
                        lastPosition += increment;
                    }
                    tokens.add(new AnalyzeResponse.AnalyzeToken(term.toString(), lastPosition, lastOffset + offset.startOffset(), lastOffset + offset.endOffset(), type.type(), null));
                }
                stream.end();
                lastOffset += offset.endOffset();
                lastPosition += posIncr.getPositionIncrement();
                lastPosition += analyzer.getPositionIncrementGap(field);
                lastOffset += analyzer.getOffsetGap(field);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to analyze", (Throwable)e, new Object[0]);
            }
        }
        return tokens;
    }

    private static DetailAnalyzeResponse detailAnalyze(AnalyzeRequest request, Analyzer analyzer, String field) {
        DetailAnalyzeResponse detailResponse;
        HashSet<String> includeAttributes = new HashSet<String>();
        if (request.attributes() != null) {
            for (String attribute : request.attributes()) {
                includeAttributes.add(attribute.toLowerCase(Locale.ROOT));
            }
        }
        CustomAnalyzer customAnalyzer = null;
        if (analyzer instanceof CustomAnalyzer) {
            customAnalyzer = (CustomAnalyzer)analyzer;
        } else if (analyzer instanceof NamedAnalyzer && ((NamedAnalyzer)analyzer).analyzer() instanceof CustomAnalyzer) {
            customAnalyzer = (CustomAnalyzer)((NamedAnalyzer)analyzer).analyzer();
        }
        if (customAnalyzer != null) {
            CharFilterFactory[] charFilterFactories = customAnalyzer.charFilters();
            TokenizerFactory tokenizerFactory = customAnalyzer.tokenizerFactory();
            TokenFilterFactory[] tokenFilterFactories = customAnalyzer.tokenFilters();
            String[][] charFiltersTexts = new String[charFilterFactories != null ? charFilterFactories.length : 0][request.text().length];
            TokenListCreator[] tokenFiltersTokenListCreator = new TokenListCreator[tokenFilterFactories != null ? tokenFilterFactories.length : 0];
            TokenListCreator tokenizerTokenListCreator = new TokenListCreator();
            for (int textIndex = 0; textIndex < request.text().length; ++textIndex) {
                String charFilteredSource = request.text()[textIndex];
                Reader reader = new FastStringReader(charFilteredSource);
                if (charFilterFactories != null) {
                    for (int charFilterIndex = 0; charFilterIndex < charFilterFactories.length; ++charFilterIndex) {
                        reader = charFilterFactories[charFilterIndex].create(reader);
                        Reader readerForWriteOut = new FastStringReader(charFilteredSource);
                        readerForWriteOut = charFilterFactories[charFilterIndex].create(readerForWriteOut);
                        charFiltersTexts[charFilterIndex][textIndex] = charFilteredSource = TransportAnalyzeAction.writeCharStream(readerForWriteOut);
                    }
                }
                Tokenizer tokenizer = tokenizerFactory.create();
                tokenizer.setReader(reader);
                tokenizerTokenListCreator.analyze((TokenStream)tokenizer, customAnalyzer, field, includeAttributes);
                if (tokenFilterFactories == null) continue;
                for (int tokenFilterIndex = 0; tokenFilterIndex < tokenFilterFactories.length; ++tokenFilterIndex) {
                    if (tokenFiltersTokenListCreator[tokenFilterIndex] == null) {
                        tokenFiltersTokenListCreator[tokenFilterIndex] = new TokenListCreator();
                    }
                    TokenStream stream = TransportAnalyzeAction.createStackedTokenStream(request.text()[textIndex], charFilterFactories, tokenizerFactory, tokenFilterFactories, tokenFilterIndex + 1);
                    tokenFiltersTokenListCreator[tokenFilterIndex].analyze(stream, customAnalyzer, field, includeAttributes);
                }
            }
            DetailAnalyzeResponse.CharFilteredText[] charFilteredLists = new DetailAnalyzeResponse.CharFilteredText[charFiltersTexts.length];
            if (charFilterFactories != null) {
                for (int charFilterIndex = 0; charFilterIndex < charFiltersTexts.length; ++charFilterIndex) {
                    charFilteredLists[charFilterIndex] = new DetailAnalyzeResponse.CharFilteredText(charFilterFactories[charFilterIndex].name(), charFiltersTexts[charFilterIndex]);
                }
            }
            DetailAnalyzeResponse.AnalyzeTokenList[] tokenFilterLists = new DetailAnalyzeResponse.AnalyzeTokenList[tokenFiltersTokenListCreator.length];
            if (tokenFilterFactories != null) {
                for (int tokenFilterIndex = 0; tokenFilterIndex < tokenFiltersTokenListCreator.length; ++tokenFilterIndex) {
                    tokenFilterLists[tokenFilterIndex] = new DetailAnalyzeResponse.AnalyzeTokenList(tokenFilterFactories[tokenFilterIndex].name(), tokenFiltersTokenListCreator[tokenFilterIndex].getArrayTokens());
                }
            }
            detailResponse = new DetailAnalyzeResponse(charFilteredLists, new DetailAnalyzeResponse.AnalyzeTokenList(tokenizerFactory.name(), tokenizerTokenListCreator.getArrayTokens()), tokenFilterLists);
        } else {
            String name = analyzer instanceof NamedAnalyzer ? ((NamedAnalyzer)analyzer).name() : analyzer.getClass().getName();
            TokenListCreator tokenListCreator = new TokenListCreator();
            for (String text : request.text()) {
                tokenListCreator.analyze(analyzer.tokenStream(field, text), analyzer, field, includeAttributes);
            }
            detailResponse = new DetailAnalyzeResponse(new DetailAnalyzeResponse.AnalyzeTokenList(name, tokenListCreator.getArrayTokens()));
        }
        return detailResponse;
    }

    private static TokenStream createStackedTokenStream(String source, CharFilterFactory[] charFilterFactories, TokenizerFactory tokenizerFactory, TokenFilterFactory[] tokenFilterFactories, int current) {
        Reader reader = new FastStringReader(source);
        for (CharFilterFactory charFilterFactory : charFilterFactories) {
            reader = charFilterFactory.create(reader);
        }
        Tokenizer tokenizer = tokenizerFactory.create();
        tokenizer.setReader(reader);
        Tokenizer tokenStream = tokenizer;
        for (int i = 0; i < current; ++i) {
            tokenStream = tokenFilterFactories[i].create((TokenStream)tokenStream);
        }
        return tokenStream;
    }

    private static String writeCharStream(Reader input) {
        int len;
        int BUFFER_SIZE = 1024;
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        do {
            try {
                len = input.read(buf, 0, 1024);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to analyze (charFiltering)", (Throwable)e, new Object[0]);
            }
            if (len <= 0) continue;
            sb.append(buf, 0, len);
        } while (len == 1024);
        return sb.toString();
    }

    private static Map<String, Object> extractExtendedAttributes(TokenStream stream, Set<String> includeAttributes) {
        TreeMap<String, Object> extendedAttributes = new TreeMap<String, Object>();
        stream.reflectWith((attClass, key, value) -> {
            if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (PositionIncrementAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (OffsetAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (TypeAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (includeAttributes == null || includeAttributes.isEmpty() || includeAttributes.contains(key.toLowerCase(Locale.ROOT))) {
                if (value instanceof BytesRef) {
                    BytesRef p = (BytesRef)value;
                    value = p.toString();
                }
                extendedAttributes.put(key, value);
            }
        });
        return extendedAttributes;
    }

    private static CharFilterFactory[] getCharFilterFactories(AnalyzeRequest request, IndexSettings indexSettings, AnalysisRegistry analysisRegistry, Environment environment, CharFilterFactory[] charFilterFactories) throws IOException {
        if (request.charFilters() != null && request.charFilters().size() > 0) {
            charFilterFactories = new CharFilterFactory[request.charFilters().size()];
            for (int i = 0; i < request.charFilters().size(); ++i) {
                AnalysisModule.AnalysisProvider<CharFilterFactory> charFilterFactoryFactory;
                AnalyzeRequest.NameOrDefinition charFilter = request.charFilters().get(i);
                if (charFilter.definition != null) {
                    Settings settings = TransportAnalyzeAction.getAnonymousSettings(charFilter.definition);
                    String charFilterTypeName = settings.get("type");
                    if (charFilterTypeName == null) {
                        throw new IllegalArgumentException("Missing [type] setting for anonymous char filter: " + charFilter.definition);
                    }
                    AnalysisModule.AnalysisProvider<CharFilterFactory> charFilterFactoryFactory2 = analysisRegistry.getCharFilterProvider(charFilterTypeName);
                    if (charFilterFactoryFactory2 == null) {
                        throw new IllegalArgumentException("failed to find global char filter under [" + charFilterTypeName + "]");
                    }
                    charFilterFactories[i] = charFilterFactoryFactory2.get(TransportAnalyzeAction.getNaIndexSettings(settings), environment, "_anonymous_charfilter_[" + i + "]", settings);
                } else if (indexSettings == null) {
                    charFilterFactoryFactory = analysisRegistry.getCharFilterProvider(charFilter.name);
                    if (charFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find global char filter under [" + charFilter.name + "]");
                    }
                    charFilterFactories[i] = charFilterFactoryFactory.get(environment, charFilter.name);
                } else {
                    charFilterFactoryFactory = analysisRegistry.getCharFilterProvider(charFilter.name, indexSettings);
                    if (charFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find char filter under [" + charFilter.name + "]");
                    }
                    charFilterFactories[i] = charFilterFactoryFactory.get(indexSettings, environment, charFilter.name, AnalysisRegistry.getSettingsFromIndexSettings(indexSettings, "index.analysis.char_filter." + charFilter.name));
                }
                if (charFilterFactories[i] != null) continue;
                throw new IllegalArgumentException("failed to find char filter under [" + charFilter.name + "]");
            }
        }
        return charFilterFactories;
    }

    private static TokenFilterFactory[] getTokenFilterFactories(AnalyzeRequest request, IndexSettings indexSettings, AnalysisRegistry analysisRegistry, Environment environment, TokenFilterFactory[] tokenFilterFactories) throws IOException {
        if (request.tokenFilters() != null && request.tokenFilters().size() > 0) {
            tokenFilterFactories = new TokenFilterFactory[request.tokenFilters().size()];
            for (int i = 0; i < request.tokenFilters().size(); ++i) {
                AnalysisModule.AnalysisProvider<TokenFilterFactory> tokenFilterFactoryFactory;
                AnalyzeRequest.NameOrDefinition tokenFilter = request.tokenFilters().get(i);
                if (tokenFilter.definition != null) {
                    Settings settings = TransportAnalyzeAction.getAnonymousSettings(tokenFilter.definition);
                    String filterTypeName = settings.get("type");
                    if (filterTypeName == null) {
                        throw new IllegalArgumentException("Missing [type] setting for anonymous token filter: " + tokenFilter.definition);
                    }
                    AnalysisModule.AnalysisProvider<TokenFilterFactory> tokenFilterFactoryFactory2 = analysisRegistry.getTokenFilterProvider(filterTypeName);
                    if (tokenFilterFactoryFactory2 == null) {
                        throw new IllegalArgumentException("failed to find global token filter under [" + filterTypeName + "]");
                    }
                    tokenFilterFactories[i] = tokenFilterFactoryFactory2.get(TransportAnalyzeAction.getNaIndexSettings(settings), environment, "_anonymous_tokenfilter_[" + i + "]", settings);
                } else if (indexSettings == null) {
                    tokenFilterFactoryFactory = analysisRegistry.getTokenFilterProvider(tokenFilter.name);
                    if (tokenFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find global token filter under [" + tokenFilter.name + "]");
                    }
                    tokenFilterFactories[i] = tokenFilterFactoryFactory.get(environment, tokenFilter.name);
                } else {
                    tokenFilterFactoryFactory = analysisRegistry.getTokenFilterProvider(tokenFilter.name, indexSettings);
                    if (tokenFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find token filter under [" + tokenFilter.name + "]");
                    }
                    tokenFilterFactories[i] = tokenFilterFactoryFactory.get(indexSettings, environment, tokenFilter.name, AnalysisRegistry.getSettingsFromIndexSettings(indexSettings, "index.analysis.filter." + tokenFilter.name));
                }
                if (tokenFilterFactories[i] != null) continue;
                throw new IllegalArgumentException("failed to find or create token filter under [" + tokenFilter.name + "]");
            }
        }
        return tokenFilterFactories;
    }

    private static TokenizerFactory parseTokenizerFactory(AnalyzeRequest request, IndexAnalyzers indexAnalzyers, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        TokenizerFactory tokenizerFactory;
        AnalyzeRequest.NameOrDefinition tokenizer = request.tokenizer();
        if (tokenizer.definition != null) {
            Settings settings = TransportAnalyzeAction.getAnonymousSettings(tokenizer.definition);
            String tokenizerTypeName = settings.get("type");
            if (tokenizerTypeName == null) {
                throw new IllegalArgumentException("Missing [type] setting for anonymous tokenizer: " + tokenizer.definition);
            }
            AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizerTypeName);
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("failed to find global tokenizer under [" + tokenizerTypeName + "]");
            }
            tokenizerFactory = tokenizerFactoryFactory.get(TransportAnalyzeAction.getNaIndexSettings(settings), environment, "_anonymous_tokenizer", settings);
        } else if (indexAnalzyers == null) {
            AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizer.name);
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("failed to find global tokenizer under [" + tokenizer.name + "]");
            }
            tokenizerFactory = tokenizerFactoryFactory.get(environment, tokenizer.name);
        } else {
            AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizer.name, indexAnalzyers.getIndexSettings());
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("failed to find tokenizer under [" + tokenizer.name + "]");
            }
            tokenizerFactory = tokenizerFactoryFactory.get(indexAnalzyers.getIndexSettings(), environment, tokenizer.name, AnalysisRegistry.getSettingsFromIndexSettings(indexAnalzyers.getIndexSettings(), "index.analysis.tokenizer." + tokenizer.name));
        }
        return tokenizerFactory;
    }

    private static IndexSettings getNaIndexSettings(Settings settings) {
        IndexMetaData metaData = IndexMetaData.builder("_na_").settings(settings).build();
        return new IndexSettings(metaData, Settings.EMPTY);
    }

    private static Settings getAnonymousSettings(Settings providerSetting) {
        return Settings.builder().put(providerSetting).put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).put("index.uuid", UUIDs.randomBase64UUID()).build();
    }

    private static class TokenListCreator {
        int lastPosition = -1;
        int lastOffset = 0;
        List<AnalyzeResponse.AnalyzeToken> tokens = new ArrayList<AnalyzeResponse.AnalyzeToken>();

        TokenListCreator() {
        }

        private void analyze(TokenStream stream, Analyzer analyzer, String field, Set<String> includeAttributes) {
            try {
                stream.reset();
                CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute posIncr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                OffsetAttribute offset = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
                TypeAttribute type = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
                while (stream.incrementToken()) {
                    int increment = posIncr.getPositionIncrement();
                    if (increment > 0) {
                        this.lastPosition += increment;
                    }
                    this.tokens.add(new AnalyzeResponse.AnalyzeToken(term.toString(), this.lastPosition, this.lastOffset + offset.startOffset(), this.lastOffset + offset.endOffset(), type.type(), TransportAnalyzeAction.extractExtendedAttributes(stream, includeAttributes)));
                }
                stream.end();
                this.lastOffset += offset.endOffset();
                this.lastPosition += posIncr.getPositionIncrement();
                this.lastPosition += analyzer.getPositionIncrementGap(field);
                this.lastOffset += analyzer.getOffsetGap(field);
            }
            catch (IOException e) {
                try {
                    throw new ElasticsearchException("failed to analyze", (Throwable)e, new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{stream});
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{stream});
        }

        private AnalyzeResponse.AnalyzeToken[] getArrayTokens() {
            return this.tokens.toArray(new AnalyzeResponse.AnalyzeToken[this.tokens.size()]);
        }
    }
}

