/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Objects;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public final class NodeAllocationResult {
    private final Decision decision;
    private final float weight;

    public NodeAllocationResult(Decision decision) {
        this.decision = Objects.requireNonNull(decision);
        this.weight = Float.POSITIVE_INFINITY;
    }

    public NodeAllocationResult(Decision decision, float weight) {
        this.decision = Objects.requireNonNull(decision);
        this.weight = Objects.requireNonNull(Float.valueOf(weight)).floatValue();
    }

    public Decision getDecision() {
        return this.decision;
    }

    public float getWeight() {
        return this.weight;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NodeAllocationResult that = (NodeAllocationResult)other;
        return this.decision.equals(that.decision) && Float.compare(this.weight, that.weight) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.decision, Float.valueOf(this.weight));
    }
}

