/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class CommonTermsQueryBuilder
extends AbstractQueryBuilder<CommonTermsQueryBuilder> {
    public static final String NAME = "common";
    public static final float DEFAULT_CUTOFF_FREQ = 0.01f;
    public static final Operator DEFAULT_HIGH_FREQ_OCCUR = Operator.OR;
    public static final Operator DEFAULT_LOW_FREQ_OCCUR = Operator.OR;
    public static final boolean DEFAULT_DISABLE_COORD = true;
    private static final ParseField CUTOFF_FREQUENCY_FIELD = new ParseField("cutoff_frequency", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField LOW_FREQ_OPERATOR_FIELD = new ParseField("low_freq_operator", new String[0]);
    private static final ParseField HIGH_FREQ_OPERATOR_FIELD = new ParseField("high_freq_operator", new String[0]);
    private static final ParseField DISABLE_COORD_FIELD = new ParseField("disable_coord", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField HIGH_FREQ_FIELD = new ParseField("high_freq", new String[0]);
    private static final ParseField LOW_FREQ_FIELD = new ParseField("low_freq", new String[0]);
    private final String fieldName;
    private final Object text;
    private Operator highFreqOperator = DEFAULT_HIGH_FREQ_OCCUR;
    private Operator lowFreqOperator = DEFAULT_LOW_FREQ_OCCUR;
    private String analyzer = null;
    private String lowFreqMinimumShouldMatch = null;
    private String highFreqMinimumShouldMatch = null;
    private boolean disableCoord = true;
    private float cutoffFrequency = 0.01f;

    public CommonTermsQueryBuilder(String fieldName, Object text) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        this.fieldName = fieldName;
        this.text = text;
    }

    public CommonTermsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.text = in.readGenericValue();
        this.highFreqOperator = Operator.readFromStream(in);
        this.lowFreqOperator = Operator.readFromStream(in);
        this.analyzer = in.readOptionalString();
        this.lowFreqMinimumShouldMatch = in.readOptionalString();
        this.highFreqMinimumShouldMatch = in.readOptionalString();
        this.disableCoord = in.readBoolean();
        this.cutoffFrequency = in.readFloat();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.text);
        this.highFreqOperator.writeTo(out);
        this.lowFreqOperator.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.lowFreqMinimumShouldMatch);
        out.writeOptionalString(this.highFreqMinimumShouldMatch);
        out.writeBoolean(this.disableCoord);
        out.writeFloat(this.cutoffFrequency);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return this.text;
    }

    public CommonTermsQueryBuilder highFreqOperator(Operator operator) {
        this.highFreqOperator = operator == null ? DEFAULT_HIGH_FREQ_OCCUR : operator;
        return this;
    }

    public Operator highFreqOperator() {
        return this.highFreqOperator;
    }

    public CommonTermsQueryBuilder lowFreqOperator(Operator operator) {
        this.lowFreqOperator = operator == null ? DEFAULT_LOW_FREQ_OCCUR : operator;
        return this;
    }

    public Operator lowFreqOperator() {
        return this.lowFreqOperator;
    }

    public CommonTermsQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public CommonTermsQueryBuilder cutoffFrequency(float cutoffFrequency) {
        this.cutoffFrequency = cutoffFrequency;
        return this;
    }

    public float cutoffFrequency() {
        return this.cutoffFrequency;
    }

    public CommonTermsQueryBuilder highFreqMinimumShouldMatch(String highFreqMinimumShouldMatch) {
        this.highFreqMinimumShouldMatch = highFreqMinimumShouldMatch;
        return this;
    }

    public String highFreqMinimumShouldMatch() {
        return this.highFreqMinimumShouldMatch;
    }

    public CommonTermsQueryBuilder lowFreqMinimumShouldMatch(String lowFreqMinimumShouldMatch) {
        this.lowFreqMinimumShouldMatch = lowFreqMinimumShouldMatch;
        return this;
    }

    public String lowFreqMinimumShouldMatch() {
        return this.lowFreqMinimumShouldMatch;
    }

    public CommonTermsQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public boolean disableCoord() {
        return this.disableCoord;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(QUERY_FIELD.getPreferredName(), this.text);
        builder.field(DISABLE_COORD_FIELD.getPreferredName(), this.disableCoord);
        builder.field(HIGH_FREQ_OPERATOR_FIELD.getPreferredName(), this.highFreqOperator.toString());
        builder.field(LOW_FREQ_OPERATOR_FIELD.getPreferredName(), this.lowFreqOperator.toString());
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(CUTOFF_FREQUENCY_FIELD.getPreferredName(), this.cutoffFrequency);
        if (this.lowFreqMinimumShouldMatch != null || this.highFreqMinimumShouldMatch != null) {
            builder.startObject(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName());
            if (this.lowFreqMinimumShouldMatch != null) {
                builder.field(LOW_FREQ_FIELD.getPreferredName(), this.lowFreqMinimumShouldMatch);
            }
            if (this.highFreqMinimumShouldMatch != null) {
                builder.field(HIGH_FREQ_FIELD.getPreferredName(), this.highFreqMinimumShouldMatch);
            }
            builder.endObject();
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static Optional<CommonTermsQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        Object text = null;
        float boost = 1.0f;
        String analyzer = null;
        String lowFreqMinimumShouldMatch = null;
        String highFreqMinimumShouldMatch = null;
        boolean disableCoord = true;
        Operator highFreqOperator = DEFAULT_HIGH_FREQ_OCCUR;
        Operator lowFreqOperator = DEFAULT_LOW_FREQ_OCCUR;
        float cutoffFrequency = 0.01f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                CommonTermsQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        if (parseContext.getParseFieldMatcher().match(currentFieldName, MINIMUM_SHOULD_MATCH_FIELD)) {
                            String innerFieldName = null;
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    innerFieldName = parser.currentName();
                                    continue;
                                }
                                if (token.isValue()) {
                                    if (parseContext.getParseFieldMatcher().match(innerFieldName, LOW_FREQ_FIELD)) {
                                        lowFreqMinimumShouldMatch = parser.text();
                                        continue;
                                    }
                                    if (parseContext.getParseFieldMatcher().match(innerFieldName, HIGH_FREQ_FIELD)) {
                                        highFreqMinimumShouldMatch = parser.text();
                                        continue;
                                    }
                                    throw new ParsingException(parser.getTokenLocation(), "[common] query does not support [" + innerFieldName + "] for [" + currentFieldName + "]", new Object[0]);
                                }
                                throw new ParsingException(parser.getTokenLocation(), "[common] unexpected token type [" + (Object)((Object)token) + "] after [" + innerFieldName + "]", new Object[0]);
                            }
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[common] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    if (!token.isValue()) continue;
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                        text = parser.objectText();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, ANALYZER_FIELD)) {
                        analyzer = parser.text();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, DISABLE_COORD_FIELD)) {
                        disableCoord = parser.booleanValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, HIGH_FREQ_OPERATOR_FIELD)) {
                        highFreqOperator = Operator.fromString(parser.text());
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, LOW_FREQ_OPERATOR_FIELD)) {
                        lowFreqOperator = Operator.fromString(parser.text());
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, MINIMUM_SHOULD_MATCH_FIELD)) {
                        lowFreqMinimumShouldMatch = parser.text();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, CUTOFF_FREQUENCY_FIELD)) {
                        cutoffFrequency = parser.floatValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[common] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            CommonTermsQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            text = parser.objectText();
        }
        return Optional.of(((CommonTermsQueryBuilder)new CommonTermsQueryBuilder(fieldName, text).lowFreqMinimumShouldMatch(lowFreqMinimumShouldMatch).highFreqMinimumShouldMatch(highFreqMinimumShouldMatch).analyzer(analyzer).highFreqOperator(highFreqOperator).lowFreqOperator(lowFreqOperator).disableCoord(disableCoord).cutoffFrequency(cutoffFrequency).boost(boost)).queryName(queryName));
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Object analyzerObj;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        String field = fieldType != null ? fieldType.name() : this.fieldName;
        if (this.analyzer == null) {
            analyzerObj = fieldType != null ? context.getSearchAnalyzer(fieldType) : context.getMapperService().searchAnalyzer();
        } else {
            analyzerObj = context.getMapperService().getIndexAnalyzers().get(this.analyzer);
            if (analyzerObj == null) {
                throw new QueryShardException(context, "[common] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
        }
        BooleanClause.Occur highFreqOccur = this.highFreqOperator.toBooleanClauseOccur();
        BooleanClause.Occur lowFreqOccur = this.lowFreqOperator.toBooleanClauseOccur();
        ExtendedCommonTermsQuery commonsQuery = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, this.cutoffFrequency, this.disableCoord, fieldType);
        return CommonTermsQueryBuilder.parseQueryString(commonsQuery, this.text, field, analyzerObj, this.lowFreqMinimumShouldMatch, this.highFreqMinimumShouldMatch);
    }

    private static Query parseQueryString(ExtendedCommonTermsQuery query, Object queryString, String field, Analyzer analyzer, String lowFreqMinimumShouldMatch, String highFreqMinimumShouldMatch) throws IOException {
        try (TokenStream source = analyzer.tokenStream(field, queryString.toString());){
            source.reset();
            CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
            BytesRefBuilder builder = new BytesRefBuilder();
            while (source.incrementToken()) {
                builder.copyChars((CharSequence)termAtt);
                query.add(new Term(field, builder.toBytesRef()));
            }
        }
        query.setLowFreqMinimumNumberShouldMatch(lowFreqMinimumShouldMatch);
        query.setHighFreqMinimumNumberShouldMatch(highFreqMinimumShouldMatch);
        return query;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.text, this.highFreqOperator, this.lowFreqOperator, this.analyzer, this.lowFreqMinimumShouldMatch, this.highFreqMinimumShouldMatch, this.disableCoord, Float.valueOf(this.cutoffFrequency));
    }

    @Override
    protected boolean doEquals(CommonTermsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.text, other.text) && Objects.equals(this.highFreqOperator, other.highFreqOperator) && Objects.equals(this.lowFreqOperator, other.lowFreqOperator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.lowFreqMinimumShouldMatch, other.lowFreqMinimumShouldMatch) && Objects.equals(this.highFreqMinimumShouldMatch, other.highFreqMinimumShouldMatch) && Objects.equals(this.disableCoord, other.disableCoord) && Objects.equals(Float.valueOf(this.cutoffFrequency), Float.valueOf(other.cutoffFrequency));
    }
}

