/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class DiversifiedSamplerParser
extends AbstractValuesSourceParser.AnyValuesSourceParser {
    public DiversifiedSamplerParser() {
        super(true, false);
    }

    protected DiversifiedAggregationBuilder createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        String executionHint;
        Integer maxDocsPerValue;
        DiversifiedAggregationBuilder factory = new DiversifiedAggregationBuilder(aggregationName);
        Integer shardSize = (Integer)otherOptions.get(SamplerAggregator.SHARD_SIZE_FIELD);
        if (shardSize != null) {
            factory.shardSize(shardSize);
        }
        if ((maxDocsPerValue = (Integer)otherOptions.get(SamplerAggregator.MAX_DOCS_PER_VALUE_FIELD)) != null) {
            factory.maxDocsPerValue(maxDocsPerValue);
        }
        if ((executionHint = (String)otherOptions.get(SamplerAggregator.EXECUTION_HINT_FIELD)) != null) {
            factory.executionHint(executionHint);
        }
        return factory;
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (token == XContentParser.Token.VALUE_NUMBER) {
            if (context.matchField(currentFieldName, SamplerAggregator.SHARD_SIZE_FIELD)) {
                int shardSize = parser.intValue();
                otherOptions.put(SamplerAggregator.SHARD_SIZE_FIELD, shardSize);
                return true;
            }
            if (context.matchField(currentFieldName, SamplerAggregator.MAX_DOCS_PER_VALUE_FIELD)) {
                int maxDocsPerValue = parser.intValue();
                otherOptions.put(SamplerAggregator.MAX_DOCS_PER_VALUE_FIELD, maxDocsPerValue);
                return true;
            }
        } else if (token == XContentParser.Token.VALUE_STRING && context.matchField(currentFieldName, SamplerAggregator.EXECUTION_HINT_FIELD)) {
            String executionHint = parser.text();
            otherOptions.put(SamplerAggregator.EXECUTION_HINT_FIELD, executionHint);
            return true;
        }
        return false;
    }
}

