/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import org.openscience.jmol.app.nbo.FileHndlr;
import org.openscience.jmol.app.nbo.HelpBtn;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBODialogView;

abstract class NBODialogSearch
extends NBODialogView {
    int operator = 1;
    protected JComboBox<String> orb;
    protected JComboBox<String> orb2;
    protected JComboBox<String> unit;
    protected JComboBox<String> at1;
    protected JComboBox<String> at2;
    protected JComboBox<String> bas2;
    protected JComboBox<String> opBas;
    protected JLabel unitLabel;
    protected DefaultComboBoxModel<String> list1;
    protected DefaultComboBoxModel<String> list2;
    protected DefaultComboBoxModel<String> list3;
    int[][] resStructDef;
    Hashtable<Integer, String> resStructList;
    protected String keyProp;
    private boolean relabel;
    protected boolean isNewJob;
    private Box optionBox;
    private JButton keyWdBtn;
    protected JPanel opList;
    protected JRadioButton[] rBtns = new JRadioButton[12];
    protected JRadioButton moRb;
    protected JRadioButton nboRb;
    protected int rbSelection;
    protected int keywordNumber;
    private JButton back;
    private static final int KEYWD_NPA = 1;
    private static final int KEYWD_NBO = 2;
    private static final int KEYWD_BEND = 3;
    private static final int KEYWD_E2PERT = 4;
    private static final int KEYWD_NLMO = 5;
    private static final int KEYWD_CMO = 8;
    private static final int KEYWD_NRT = 6;
    private static final int KEYWD_STERIC = 7;
    private static final int KEYWD_DIPOLE = 9;
    private static final int KEYWD_OPBAS = 10;
    private static final int KEYWD_BAS1BAS2 = 11;
    protected String[] keyW = new String[]{"NPA    : Atomic and NAO properties", "NBO    : Natural Lewis Structure and\n NBO properties", "BEND   : NHO directionality and\n bond-bending", "E2PERT : 2nd-order energtics of NBO\n donor-acceptor interactions", "NLMO   : NLMO properties", "CMO    : NBO-based character of canonical\n molecular orbitals", "NRT    : Natural Resonance Theory\n weightings and bond orders", "STERIC : Total/pairwise contributions\n to steric exchange energy", "DIPOLE : L/NL contributions to electric\n dipole moment", "OPBAS  : Matrix elements of chosen operator   \n in chosen basis set", "B1B2   : Transformation matrix between\n chosen basis sets"};
    protected String[] npa = new String[]{"NPA Atomic Properties:", "  (1) NPA atomic charge", "  (2) NPA atomic spin density", "  (3) NEC atomic electron configuration", "NPA Molecular Unit Properties:", "  (4) NPA molecular unit charge", "  (5) NPA molecular unit spin density", "NAO Orbital Properties:", "  (6) NAO label", "  (7) NAO orbital population", "  (8) NAO orbital energy", "  (9) NAO orbital spin density", "  (10) NMB minimal basis %-accuracy", "Display Options:", "  (11) Display atomic charges"};
    protected String[] nbo = new String[]{"NBO Orbital Properties:", "  (1) NBO orbital label", "  (2) NBO orbital population", "  (3) NBO orbital energy", "  (4) NBO ionicity", "Natural Lewis Structure Properties:", "  (5) NLS rho(NL)", "  (6) NLS %-rho(L)"};
    protected String[] bend = new String[]{"NHO Orbital Prperties:", "  (1) NHO orbital label", "  (2) NHO orbital population", "  (3) NHO orbital energy", "  (4) NHO hybrid composition", "  (5) NHO direction angles", "  (6) NHO bending deviation from line of centers", "  (7) Strongest bending deviation for any NHO"};
    protected String[] e2 = new String[]{"E2 Values for Selected Donor-Acceptor NBOs:", "  (1) E(2) interaction for current d/a NBOs", "  (2) Strongest E(2) interaction for current d-NBO", "  (3) Strongest E(2) interaction for current a-NBO", "  (4) Strongest E(2) interaction for any d/a NBOs", "Intermolecular E2 Options:", "  (5) Strongest intermolecular E(2) for current unit", "  (6) Strongest intermolecular E(2) for any units"};
    protected String[] nlmo = new String[]{"NLMO Orbital Properties:", "  (1) NLMO orbital label", "  (2) NLMO population", "  (3) NLMO orbital energy", "  (4) NLMO %-NBO parentage", "NLMO Delocalization Tail Properties:", "  (5) NLMO delocalization tail population", "  (6) NLMO delocalization tail NBO components"};
    protected String[] nrt = new String[]{"Atom (A) Properties:", "  (1) atomic valency (total)", "  (2) atomic covalency", "  (3) atomic electrovalency", "Bond [A-A'] Properties:", "  (4) bond order (total)", "  (5) covalent bond order", "  (6) electrovalent bond order", "Resonance Structure Properties:", "  (7) RS weighting", "  (8) RS rho(NL) (reference structures only)", "Display Options:", "  (9) Display NRT atomic valencies", "  (10) Display NRT bond orders"};
    protected String[] steric = new String[]{"Total Steric Exchange Energy (SXE) Estimates:", "  (1) Total SXE", "  (2) Sum of pairwise (PW-SXE) contributions", "Selected PW-SXE contributions:", "  (3) PW-SXE for current d-d' NLMOs", "  (4) Strongest PW-SXE for current d NLMO", "Intra- and intermolecular options:", "  (5) Strongest PW-SXE within current unit", "  (6) Strongest PW-SXE within any unit", "  (7) Strongest PW-SXE between any units"};
    protected String[] mo = new String[]{"Character of current MO (c):", "  (1) Current MO energy and type", "  (2) Bonding character of current MO", "  (3) Nonbonding character of current MO", "  (4) Antibonding character of current MO", "NBO (n) %-contribution to selected MO (c):", "  (5) %-contribution of current NBO to current MO", "  (6) Largest %-contribution to current MO from any NBO", "  (7) Largest %-contribution of current NBO to any MO"};
    protected String[] dip = new String[]{"Total Dipole Properties:", "  (1) Total dipole moment", "  (2) Total L-type (Lewis) dipole", "  (3) Total NL-type (resonance) dipole", "Bond [NBO/NLMO] Dipole Properties:", "  (4) Dipole moment of current NLMO", "  (5) L-type (NBO bond dipole) contribution", "  (6) NL-type (resonance dipole) contribution", "Molecular Unit Dipole Properties:", "  (7) Dipole moment of current molecular unit", "  (8) L-type contribution to unit dipole", "  (9) NL-type contribution to unit dipole"};
    protected String[] op = new String[]{" S    : overlap (unit) operator", " F    : 1e Hamiltonian (Fock/Kohn-Sham) operator", " K    : kinetic energy operator", " V    : 1e potential (nuclear-electron attraction) operator", " DM   : 1e density matrix operator", " DIx  : dipole moment operator (x component)", " DIy  : dipole moment operator (y component)", " DIz  : dipole moment operator (z component)"};
    private boolean secondPick = true;

    protected NBODialogSearch(JFrame f) {
        super(f);
    }

    protected JPanel buildSearchPanel() {
        JPanel p = new JPanel();
        this.keyProp = "";
        this.keywordNumber = 0;
        p.setLayout(new BorderLayout());
        Box box1 = NBODialogSearch.titleBox(" Select Job ", new HelpBtn("search_job_help.htm"));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        this.fileHndlr = this.fileHndlr == null ? new FileHndlr("", "47", 4, "47", (NBODialog)this) : new FileHndlr(this.fileHndlr.jobStem, "47", 4, "47", (NBODialog)this);
        box.add(this.fileHndlr);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        box1.add(box);
        p.add((Component)box1, "North");
        this.betaSpin = new JRadioButton("<html>&#x3B2</html>");
        this.alphaSpin = new JRadioButton("<html>&#x3B1</html>");
        ActionListener spinListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (NBODialogSearch.this.alphaSpin.isSelected()) {
                    NBODialogSearch.this.setBonds(true);
                    NBODialogSearch.this.showAtomNums(true);
                } else {
                    NBODialogSearch.this.setBonds(false);
                    NBODialogSearch.this.showAtomNums(false);
                }
                switch (NBODialogSearch.this.keywordNumber) {
                    case 2: 
                    case 3: 
                    case 9: {
                        NBODialogSearch.this.list1.removeAllElements();
                        NBODialogSearch.this.getListSearch("o", NBODialogSearch.this.list1);
                        break;
                    }
                    case 4: {
                        NBODialogSearch.this.list1.removeAllElements();
                        NBODialogSearch.this.getListSearch("d", NBODialogSearch.this.list1);
                        NBODialogSearch.this.list2.removeAllElements();
                        NBODialogSearch.this.getListSearch("a nbo", NBODialogSearch.this.list2);
                        break;
                    }
                    case 5: {
                        NBODialogSearch.this.list2.removeAllElements();
                        NBODialogSearch.this.getListSearch("o", NBODialogSearch.this.list2);
                        break;
                    }
                    case 7: {
                        NBODialogSearch.this.list1.removeAllElements();
                        NBODialogSearch.this.getListSearch("d", NBODialogSearch.this.list1);
                        NBODialogSearch.this.list2.removeAllElements();
                        NBODialogSearch.this.getListSearch("d'", NBODialogSearch.this.list2);
                        break;
                    }
                    case 8: {
                        NBODialogSearch.this.list1.removeAllElements();
                        NBODialogSearch.this.getListSearch("n", NBODialogSearch.this.list1);
                    }
                }
            }
        };
        this.alphaSpin.addActionListener(spinListener);
        this.betaSpin.addActionListener(spinListener);
        this.alphaSpin.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.alphaSpin);
        bg.add(this.betaSpin);
        bg = new ButtonGroup();
        this.moRb = new JRadioButton("MO");
        this.moRb.setSelected(true);
        this.moRb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBODialogSearch.this.runScriptQueued("nbo delete;");
                if (!NBODialogSearch.this.useWireMesh) {
                    NBODialogSearch.this.runScriptQueued("nbo nomesh fill translucent " + NBODialogSearch.this.opacityOp);
                }
                NBODialogSearch.this.runScriptQueued("nbo color " + NBODialogSearch.this.color2 + " " + NBODialogSearch.this.color1);
                NBODialogSearch.this.showOrbJmol("MO", NBODialogSearch.this.orb2.getSelectedIndex() + 1);
            }
        });
        this.moRb.setBackground(null);
        this.nboRb = new JRadioButton("NBO");
        this.nboRb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBODialogSearch.this.showOrbJmol("NBO", NBODialogSearch.this.orb.getSelectedIndex() + 1);
            }
        });
        this.nboRb.setBackground(null);
        bg.add(this.moRb);
        bg.add(this.nboRb);
        box = Box.createVerticalBox();
        this.opList = new JPanel();
        this.opBas = new JComboBox<String>(this.op);
        this.opBas.setUI(new NBODialogConfig.StyledComboBoxUI(150, 350));
        this.back = new JButton("<html>&#8592Back</html>");
        this.opBas.setMaximumSize(new Dimension(350, 30));
        this.opBas.setAlignmentX(0.0f);
        this.opBas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = NBODialogSearch.this.opBas.getSelectedItem().toString();
                NBODialogSearch.this.operator = NBODialogSearch.this.opBas.getSelectedIndex();
                NBODialogSearch.this.changeKey(NBODialogSearch.this.opBas(s.trim().split(" ")[0]));
            }
        });
        this.opBas.setVisible(false);
        box.add(this.opBas);
        box.add(this.opList);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        this.optionBox = Box.createVerticalBox();
        this.optionBox.setVisible(false);
        Box topBox = Box.createHorizontalBox();
        this.keyWdBtn = new JButton("<html></html>");
        this.keyWdBtn.setVisible(false);
        this.keyWdBtn.setRolloverEnabled(false);
        topBox.add(this.keyWdBtn);
        topBox.add(this.back);
        topBox.add(new HelpBtn("a"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "http://nbo6.chem.wisc.edu/jmol_help/";
                url = NBODialogSearch.this.keywordNumber == 0 ? url + "search_help.htm" : (NBODialogSearch.this.keyProp.equals("E2") ? url + "search_e2pert_help.htm" : url + "search_" + NBODialogSearch.this.keyProp + "_help.htm");
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException e1) {
                    NBODialogSearch.this.vwr.alert("Could not open browser");
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
        Box box2 = NBODialogSearch.titleBox(" Select Keyword ", topBox);
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (NBODialogSearch.this.keywordNumber == 6 && NBODialogSearch.this.list3.getSize() > 0) {
                    NBODialogSearch.this.unit.setSelectedIndex(0);
                }
                NBODialogSearch.this.showAtomNums(NBODialogSearch.this.alphaSpin.isSelected());
                NBODialogSearch.this.runScriptNow("mo delete; nbo delete; select off");
                NBODialogSearch.this.buildHome();
            }
        });
        this.back.setForeground(Color.blue);
        this.back.setEnabled(false);
        this.buildHome();
        box2.setAlignmentX(0.0f);
        this.optionBox.add(box2);
        box.setAlignmentX(0.0f);
        this.optionBox.add(box);
        p.add(this.optionBox);
        this.basis = new JComboBox<String>(NBODialogView.basSet);
        this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
        this.fileHndlr.browse.setEnabled(true);
        this.settingsBox.removeAll();
        String file = this.vwr.getProperty("String", "filename", null).toString();
        String ext = FileHndlr.getExt(new File(file));
        if (PT.isOneOf(ext, "31;32;33;34;35;36;37;38;39;40;41;42;46;nbo")) {
            this.notifyLoad_s();
        }
        return p;
    }

    protected void buildHome() {
        this.rbSelection = -1;
        this.opList.removeAll();
        this.opBas.setVisible(false);
        this.keyWdBtn.setVisible(false);
        this.opList.setLayout(new GridBagLayout());
        this.opList.setBackground(Color.white);
        this.keywordNumber = 0;
        this.settingsBox.setVisible(false);
        GridBagConstraints c = new GridBagConstraints();
        this.keyProp = "";
        String[] keyWords = new String[]{"NPA", "NBO", "BEND", "E2PERT", "NLMO", "CMO", "NRT", "STERIC", "DIPOLE", "OPBAS", "B1B2"};
        c.fill = 2;
        for (int i = 0; i < keyWords.length * 2; i += 2) {
            c.gridy = i;
            c.gridx = 0;
            c.gridwidth = 1;
            JButton btn = new JButton(keyWords[i / 2]);
            final int index = i / 2;
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (NBODialogSearch.this.nboService.isWorking) {
                        NBODialogSearch.this.vwr.alert("Please wait for NBOServe to finish working");
                        return;
                    }
                    NBODialogSearch.this.keywordNumber = index < 5 ? index + 1 : (index == 5 ? 8 : (index == 6 ? 6 : (index == 7 ? 7 : index + 1)));
                    NBODialogSearch.this.keywordClicked(NBODialogSearch.this.keywordNumber);
                }
            });
            this.opList.add((Component)btn, c);
            c.gridx = 1;
            String st = this.keyW[i / 2].substring(this.keyW[i / 2].indexOf(":"));
            JTextArea jt = new JTextArea(st);
            jt.setBackground(null);
            jt.setFont(new Font("Arial", 0, 16));
            jt.setEditable(false);
            this.opList.add((Component)jt, c);
            c.gridy = i + 1;
            c.gridx = 0;
            c.gridwidth = 2;
            JSeparator sp = new JSeparator(0);
            sp.setForeground(Color.BLACK);
            sp.setSize(350, 10);
            this.opList.add((Component)sp, c);
        }
        this.opList.repaint();
        this.opList.revalidate();
        this.back.setEnabled(false);
    }

    protected void changeKey(String[] s) {
        this.secondPick = true;
        this.back.setEnabled(true);
        this.settingsBox.setVisible(true);
        this.keyWdBtn.setText("<html><font color=black>" + this.keyProp + "</font></html>");
        this.keyWdBtn.setVisible(true);
        this.runScriptNow("mo delete;nbo delete");
        if (!this.useWireMesh) {
            this.runScriptQueued("nbo nomesh fill translucent " + this.opacityOp);
            this.runScriptQueued("mo nomesh fill translucent " + this.opacityOp);
        }
        this.runScriptQueued("nbo color " + this.color2 + " " + this.color1);
        this.runScriptQueued("mo color " + this.color2 + " " + this.color1);
        this.opList.removeAll();
        ButtonGroup btnGroup = new ButtonGroup();
        this.opList.setLayout(new BoxLayout(this.opList, 1));
        if (this.keywordNumber == 10) {
            this.opBas.setVisible(true);
            this.opList.add(this.opBas);
        }
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].trim().startsWith("(")) {
                JLabel lab = new JLabel(s[i]);
                lab.setFont(new Font("Arial", 1, 14));
                lab.setForeground(Color.blue);
                this.opList.add(lab);
            } else {
                final int num = Integer.parseInt(s[i].substring(s[i].indexOf("(") + 1, s[i].indexOf(")"))) - 1;
                this.rBtns[num] = new JRadioButton(s[i].substring(s[i].indexOf(41) + 1));
                this.rBtns[num].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        NBODialogSearch.this.rbSelection = num;
                        NBODialogSearch.this.getSearchValue(num + 1);
                    }
                });
                this.rBtns[num].setBackground(null);
                this.opList.add(this.rBtns[num]);
                btnGroup.add(this.rBtns[num]);
            }
            this.opList.add(new JSeparator());
        }
        if (this.keywordNumber == 8) {
            // empty if block
        }
        this.opList.add(Box.createRigidArea(new Dimension(0, (16 - s.length) * 20)));
        this.opList.repaint();
        this.opList.revalidate();
    }

    protected void getListSearch(String get, DefaultComboBoxModel<String> list) {
        String key;
        int mode = 46;
        SB sb = new SB();
        sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
        sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
        if (this.isOpenShell) {
            sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
        } else {
            sb.append("GLOBAL I_SPIN 0" + sep);
        }
        if (this.keywordNumber >= 10) {
            int tmpKey = this.keywordNumber;
            String tmpCmd = "o";
            JComboBox<String> tmpBas = get.startsWith("c") && this.keywordNumber == 11 ? this.bas2 : this.basis;
            switch (tmpBas.getSelectedIndex()) {
                case 0: 
                case 1: 
                case 2: {
                    tmpKey = 1;
                    break;
                }
                case 3: 
                case 4: {
                    tmpKey = 3;
                    break;
                }
                case 5: 
                case 6: {
                    tmpKey = 2;
                    break;
                }
                case 7: 
                case 8: {
                    tmpKey = 5;
                    break;
                }
                case 9: {
                    tmpCmd = "c";
                    tmpKey = 8;
                }
            }
            sb.append("GLOBAL I_KEYWORD " + tmpKey + sep);
            sb.append("GLOBAL I_BAS_1 " + (tmpBas.getSelectedIndex() + 1) + sep);
            key = get.split(" ")[0];
            sb.append("CMD " + tmpCmd);
        } else {
            sb.append("GLOBAL I_KEYWORD " + this.keywordNumber + sep);
            sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
            key = get.split(" ")[0];
            sb.append("CMD " + key);
        }
        if (get.equals("c") && this.keywordNumber == 8) {
            mode = 47;
        }
        this.nboService.rawCmdNew("s", sb, mode, list, "Getting list " + key);
    }

    protected void showMessage() {
        JOptionPane.showMessageDialog(this, "Error getting lists, an error may have occured during run");
    }

    protected void basChange() {
        String b1 = this.basis.getSelectedItem().toString();
        String b2 = this.bas2.getSelectedItem().toString();
        String[] b1b2 = new String[]{"Current r(ow),c(olumn) matrix element:", "  (1) current <" + b1 + "(r)|" + b2 + "(c)> value", "Extremal off-diagonal values for current r orbital:", "  (2) max <" + b1 + "(r)|" + b2 + "(*c)> value for current r", "  (3) min <" + b1 + "(r)|" + b2 + "(*c)> value for current r", "Extremal off-diagonal values for current c orbital:", "  (4) max <" + b1 + "(*r)|" + b2 + "(c)> value for current c", "  (5) min <" + b1 + "(*r)|" + b2 + "(c)> value for current c", "Extremal off-diagonal values for any (*r,*c) orbitals:", "  (6) max <" + b1 + "(*r)|" + b2 + "(*c)> value for any *r,*c", "  (7) min <" + b1 + "(*r)|" + b2 + "(*c)> value for any *r,*c"};
        this.changeKey(b1b2);
    }

    protected String[] opBas(String operator) {
        return new String[]{"Current [r(ow),c(ol)] matrix element", "  (1) current <r|" + operator + "|c> value", "Extremal off-diagonal values for current r orbital:", "  (2) max <r|" + operator + "|*c> value for current r", "  (3) min <r|" + operator + "|*c> value for current r", "Extremal off-diagonal values for current c orbital:", "  (4) max <*r|" + operator + "|c> value for current c", "  (5) min <*r|" + operator + "|c> value for current c", "Extremal off-diagonal values for any [*r,*c] orbitals:", "  (6) max <*r|" + operator + "|*c> value for any *r,*c", "  (7) min <*r|" + operator + "|*c> value for any *r,*c"};
    }

    protected void keywordClicked(int index) throws IllegalArgumentException {
        switch (index) {
            case 1: {
                this.at2 = null;
                this.basis.setSelectedIndex(2);
                this.keyProp = "NPA";
                this.setKeyword(new String[]{"b", "a", "o PNAO", "u"}, new String[]{"Basis: ", "Atom: ", "Orbital: ", "Unit: "});
                this.changeKey(this.npa);
                break;
            }
            case 2: {
                this.runScriptNow("set bondpicking true");
                this.basis.setSelectedIndex(5);
                this.keyProp = "NBO";
                this.setKeyword(new String[]{"b", "o PNBO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.nbo);
                break;
            }
            case 5: {
                this.runScriptNow("set bondpicking true");
                this.basis.setSelectedIndex(7);
                this.keyProp = "NLMO";
                this.setKeyword(new String[]{"b", "o PNLMO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.nlmo);
                break;
            }
            case 3: {
                this.runScriptNow("set bondpicking true");
                this.basis.setSelectedIndex(3);
                this.keyProp = "BEND";
                this.setKeyword(new String[]{"b", "o PNHO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(this.bend);
                break;
            }
            case 6: {
                this.runScriptNow("set bondpicking true");
                this.keyProp = "NRT";
                if (this.isOpenShell) {
                    this.setKeyword("s a a' rs".split(" "), new String[]{"Spin: ", "Atom A: ", "Atom A': ", "Res Struct: "});
                    break;
                }
                this.setKeyword("a a' rs".split(" "), new String[]{"Atom A: ", "Atom A': ", "Res Struct: "});
                break;
            }
            case 4: {
                this.runScriptNow("set bondpicking true");
                this.basis.setSelectedIndex(5);
                this.keyProp = "E2";
                this.setKeyword(new String[]{"b", "d nbo", "a nbo", "u"}, new String[]{"Basis: ", "d-NBO: ", "a-NBO:", "Unit: "});
                this.changeKey(this.e2);
                break;
            }
            case 7: {
                this.runScriptNow("set bondpicking true");
                this.basis.setSelectedIndex(7);
                this.keyProp = "STERIC";
                this.setKeyword(new String[]{"b", "d nlmo", "d' nlmo", "u"}, new String[]{"Basis: ", "d-NLMO: ", "d'-NLMO:", "Unit: "});
                this.changeKey(this.steric);
                break;
            }
            case 8: {
                this.runScriptNow("set bondpicking true");
                this.basis.setSelectedIndex(9);
                this.keyProp = "CMO";
                this.nboKeywords = this.cleanNBOKeylist(this.fileHndlr.read47File()[1]);
                if (!this.nboKeywords.contains("CMO")) {
                    this.runJob("CMO", this.fileHndlr.inputFile, "gennbo");
                    return;
                }
                this.setKeyword(new String[]{"b", "c cmo", "n"}, new String[]{"Basis: ", "MO: ", "NBO:"});
                this.changeKey(this.mo);
                break;
            }
            case 9: {
                this.runScriptNow("set bondpicking true");
                this.basis.setSelectedIndex(7);
                this.keyProp = "DIPOLE";
                this.setKeyword("b o u".split(" "), new String[]{"Basis: ", "Orbital: ", "Unit:"});
                this.changeKey(this.dip);
                break;
            }
            case 10: {
                this.runScriptNow("set bondpicking true");
                this.settingsBox.removeAll();
                this.basis = new JComboBox<String>(NBODialogView.basSet);
                this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
                this.basis.setEditable(false);
                this.opBas.requestFocus();
                this.keyProp = "OPBAS";
                this.setKeyword("b1 r c".split(" "), new String[]{"Basis:", "Row:", "Collumn:"});
                this.changeKey(new String[0]);
                break;
            }
            case 11: {
                this.runScriptNow("set bondpicking true");
                this.keyProp = "B1B2";
                this.setKeyword("b1 b2 r c".split(" "), new String[]{"Basis 1:", "Basis 2:", "Row:", "Collumn:"});
                this.basChange();
            }
        }
        this.repaint();
        this.revalidate();
        int fileNum = 31 + this.basis.getSelectedIndex();
        this.runScriptQueued("load " + FileHndlr.newNBOFile(this.fileHndlr.inputFile, "" + fileNum));
        if (this.keywordNumber == 8) {
            this.runScriptQueued("load append " + FileHndlr.newNBOFile(this.fileHndlr.inputFile, "36"));
        }
        if (index == 10) {
            this.opBas.showPopup();
        }
    }

    protected void setKeyword(final String[] get, String[] labs) {
        this.settingsBox.removeAll();
        this.settingsBox.setLayout(new BorderLayout());
        JPanel l = new JPanel(new GridLayout(labs.length, 1));
        JPanel l2 = new JPanel(new GridLayout(labs.length, 1));
        for (int i = 0; i < labs.length; ++i) {
            Box b;
            final String key = get[i].split(" ")[0];
            l.add(new JLabel(labs[i]));
            if (key.equals("b") || key.equals("s")) {
                b = Box.createHorizontalBox();
                if (this.keywordNumber == 8) {
                    b.add(this.moRb);
                    b.add(this.nboRb);
                } else if (key.equals("b")) {
                    b.add(new JLabel(this.basis.getSelectedItem().toString()));
                    b.add(Box.createRigidArea(new Dimension(20, 0)));
                }
                b.add(this.alphaSpin);
                b.add(this.betaSpin);
                l2.add(b);
                continue;
            }
            if (PT.isOneOf(get[i], "o PNBO;o PNLMO;r;d nlmo;n;d nbo;o PNHO;o")) {
                this.list1 = new DefaultComboBoxModel();
                this.orb = new JComboBox<String>(this.list1);
                l2.add(this.orb);
                this.getListSearch(key, this.list1);
                this.orb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NBODialogSearch.this.orb.getSelectedIndex() < 0) {
                            return;
                        }
                        NBODialogSearch.this.orbPick();
                        if (key.equals("n")) {
                            NBODialogSearch.this.showOrbJmol("NBO", NBODialogSearch.this.orb.getSelectedIndex() + 1);
                            NBODialogSearch.this.nboRb.setSelected(true);
                        } else {
                            NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.orb.getSelectedIndex() + 1);
                        }
                    }
                });
                continue;
            }
            if (PT.isOneOf(get[i], "c;d' nlmo;a nbo;c cmo;o PNAO")) {
                this.list2 = new DefaultComboBoxModel();
                this.orb2 = new JComboBox<String>(this.list2);
                this.getListSearch(key, this.list2);
                final int ind = i;
                this.orb2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NBODialogSearch.this.orb2.getSelectedIndex() < 0) {
                            return;
                        }
                        NBODialogSearch.this.orbPick();
                        if (key.equals("a")) {
                            NBODialogSearch.this.showMOJmol("NBO", NBODialogSearch.this.list1.getSize() + 1 + NBODialogSearch.this.orb2.getSelectedIndex());
                        } else if (key.equals("c")) {
                            NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.orb2.getSelectedIndex() + 1);
                        } else {
                            NBODialogSearch.this.showMOJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.orb2.getSelectedIndex() + 1);
                        }
                        if (get[ind].equals("c cmo")) {
                            NBODialogSearch.this.moRb.setSelected(true);
                        }
                    }
                });
                l2.add(this.orb2);
                continue;
            }
            if (key.equals("u")) {
                this.list3 = new DefaultComboBoxModel();
                this.unit = new JComboBox<String>(this.list3);
                this.getListSearch(key, this.list3);
                this.unitLabel = new JLabel();
                Box box = Box.createHorizontalBox();
                box.add(this.unit);
                box.add(this.unitLabel);
                l2.add(box);
                this.unitLabel.setVisible(false);
                continue;
            }
            if (key.equals("rs")) {
                this.list3 = new DefaultComboBoxModel();
                this.unit = new JComboBox<String>(this.list3);
                this.getListSearch("r", this.list3);
                l2.add(this.unit);
                continue;
            }
            if (key.equals("a")) {
                this.list1 = new DefaultComboBoxModel();
                this.at1 = new JComboBox<String>(this.list1);
                this.getListSearch("a", this.list1);
                this.at1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NBODialogSearch.this.at2 == null) {
                            NBODialogSearch.this.runScriptQueued("select on; select {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]");
                        } else {
                            NBODialogSearch.this.runScriptQueued("select on; select remove{*}; select add {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]; select add {*}[" + (NBODialogSearch.this.at2.getSelectedIndex() + 1) + "]");
                        }
                    }
                });
                l2.add(this.at1);
                continue;
            }
            if (key.equals("a'")) {
                this.list2 = new DefaultComboBoxModel();
                this.at2 = new JComboBox<String>(this.list2);
                this.getListSearch("a", this.list2);
                this.at2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialogSearch.this.runScriptQueued("select on; select remove{*}; select add {*}[" + (NBODialogSearch.this.at1.getSelectedIndex() + 1) + "]; select add {*}[" + (NBODialogSearch.this.at2.getSelectedIndex() + 1) + "]");
                    }
                });
                l2.add(this.at2);
                continue;
            }
            if (key.equals("b1")) {
                b = Box.createHorizontalBox();
                b.add(this.basis);
                this.basis.setSelectedIndex(0);
                this.basis.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NBODialogSearch.this.keyProp.equals("B1B2")) {
                            if (NBODialogSearch.this.bas2 == null) {
                                return;
                            }
                            NBODialogSearch.this.basChange();
                            NBODialogSearch.this.list1.removeAllElements();
                            NBODialogSearch.this.getListSearch("r", NBODialogSearch.this.list1);
                        } else if (NBODialogSearch.this.keyProp.equals("OPBAS")) {
                            NBODialogSearch.this.list1.removeAllElements();
                            NBODialogSearch.this.list2.removeAllElements();
                            NBODialogSearch.this.getListSearch("r", NBODialogSearch.this.list1);
                            NBODialogSearch.this.getListSearch("c", NBODialogSearch.this.list2);
                        } else {
                            NBODialogSearch.this.opBas(NBODialogSearch.this.opBas.getSelectedItem().toString().trim().split(" ")[0]);
                        }
                    }
                });
                if (this.isOpenShell) {
                    b.add(this.alphaSpin);
                    b.add(this.betaSpin);
                }
                l2.add(b);
                continue;
            }
            if (key.equals("b2")) {
                this.bas2 = new JComboBox<String>(NBODialogView.basSet);
                this.bas2.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
                this.bas2.setSelectedIndex(1);
                this.bas2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialogSearch.this.basChange();
                        NBODialogSearch.this.list2.removeAllElements();
                        NBODialogSearch.this.getListSearch("c", NBODialogSearch.this.list2);
                    }
                });
                l2.add(this.bas2);
                continue;
            }
            if (!key.equals("b12")) continue;
            this.basis = new JComboBox<String>(NBODialogView.basSet);
            this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
            l2.add(this.basis);
        }
        this.appendOutputWithCaret(this.keyProp + " Search Results:", 'i');
        JLabel lab = new JLabel("Settings");
        lab.setFont(nboFont);
        lab.setOpaque(true);
        lab.setBackground(Color.black);
        lab.setForeground(Color.white);
        this.settingsBox.add((Component)lab, "North");
        this.settingsBox.add((Component)l, "West");
        this.settingsBox.add((Component)l2, "Center");
    }

    protected void getSearchValue(int op) {
        if (this.relabel) {
            this.showAtomNums(this.alphaSpin.isSelected());
            this.relabel = false;
            if (!this.useWireMesh) {
                this.runScriptQueued("nbo nomesh fill translucent " + this.opacityOp);
                this.runScriptQueued("mo nomesh fill translucent " + this.opacityOp);
            }
            this.runScriptQueued("nbo color " + this.color2 + " " + this.color1);
            this.runScriptQueued("mo color " + this.color2 + " " + this.color1);
        }
        SB sb = new SB();
        sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
        sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
        sb.append("GLOBAL I_KEYWORD " + this.keywordNumber + sep);
        boolean isLabel = false;
        boolean isLabelBonds = false;
        if (this.isOpenShell) {
            sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
        } else {
            sb.append("GLOBAL I_SPIN 0" + sep);
        }
        switch (this.keywordNumber) {
            case 1: {
                sb.append("GLOBAL I_ATOM_1 " + (this.at1.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_UNIT_1 " + (this.unit.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_ORB_1 " + (this.orb2.getSelectedIndex() + 1) + sep);
                if (op <= 10) break;
                isLabel = true;
                op = 12;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                sb.append("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep);
                break;
            }
            case 4: {
                sb.append("GLOBAL I_d_NBO_1 " + (this.orb.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_a_NBO " + (this.orb2.getSelectedIndex() + 1 + this.orb.getModel().getSize()) + sep);
                sb.append("GLOBAL I_UNIT_1 " + (this.unit.getSelectedIndex() + 1) + sep);
                break;
            }
            case 6: {
                sb.append("GLOBAL I_ATOM_1 " + (this.at1.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_ATOM_2 " + (this.at2.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_RES_STR " + (this.unit.getSelectedIndex() + 1) + sep);
                isLabel = op == 9;
                isLabelBonds = op == 10;
                break;
            }
            case 7: {
                sb.append("GLOBAL I_d_NBO_1 " + (this.orb.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_d_NBO_2 " + (this.orb2.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_UNIT_1 " + (this.unit.getSelectedIndex() + 1) + sep);
                break;
            }
            case 8: {
                sb.append("GLOBAL I_CMO " + (this.orb2.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_NBO " + (this.orb.getSelectedIndex() + 1) + sep);
                break;
            }
            case 9: {
                sb.append("GLOBAL I_ORB_1 " + (this.orb.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_UNIT_1 " + (this.unit.getSelectedIndex() + 1) + sep);
                break;
            }
            case 10: {
                sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_OPERATOR " + (this.operator + 1) + sep);
                sb.append("GLOBAL I_ROW " + (this.orb.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_COLUMN " + (this.orb2.getSelectedIndex() + 1) + sep);
                break;
            }
            case 11: {
                sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_BAS_2 " + (this.bas2.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_ROW " + (this.orb.getSelectedIndex() + 1) + sep);
                sb.append("GLOBAL I_COLUMN " + (this.orb2.getSelectedIndex() + 1) + sep);
            }
        }
        sb.append("GLOBAL I_OPT_" + this.keyProp + " " + op);
        if (isLabel) {
            this.relabel = true;
            this.nboService.rawCmdNew("s", sb, 50, null, "Getting list");
        } else if (isLabelBonds) {
            this.relabel = true;
            this.nboService.rawCmdNew("s", sb, 62, null, "Getting list");
        } else {
            this.nboService.rawCmdNew("s", sb, 45, null, "Getting value");
        }
    }

    protected void notifyList_s(DefaultComboBoxModel<String> list) {
        if (list == null) {
            return;
        }
        switch (this.keywordNumber) {
            case 8: {
                if (!list.equals(this.list1)) break;
                break;
            }
            case 4: {
                if (list.equals(this.list2)) {
                    int offset = this.list1.getSize();
                    int sz = this.list2.getSize();
                    ActionListener l = this.orb2.getActionListeners()[0];
                    this.orb2.removeActionListener(l);
                    for (int i = 0; i < sz; ++i) {
                        String s = this.list2.getElementAt(i);
                        this.list2.removeElementAt(i);
                        s = "   " + (offset + i + 1) + s.substring(s.indexOf("."));
                        this.list2.insertElementAt(s, i);
                    }
                    this.orb2.addActionListener(l);
                }
            }
            case 1: 
            case 7: 
            case 9: {
                if (!list.equals(this.list3) || this.list3.getSize() != 1) break;
                this.unit.setVisible(false);
                this.unitLabel.setVisible(true);
                this.unitLabel.setText(this.list3.getElementAt(0).substring(6));
                break;
            }
            case 6: {
                if (!list.equals(this.list3)) break;
                this.changeKey(this.nrt);
                this.parseRsList(this.fileHndlr.getRSList());
                this.unit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NBODialogSearch.this.isOpenShell) {
                            NBODialogSearch.this.setResStruct(NBODialogSearch.this.unit.getSelectedIndex() + 1, NBODialogSearch.this.alphaSpin.isSelected());
                        } else {
                            NBODialogSearch.this.setResStruct(NBODialogSearch.this.unit.getSelectedIndex() + 1, true);
                        }
                    }
                });
                this.setResStruct(1, this.alphaSpin.isSelected());
                break;
            }
            case 10: 
            case 11: {
                if (!list.equals(this.list2)) break;
                this.orb.removeActionListener(this.orb.getActionListeners()[0]);
                this.orb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialogSearch.this.showOrbJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.orb.getSelectedIndex() + 1);
                    }
                });
                this.orb2.removeActionListener(this.orb2.getActionListeners()[0]);
                this.orb2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NBODialogSearch.this.keywordNumber == 10) {
                            NBODialogSearch.this.showMOJmol(NBODialogSearch.this.basis.getSelectedItem().toString(), NBODialogSearch.this.orb2.getSelectedIndex() + 1);
                        } else {
                            NBODialogSearch.this.showMOJmol(NBODialogSearch.this.bas2.getSelectedItem().toString(), NBODialogSearch.this.orb2.getSelectedIndex() + 1);
                        }
                    }
                });
                this.orb.setSelectedIndex(0);
                this.orb2.setSelectedIndex(0);
            }
        }
    }

    private void parseRsList(String[] toks) {
        String[] tmp1 = toks[0].split("\n");
        int size = tmp1.length;
        this.resStructDef = new int[size][size];
        for (int i = 0; i < size; ++i) {
            String[] tmp = tmp1[i].substring(10).trim().split("\\s+");
            for (int j = 0; j < tmp.length; ++j) {
                if (tmp[j].length() <= 0) continue;
                this.resStructDef[i][j] = Integer.parseInt(tmp[j]);
            }
        }
        this.resStructList = new Hashtable();
        try {
            BufferedReader br = new BufferedReader(new StringReader(toks[1]));
            String line = br.readLine();
            line = br.readLine();
            int num = 1;
            String list = "";
            while ((line = br.readLine()) != null) {
                String n = line.substring(0, 10).trim();
                if (n.equals("")) {
                    list = list + line.substring(18).trim();
                    continue;
                }
                if (n.contains("-")) break;
                if (!list.equals("")) {
                    Integer rs = new Integer(++num);
                    this.resStructList.put(rs, list);
                }
                list = "";
                list = list + line.substring(18).trim();
            }
            Integer rs = new Integer(++num);
            this.resStructList.put(rs, list);
        }
        catch (Exception e) {
            return;
        }
    }

    protected void setResStruct(int rsNum, boolean alpha) {
        int i;
        int sz = this.resStructDef.length;
        this.chooseList.lonePairs = new Hashtable();
        int[][] tmp = new int[sz][sz];
        for (int i2 = 0; i2 < sz; ++i2) {
            for (int j = 0; j < sz; ++j) {
                tmp[i2][j] = this.resStructDef[i2][j];
            }
        }
        String rs = this.resStructList.get(new Integer(rsNum));
        if (rs != null) {
            String[] rsList = rs.split(",");
            for (int i3 = 0; i3 < rsList.length; ++i3) {
                int inc = rsList[i3].contains("(") ? -1 : 1;
                String bond = rsList[i3].replaceAll("[\\D]", " ").trim();
                String[] toks = bond.split("\\s+");
                int a1 = Integer.parseInt(toks[0]) - 1;
                if (toks.length < 2) {
                    int[] nArray = tmp[a1];
                    int n = a1;
                    nArray[n] = nArray[n] + inc;
                    continue;
                }
                int a2 = Integer.parseInt(toks[1]) - 1;
                int[] nArray = tmp[a1];
                int n = a2;
                nArray[n] = nArray[n] + inc;
                int[] nArray2 = tmp[a2];
                int n2 = a1;
                nArray2[n2] = nArray2[n2] + inc;
            }
        }
        this.vwr.ms.deleteAllBonds();
        int[] bondCounts = new int[this.vwr.ms.ac];
        for (i = 0; i < sz; ++i) {
            for (int j = i; j < sz; ++j) {
                if (tmp[i][j] <= 0) continue;
                if (i == j) {
                    this.chooseList.lonePairs.put(new Integer(i + 1).toString(), new Integer(tmp[i][j]).toString());
                    continue;
                }
                if (tmp[i][j] <= 0) continue;
                int mad = tmp[i][j] > 2 ? 150 : 250;
                this.vwr.ms.bondAtoms(this.vwr.ms.at[i], this.vwr.ms.at[j], tmp[i][j], (short)mad, this.vwr.ms.bsVisible, 0.0f, true, true);
                int n = i;
                bondCounts[n] = bondCounts[n] + tmp[i][j];
                int n3 = j;
                bondCounts[n3] = bondCounts[n3] + tmp[i][j];
            }
        }
        if (this.nboView) {
            this.runScriptQueued("select add {*}.bonds;color bonds lightgrey;wireframe 0.1;select remove {*}");
        }
        for (i = 0; i < this.vwr.ms.ac; ++i) {
            this.vwr.ms.at[i].setFormalCharge(0);
            this.vwr.ms.at[i].setValence(bondCounts[i]);
        }
        SB sb = new SB();
        this.vwr.ms.fixFormalCharges(this.vwr.getAllAtoms());
        if (this.chooseList != null) {
            Hashtable<String, String> lonePairs = alpha ? this.chooseList.lonePairs : this.chooseList.lonePairs_b;
            for (int i4 = 1; i4 <= this.vwr.ms.ac; ++i4) {
                sb.append("select (atomno=" + i4 + ");label ");
                String atNum = new Integer(i4).toString();
                String lp = lonePairs.get(atNum);
                if (lp != null && !lp.equals("0")) {
                    sb.append("<sup>(" + lp + ")</sup>");
                }
                sb.append("%a");
                int charge = this.vwr.ms.at[i4 - 1].getFormalCharge();
                if (charge != 0) {
                    sb.append("<sup>" + (charge > 0 ? "+" : "") + charge + "</sup>;");
                    continue;
                }
                sb.append(";");
            }
            this.runScriptQueued(sb.toString());
        }
        this.runScriptQueued("select remove{*}; select add (atomno=" + (this.at1.getSelectedIndex() + 1) + ");" + "select add (atomno=" + (this.at2.getSelectedIndex() + 1) + ");");
    }

    protected void orbPick() {
        if (this.rbSelection < 0) {
            return;
        }
        switch (this.keywordNumber) {
            case 1: {
                if (this.rbSelection <= 4 || this.rbSelection >= 10) break;
                this.rBtns[this.rbSelection].doClick();
                break;
            }
            case 2: {
                if (this.rbSelection >= 4) break;
                this.rBtns[this.rbSelection].doClick();
                break;
            }
            case 3: {
                if (this.rbSelection >= 6) break;
                this.rBtns[this.rbSelection].doClick();
                break;
            }
            case 4: {
                if (this.rbSelection >= 3) break;
                this.rBtns[this.rbSelection].doClick();
                break;
            }
            case 5: {
                this.rBtns[this.rbSelection].doClick();
                break;
            }
            case 7: {
                if (this.rbSelection <= 1 || this.rbSelection >= 4) break;
                this.rBtns[this.rbSelection].doClick();
                break;
            }
            case 8: {
                this.rBtns[this.rbSelection].doClick();
                break;
            }
            case 9: {
                if (this.rbSelection <= 2 || this.rbSelection >= 6) break;
                this.rBtns[this.rbSelection].doClick();
            }
        }
    }

    protected void notifyPick_s(String atomno) {
        int atomIndex = 0;
        try {
            atomIndex = Integer.parseInt(atomno) - 1;
            if (this.keywordNumber == 2 || this.keywordNumber == 3 || this.keywordNumber == 5 || this.keywordNumber == 4) {
                this.pickAtomic(atomno, this.list1, this.orb);
                return;
            }
            if (this.keywordNumber == 8) {
                this.pickAtomic(atomno, this.list2, this.orb2);
                return;
            }
        }
        catch (NumberFormatException e) {
            String[] tok = atomno.split(",");
            if (tok.length < 2) {
                this.pickAtomic(atomno, this.alphaList, this.orb);
                return;
            }
            String[] tok2 = tok[1].split(" ");
            block1 : switch (this.keywordNumber) {
                case 2: 
                case 5: 
                case 8: 
                case 9: {
                    this.pickNBO(tok2[2], tok2[5], this.list1, this.orb);
                    break;
                }
                case 3: {
                    this.pickNHO(tok2[2], tok2[5], this.list1, this.orb);
                    break;
                }
                case 6: {
                    tok = atomno.split(",");
                    int a1 = Integer.parseInt(tok2[2].replaceAll("[\\D]", ""));
                    int a2 = Integer.parseInt(tok2[5].replaceAll("[\\D]", ""));
                    this.at1.setSelectedIndex(a1 - 1);
                    this.at2.setSelectedIndex(a2 - 1);
                    if (this.rbSelection > 2 && this.rbSelection < 6) {
                        this.rBtns[this.rbSelection].doClick();
                    }
                    return;
                }
                case 4: 
                case 7: {
                    tok = atomno.split(",");
                    tok2 = tok[1].split(" ");
                    String bond = tok2[2] + "-" + tok2[5];
                    String str = this.orb.getSelectedItem().toString().replace(" ", "");
                    if (str.contains(bond)) {
                        this.pickNBO(tok2[2], tok2[5], this.list1, this.orb);
                        return;
                    }
                    str = this.orb2.getSelectedItem().toString().replace(" ", "");
                    if (str.contains(bond)) {
                        this.pickNBO(tok2[2], tok2[5], this.list2, this.orb2);
                        return;
                    }
                    if (!this.secondPick) {
                        this.pickNBO(tok2[2], tok2[5], this.list2, this.orb2);
                    } else {
                        this.pickNBO(tok2[2], tok2[5], this.list1, this.orb);
                    }
                    this.secondPick = !this.secondPick;
                    break;
                }
                case 10: 
                case 11: {
                    JComboBox<String> tmpBas = this.basis;
                    if (this.keywordNumber == 11 && !this.secondPick) {
                        tmpBas = this.bas2;
                    }
                    switch (tmpBas.getSelectedIndex()) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            tok = atomno.split(",");
                            tok2 = tok[1].split(" ");
                            String bond = tok2[2] + "-" + tok2[5];
                            String str = this.orb.getSelectedItem().toString().replace(" ", "");
                            if (str.contains(bond)) {
                                this.pickNBO(tok2[2], tok2[5], this.list1, this.orb);
                                return;
                            }
                            str = this.orb2.getSelectedItem().toString().replace(" ", "");
                            if (str.contains(bond)) {
                                this.pickNBO(tok2[2], tok2[5], this.list2, this.orb2);
                                return;
                            }
                            if (!this.secondPick) {
                                this.pickNBO(tok2[2], tok2[5], this.list2, this.orb2);
                            } else {
                                this.pickNBO(tok2[2], tok2[5], this.list1, this.orb);
                            }
                            this.secondPick = !this.secondPick;
                            break block1;
                        }
                        case 3: 
                        case 4: {
                            if (!this.secondPick) {
                                this.pickNHO(tok2[2], tok2[5], this.list2, this.orb2);
                            } else {
                                this.pickNHO(tok2[2], tok2[5], this.list1, this.orb);
                            }
                            this.secondPick = !this.secondPick;
                            break block1;
                        }
                    }
                    this.secondPick = !this.secondPick;
                }
            }
            return;
        }
        if (this.at1 != null && this.at2 == null) {
            this.at1.setSelectedIndex(atomIndex);
            if (this.rbSelection < 3 && this.rbSelection > -1) {
                this.rBtns[this.rbSelection].doClick();
            }
        } else if (this.at1 != null && this.at2 != null) {
            if (this.secondPick) {
                this.at1.setSelectedIndex(atomIndex);
            } else {
                this.at2.setSelectedIndex(atomIndex);
            }
            this.secondPick = !this.secondPick;
        }
    }

    protected void showMax(String line) {
    }

    protected void notifyLoad_s() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        if (this.keywordNumber == 8) {
            if (this.vwr.ms.mc == 1) {
                return;
            }
            this.runScriptQueued("frame 0");
            this.isNewJob = false;
        }
        if (!this.useWireMesh) {
            this.runScriptQueued("nbo nomesh fill translucent " + this.opacityOp);
            this.runScriptQueued("mo nomesh fill translucent " + this.opacityOp);
        }
        this.runScriptQueued("nbo color " + this.color2 + " " + this.color1);
        this.runScriptQueued("mo color " + this.color2 + " " + this.color1);
        this.rbSelection = -1;
        if (this.isOpenShell) {
            this.alphaSpin.setVisible(true);
            this.betaSpin.setVisible(true);
        } else {
            this.alphaSpin.setVisible(false);
            this.betaSpin.setVisible(false);
        }
        if (!this.fileHndlr.getChooseList()) {
            this.vwr.alert("Error reading $CHOOSE list");
        }
        this.showAtomNums(true);
        this.setBonds(true);
        this.optionBox.setVisible(true);
        if (this.keywordNumber > 0 && this.isNewJob) {
            this.isNewJob = false;
            this.keywordClicked(this.keywordNumber);
        }
    }

    @Override
    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(this, st, "Message", 0);
        if (i == 0) {
            JDialog d = new JDialog(this);
            d.setLayout(new BorderLayout());
            JTextPane tp = new JTextPane();
            d.add((Component)tp, "Center");
            d.setSize(new Dimension(500, 600));
            tp.setText(this.fileHndlr.getFileData(FileHndlr.newNBOFile(newFile, "nbo").toString()));
            d.setVisible(true);
        }
    }
}

