/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AlignImageryPanel;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddImageryLayerAction
extends JosmAction
implements AdaptableAction {
    private final transient ImageryInfo info;

    public AddImageryLayerAction(ImageryInfo imageryInfo) {
        super(imageryInfo.getMenuName(), "imagery_menu", I18n.tr("Add imagery layer {0}", imageryInfo.getName()), null, false, false);
        this.putValue("toolbar", "imagery_" + imageryInfo.getToolbarName());
        this.putValue("help", HelpUtil.ht("/Preferences/Imagery"));
        this.info = imageryInfo;
        this.installAdapters();
        String string = imageryInfo.getIcon();
        if (string != null) {
            new ImageProvider(string).setOptional(true).getResourceAsync().thenAccept(imageResource -> {
                if (imageResource != null) {
                    GuiHelper.runInEDT(() -> imageResource.attachImageIcon(this));
                }
            });
        }
    }

    private ImageryInfo convertImagery(ImageryInfo imageryInfo) {
        try {
            switch (imageryInfo.getImageryType()) {
                case WMS_ENDPOINT: {
                    return this.getWMSLayerInfo();
                }
                case WMTS: {
                    String string = new WMTSTileSource(imageryInfo).userSelectLayer();
                    if (string != null) {
                        ImageryInfo imageryInfo2 = new ImageryInfo(imageryInfo);
                        ArrayList<String> arrayList = new ArrayList<String>(1);
                        arrayList.add(string);
                        imageryInfo2.setDefaultLayers(arrayList);
                        return imageryInfo2;
                    }
                    return null;
                }
            }
            return imageryInfo;
        }
        catch (MalformedURLException malformedURLException) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            Main.error((Throwable)malformedURLException, false);
        }
        catch (IOException iOException) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            Main.error((Throwable)iOException, false);
        }
        catch (WMSImagery.WMSGetCapabilitiesException wMSGetCapabilitiesException) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            Main.error((Throwable)wMSGetCapabilitiesException, "Could not parse WMS layer list. Incoming data:\n" + wMSGetCapabilitiesException.getIncomingData());
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            ImageryInfo imageryInfo = this.convertImagery(this.info);
            if (imageryInfo != null) {
                Main.getLayerManager().addLayer(ImageryLayer.create(imageryInfo));
                AlignImageryPanel.addNagPanelIfNeeded(imageryInfo);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty() || GraphicsEnvironment.isHeadless()) {
                throw illegalArgumentException;
            }
            JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    protected ImageryInfo getWMSLayerInfo() throws IOException, WMSImagery.WMSGetCapabilitiesException {
        CheckParameterUtil.ensureThat(ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)this.info.getImageryType()), "wms_endpoint imagery type expected");
        WMSImagery wMSImagery = new WMSImagery();
        wMSImagery.attemptGetCapabilities(this.info.getUrl());
        final WMSLayerTree wMSLayerTree = new WMSLayerTree();
        wMSLayerTree.updateTree(wMSImagery);
        List<String> list = wMSImagery.getFormats();
        final JComboBox<String> jComboBox = new JComboBox<String>(list.toArray(new String[list.size()]));
        jComboBox.setSelectedItem(wMSImagery.getPreferredFormats());
        jComboBox.setToolTipText(I18n.tr("Select image format for WMS layer", new Object[0]));
        if (!GraphicsEnvironment.isHeadless() && 1 != new ExtendedDialog(Main.parent, I18n.tr("Select WMS layers", new Object[0]), new String[]{I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0])}){
            {
                super(component, string, stringArray);
                JScrollPane jScrollPane = new JScrollPane(wMSLayerTree.getLayerTree());
                jScrollPane.setPreferredSize(new Dimension(400, 400));
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)jScrollPane, GBC.eol().fill());
                jPanel.add((Component)jComboBox, GBC.eol().fill(2));
                this.setContent(jPanel);
            }
        }.showDialog().getValue()) {
            return null;
        }
        String string = wMSImagery.buildGetMapUrl(wMSLayerTree.getSelectedLayers(), (String)jComboBox.getSelectedItem());
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (WMSImagery.LayerDetails layerDetails : wMSLayerTree.getSelectedLayers()) {
            if (bl) {
                hashSet.addAll(layerDetails.getProjections());
                bl = false;
            }
            stringBuilder.append(layerDetails.name);
            stringBuilder.append(", ");
            hashSet.retainAll(layerDetails.getProjections());
        }
        ImageryInfo imageryInfo = new ImageryInfo(this.info);
        imageryInfo.setUrl(string);
        imageryInfo.setImageryType(ImageryInfo.ImageryType.WMS);
        if (stringBuilder.length() > 2) {
            imageryInfo.setName(imageryInfo.getName() + ' ' + stringBuilder.substring(0, stringBuilder.length() - 2));
        }
        imageryInfo.setServerProjections(hashSet);
        return imageryInfo;
    }

    @Override
    protected void updateEnabledState() {
        if (this.info.isBlacklisted()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

