/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.data.correction.RoleCorrection;
import org.openstreetmap.josm.data.correction.TagCorrection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UserCancelException;

public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static final String SEPARATOR = "[:_]";
    private static final Collection<Pattern> ignoredKeys = new ArrayList<Pattern>();
    private static final StringSwitcher FORWARD_BACKWARD;
    private static final StringSwitcher UP_DOWN;
    private static final IStringSwitcher COMBINED_SWITCHERS;

    private static Pattern getPatternFor(String string) {
        return ReverseWayTagCorrector.getPatternFor(string, false);
    }

    private static Pattern getPatternFor(String string, boolean bl) {
        if (bl) {
            return Pattern.compile("(^)(" + string + ")($)");
        }
        return Pattern.compile("(^|.*[:_])(" + string + ")(" + SEPARATOR + ".*|$)", 2);
    }

    public static boolean isReversible(Way way) {
        for (Tag tag : TagCollection.from(way)) {
            if (tag.equals(TagSwitcher.apply(tag))) continue;
            return false;
        }
        return true;
    }

    public static List<Way> irreversibleWays(List<Way> list) {
        ArrayList<Way> arrayList = new ArrayList<Way>(list);
        for (Way way : list) {
            if (!ReverseWayTagCorrector.isReversible(way)) continue;
            arrayList.remove(way);
        }
        return arrayList;
    }

    public static String invertNumber(String string) {
        Pattern pattern = Pattern.compile("^([+-]?)(\\d.*)$", 2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        string2 = "-".equals(string2) ? "" : "-";
        return string2 + string3;
    }

    static List<TagCorrection> getTagCorrections(Tagged tagged) {
        ArrayList<TagCorrection> arrayList = new ArrayList<TagCorrection>();
        for (Map.Entry<String, String> entry : tagged.getKeys().entrySet()) {
            boolean bl;
            String string = entry.getKey();
            String string2 = entry.getValue();
            Tag tag = TagSwitcher.apply(string, string2);
            String string3 = tag.getKey();
            String string4 = tag.getValue();
            boolean bl2 = bl = !string.equals(string3);
            if (tagged.get(string3) != null && tagged.get(string3).equals(string4)) {
                bl = false;
            }
            if (!string2.equals(string4)) {
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(new TagCorrection(string, string2, string3, string4));
        }
        return arrayList;
    }

    static List<RoleCorrection> getRoleCorrections(Way way) {
        ArrayList<RoleCorrection> arrayList = new ArrayList<RoleCorrection>();
        List<OsmPrimitive> list = way.getReferrers();
        for (OsmPrimitive osmPrimitive : list) {
            if (!(osmPrimitive instanceof Relation)) continue;
            Relation relation = (Relation)osmPrimitive;
            int n = 0;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.getMember().hasEqualSemanticAttributes(way) || !relationMember.hasRole()) {
                    ++n;
                    continue;
                }
                String string = (String)COMBINED_SWITCHERS.apply(relationMember.getRole());
                if (!relationMember.getRole().equals(string)) {
                    arrayList.add(new RoleCorrection(relation, n, relationMember, string));
                }
                ++n;
            }
        }
        return arrayList;
    }

    static Map<OsmPrimitive, List<TagCorrection>> getTagCorrectionsMap(Way way) {
        HashMap<OsmPrimitive, List<TagCorrection>> hashMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        List<TagCorrection> list = ReverseWayTagCorrector.getTagCorrections(way);
        if (!list.isEmpty()) {
            hashMap.put(way, list);
        }
        for (Node node : way.getNodes()) {
            List<TagCorrection> list2 = ReverseWayTagCorrector.getTagCorrections(node);
            if (list2.isEmpty()) continue;
            hashMap.put(node, list2);
        }
        return hashMap;
    }

    @Override
    public Collection<Command> execute(Way way, Way way2) throws UserCancelException {
        Map<OsmPrimitive, List<TagCorrection>> map = ReverseWayTagCorrector.getTagCorrectionsMap(way2);
        HashMap<OsmPrimitive, List<RoleCorrection>> hashMap = new HashMap<OsmPrimitive, List<RoleCorrection>>();
        List<RoleCorrection> list = ReverseWayTagCorrector.getRoleCorrections(way);
        if (!list.isEmpty()) {
            hashMap.put(way2, list);
        }
        return this.applyCorrections(map, hashMap, I18n.tr("When reversing this way, the following changes are suggested in order to maintain data consistency.", new Object[0]));
    }

    private static boolean ignoreKeyForCorrection(String string) {
        for (Pattern pattern : ignoredKeys) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        for (String string : OsmPrimitive.getUninterestingKeys()) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(string));
        }
        for (String string : new String[]{"name", "ref", "tiger:county"}) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(string, false));
        }
        for (String string : new String[]{"tiger:county", "turn:lanes", "change:lanes", "placement"}) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(string, true));
        }
        FORWARD_BACKWARD = new StringSwitcher("forward", "backward");
        UP_DOWN = new StringSwitcher("up", "down");
        COMBINED_SWITCHERS = IStringSwitcher.combined(new StringSwitcher("left", "right"), new StringSwitcher("forwards", "backwards"), new StringSwitcher("east", "west"), new StringSwitcher("north", "south"), FORWARD_BACKWARD, UP_DOWN);
    }

    public static final class TagSwitcher {
        private TagSwitcher() {
        }

        public static Tag apply(Tag tag) {
            return TagSwitcher.apply(tag.getKey(), tag.getValue());
        }

        public static Tag apply(String string, String string2) {
            String string3 = string;
            String string4 = string2;
            if (string.startsWith("oneway") || string.endsWith("oneway")) {
                if (OsmUtils.isReversed(string2)) {
                    string4 = "yes";
                } else if (OsmUtils.isTrue(string2)) {
                    string4 = "-1";
                }
                string3 = (String)COMBINED_SWITCHERS.apply(string);
            } else if (string.startsWith("incline") || string.endsWith("incline")) {
                string4 = UP_DOWN.apply(string2);
                if (string4.equals(string2)) {
                    string4 = ReverseWayTagCorrector.invertNumber(string2);
                }
            } else if (string.startsWith("direction") || string.endsWith("direction")) {
                string4 = (String)COMBINED_SWITCHERS.apply(string2);
            } else if (string.endsWith(":forward") || string.endsWith(":backward")) {
                string3 = FORWARD_BACKWARD.apply(string);
            } else if (!ReverseWayTagCorrector.ignoreKeyForCorrection(string)) {
                string3 = (String)COMBINED_SWITCHERS.apply(string);
                string4 = (String)COMBINED_SWITCHERS.apply(string2);
            }
            return new Tag(string3, string4);
        }
    }

    private static class StringSwitcher
    implements IStringSwitcher {
        private final String a;
        private final String b;
        private final Pattern pattern;

        StringSwitcher(String string, String string2) {
            this.a = string;
            this.b = string2;
            this.pattern = ReverseWayTagCorrector.getPatternFor(string + '|' + string2);
        }

        @Override
        public String apply(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.lookingAt()) {
                String string2 = matcher.group(2).toLowerCase(Locale.ENGLISH);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, matcher.start(2))).append(string2.equals(this.a) ? this.b : this.a).append(string.substring(matcher.end(2)));
                return stringBuilder.toString();
            }
            return string;
        }
    }

    private static interface IStringSwitcher
    extends Function<String, String> {
        public static IStringSwitcher combined(IStringSwitcher ... iStringSwitcherArray) {
            return string -> {
                for (IStringSwitcher iStringSwitcher : iStringSwitcherArray) {
                    String string2 = (String)iStringSwitcher.apply(string);
                    if (string.equals(string2)) continue;
                    return string2;
                }
                return string;
            };
        }
    }
}

