/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public abstract class OsmPrimitive
extends AbstractPrimitive
implements Comparable<OsmPrimitive>,
TemplateEngineDataProvider {
    private static final String SPECIAL_VALUE_ID = "id";
    private static final String SPECIAL_VALUE_LOCAL_NAME = "localname";
    protected static final int FLAG_DISABLED = 16;
    protected static final int FLAG_HIDE_IF_DISABLED = 32;
    protected static final int FLAG_DISABLED_TYPE = 64;
    protected static final int FLAG_HIDDEN_TYPE = 128;
    protected static final int FLAG_HAS_DIRECTIONS = 256;
    protected static final int FLAG_TAGGED = 512;
    protected static final int FLAG_DIRECTION_REVERSED = 1024;
    protected static final int FLAG_HIGHLIGHTED = 2048;
    protected static final int FLAG_ANNOTATED = 4096;
    static volatile SearchCompiler.Match directionKeys;
    private static volatile SearchCompiler.Match reversedDirectionKeys;
    public StyleCache mappaintStyle;
    public int mappaintCacheIdx;
    private DataSet dataSet;
    private static volatile Collection<String> workinprogress;
    private static volatile Collection<String> uninteresting;
    private static volatile Collection<String> discardable;
    private Object referrers;

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> collection, Class<T> clazz) {
        if (collection == null) {
            return Collections.emptyList();
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!clazz.isInstance(osmPrimitive)) continue;
            linkedList.add(clazz.cast(osmPrimitive));
        }
        return linkedList;
    }

    public static <T extends OsmPrimitive> Set<T> getFilteredSet(Collection<OsmPrimitive> collection, Class<T> clazz) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        if (collection != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!clazz.isInstance(osmPrimitive)) continue;
                linkedHashSet.add(clazz.cast(osmPrimitive));
            }
        }
        return linkedHashSet;
    }

    public static Set<OsmPrimitive> getReferrer(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null || collection.isEmpty()) {
            return hashSet;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            hashSet.addAll(osmPrimitive.getReferrers());
        }
        return hashSet;
    }

    protected OsmPrimitive(long l, boolean bl) {
        if (bl) {
            this.id = l;
        } else {
            if (l < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Expected ID >= 0. Got {0}.", l));
            }
            this.id = l == 0L ? OsmPrimitive.generateUniqueId() : l;
        }
        this.version = 0;
        this.setIncomplete(l > 0L);
    }

    protected OsmPrimitive(long l, int n, boolean bl) {
        this(l, bl);
        this.version = l > 0L ? n : 0;
        this.setIncomplete(l > 0L && n == 0);
    }

    public void clearCachedStyle() {
        this.mappaintStyle = null;
    }

    void setDataset(DataSet dataSet) {
        if (this.dataSet != null && dataSet != null && this.dataSet != dataSet) {
            throw new DataIntegrityProblemException("Primitive cannot be included in more than one Dataset");
        }
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void checkDataset() {
        if (this.dataSet == null) {
            throw new DataIntegrityProblemException("Primitive must be part of the dataset: " + this.toString());
        }
    }

    protected boolean writeLock() {
        if (this.dataSet != null) {
            this.dataSet.beginUpdate();
            return true;
        }
        return false;
    }

    protected void writeUnlock(boolean bl) {
        if (bl) {
            this.dataSet.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOsmId(long l, int n) {
        boolean bl = this.writeLock();
        try {
            if (l <= 0L) {
                throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", l));
            }
            if (n <= 0) {
                throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", n));
            }
            if (this.dataSet != null && l != this.id) {
                DataSet dataSet = this.dataSet;
                dataSet.removePrimitive(this);
                this.id = l;
                dataSet.addPrimitive(this);
            }
            super.setOsmId(l, n);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public void clearOsmMetadata() {
        if (this.dataSet != null) {
            throw new DataIntegrityProblemException("Method cannot be called after primitive was added to the dataset");
        }
        super.clearOsmMetadata();
    }

    @Override
    public void setUser(User user) {
        boolean bl = this.writeLock();
        try {
            super.setUser(user);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChangesetId(int n) {
        boolean bl = this.writeLock();
        try {
            int n2 = this.changesetId;
            super.setChangesetId(n);
            if (this.dataSet != null) {
                this.dataSet.fireChangesetIdChanged(this, n2, n);
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public void setTimestamp(Date date) {
        boolean bl = this.writeLock();
        try {
            super.setTimestamp(date);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    private void updateFlagsNoLock(int n, boolean bl) {
        super.updateFlags(n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateFlags(int n, boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            this.updateFlagsNoLock(n, bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDisabledState(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            short s = this.flags;
            this.updateFlagsNoLock(16, true);
            this.updateFlagsNoLock(32, bl);
            boolean bl3 = s != this.flags;
            return bl3;
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsetDisabledState() {
        boolean bl = this.writeLock();
        try {
            short s = this.flags;
            this.updateFlagsNoLock(48, false);
            boolean bl2 = s != this.flags;
            return bl2;
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public void setDisabledType(boolean bl) {
        this.updateFlags(64, bl);
    }

    public void setHiddenType(boolean bl) {
        this.updateFlags(128, bl);
    }

    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isDisabledAndHidden() {
        return (this.flags & 0x10) != 0 && (this.flags & 0x20) != 0;
    }

    public boolean getHiddenType() {
        return (this.flags & 0x80) != 0;
    }

    public boolean getDisabledType() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isSelectable() {
        return !this.isDisabled() && this.isDrawable() && !this.isDisabled();
    }

    public boolean isDrawable() {
        return (this.flags & 0x2C) == 0;
    }

    @Override
    public void setModified(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            super.setModified(bl);
            if (this.dataSet != null) {
                this.dataSet.firePrimitiveFlagsChanged(this);
            }
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            super.setVisible(bl);
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    @Override
    public void setDeleted(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            super.setDeleted(bl);
            if (this.dataSet != null) {
                if (bl) {
                    this.dataSet.firePrimitivesRemoved(Collections.singleton(this), false);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singleton(this), false);
                }
            }
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    @Override
    protected final void setIncomplete(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            if (this.dataSet != null && bl != this.isIncomplete()) {
                if (bl) {
                    this.dataSet.firePrimitivesRemoved(Collections.singletonList(this), true);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singletonList(this), true);
                }
            }
            super.setIncomplete(bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    public boolean isSelected() {
        return this.dataSet != null && this.dataSet.isSelected(this);
    }

    public boolean isMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.referrers instanceof Relation && ((OsmPrimitive)this.referrers).isSelected();
        }
        for (OsmPrimitive osmPrimitive : (OsmPrimitive[])this.referrers) {
            if (!(osmPrimitive instanceof Relation) || !osmPrimitive.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isOuterMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.isOuterMemberOfMultipolygon((OsmPrimitive)this.referrers);
        }
        for (OsmPrimitive osmPrimitive : (OsmPrimitive[])this.referrers) {
            if (!this.isOuterMemberOfMultipolygon(osmPrimitive)) continue;
            return true;
        }
        return false;
    }

    private boolean isOuterMemberOfMultipolygon(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Relation && osmPrimitive.isSelected() && ((Relation)osmPrimitive).isMultipolygon()) {
            for (RelationMember relationMember : ((Relation)osmPrimitive).getMembersFor(Collections.singleton(this))) {
                if (!"outer".equals(relationMember.getRole())) continue;
                return true;
            }
        }
        return false;
    }

    public void setHighlighted(boolean bl) {
        if (this.isHighlighted() != bl) {
            this.updateFlags(2048, bl);
            if (this.dataSet != null) {
                this.dataSet.fireHighlightingChanged();
            }
        }
    }

    public boolean isHighlighted() {
        return (this.flags & 0x800) != 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList("source", "source_ref", "source:", "comment", "watch", "watch:", "description", "attribution"));
            linkedList.addAll(OsmPrimitive.getDiscardableKeys());
            linkedList.addAll(OsmPrimitive.getWorkInProgressKeys());
            uninteresting = Main.pref.getCollection("tags.uninteresting", linkedList);
        }
        return uninteresting;
    }

    public static Collection<String> getDiscardableKeys() {
        if (discardable == null) {
            discardable = Main.pref.getCollection("tags.discardable", Arrays.asList("created_by", "converted_by", "geobase:datasetName", "geobase:uuid", "KSJ2:ADS", "KSJ2:ARE", "KSJ2:AdminArea", "KSJ2:COP_label", "KSJ2:DFD", "KSJ2:INT", "KSJ2:INT_label", "KSJ2:LOC", "KSJ2:LPN", "KSJ2:OPC", "KSJ2:PubFacAdmin", "KSJ2:RAC", "KSJ2:RAC_label", "KSJ2:RIC", "KSJ2:RIN", "KSJ2:WSC", "KSJ2:coordinate", "KSJ2:curve_id", "KSJ2:curve_type", "KSJ2:filename", "KSJ2:lake_id", "KSJ2:lat", "KSJ2:long", "KSJ2:river_id", "odbl", "odbl:note", "SK53_bulk:load", "sub_sea:type", "tiger:source", "tiger:separated", "tiger:tlid", "tiger:upload_uuid", "yh:LINE_NAME", "yh:LINE_NUM", "yh:STRUCTURE", "yh:TOTYUMONO", "yh:TYPE", "yh:WIDTH", "yh:WIDTH_RANK"));
        }
        return discardable;
    }

    public static Collection<String> getWorkInProgressKeys() {
        if (workinprogress == null) {
            workinprogress = Main.pref.getCollection("tags.workinprogress", Arrays.asList("note", "fixme", "FIXME"));
        }
        return workinprogress;
    }

    public static boolean isUninterestingKey(String string) {
        OsmPrimitive.getUninterestingKeys();
        if (uninteresting.contains(string)) {
            return true;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            return uninteresting.contains(string.substring(0, n + 1));
        }
        return false;
    }

    public Map<String, String> getInterestingTags() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.keys;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (OsmPrimitive.isUninterestingKey(stringArray[i])) continue;
                hashMap.put(stringArray[i], stringArray[i + 1]);
            }
        }
        return hashMap;
    }

    private static SearchCompiler.Match compileDirectionKeys(String string, String string2) throws AssertionError {
        try {
            return SearchCompiler.compile(Main.pref.get(string, string2));
        }
        catch (SearchCompiler.ParseError parseError) {
            Main.error((Throwable)parseError, "Unable to compile pattern for " + string + ", trying default pattern:");
            try {
                return SearchCompiler.compile(string2);
            }
            catch (SearchCompiler.ParseError parseError2) {
                throw new AssertionError("Unable to compile default pattern for direction keys: " + parseError2.getMessage(), parseError2);
            }
        }
    }

    private void updateTagged() {
        for (String string : this.keySet()) {
            if (OsmPrimitive.isUninterestingKey(string) || "area".equals(string)) continue;
            this.updateFlagsNoLock(512, true);
            return;
        }
        this.updateFlagsNoLock(512, false);
    }

    private void updateAnnotated() {
        for (String string : this.keySet()) {
            if (!OsmPrimitive.getWorkInProgressKeys().contains(string)) continue;
            this.updateFlagsNoLock(4096, true);
            return;
        }
        this.updateFlagsNoLock(4096, false);
    }

    public boolean isTagged() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isAnnotated() {
        return (this.flags & 0x1000) != 0;
    }

    private void updateDirectionFlags() {
        boolean bl = false;
        boolean bl2 = false;
        if (reversedDirectionKeys.match(this)) {
            bl = true;
            bl2 = true;
        }
        if (directionKeys.match(this)) {
            bl = true;
        }
        this.updateFlagsNoLock(1024, bl2);
        this.updateFlagsNoLock(256, bl);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x100) != 0;
    }

    public boolean reversedDirection() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public final void setKeys(TagMap tagMap) {
        boolean bl = this.writeLock();
        try {
            super.setKeys(tagMap);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public final void setKeys(Map<String, String> map) {
        boolean bl = this.writeLock();
        try {
            super.setKeys(map);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String string, String string2) {
        boolean bl = this.writeLock();
        try {
            super.put(string, string2);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public final void remove(String string) {
        boolean bl = this.writeLock();
        try {
            super.remove(string);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public final void removeAll() {
        boolean bl = this.writeLock();
        try {
            super.removeAll();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    protected void keysChangedImpl(Map<String, String> map) {
        this.clearCachedStyle();
        if (this.dataSet != null) {
            for (OsmPrimitive osmPrimitive : this.getReferrers()) {
                osmPrimitive.clearCachedStyle();
            }
        }
        this.updateDirectionFlags();
        this.updateTagged();
        this.updateAnnotated();
        if (this.dataSet != null) {
            this.dataSet.fireTagsChanged(this, map);
        }
    }

    protected void addReferrer(OsmPrimitive osmPrimitive) {
        if (this.referrers == null) {
            this.referrers = osmPrimitive;
        } else if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers != osmPrimitive) {
                this.referrers = new OsmPrimitive[]{(OsmPrimitive)this.referrers, osmPrimitive};
            }
        } else {
            for (OsmPrimitive osmPrimitive2 : (OsmPrimitive[])this.referrers) {
                if (osmPrimitive2 != osmPrimitive) continue;
                return;
            }
            this.referrers = Utils.addInArrayCopy((OsmPrimitive[])this.referrers, osmPrimitive);
        }
    }

    protected void removeReferrer(OsmPrimitive osmPrimitive) {
        if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers == osmPrimitive) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] osmPrimitiveArray = (OsmPrimitive[])this.referrers;
            int n = -1;
            for (int i = 0; i < osmPrimitiveArray.length; ++i) {
                if (osmPrimitiveArray[i] != osmPrimitive) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return;
            }
            if (osmPrimitiveArray.length == 2) {
                this.referrers = osmPrimitiveArray[1 - n];
            } else {
                OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[osmPrimitiveArray.length - 1];
                System.arraycopy(osmPrimitiveArray, 0, osmPrimitiveArray2, 0, n);
                System.arraycopy(osmPrimitiveArray, n + 1, osmPrimitiveArray2, n, osmPrimitiveArray2.length - n);
                this.referrers = osmPrimitiveArray2;
            }
        }
    }

    public final List<OsmPrimitive> getReferrers(boolean bl) {
        if (this.dataSet == null && bl) {
            return Collections.emptyList();
        }
        this.checkDataset();
        Object object = this.referrers;
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        if (object != null) {
            if (object instanceof OsmPrimitive) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)object;
                if (osmPrimitive.dataSet == this.dataSet) {
                    arrayList.add(osmPrimitive);
                }
            } else {
                for (OsmPrimitive osmPrimitive : (OsmPrimitive[])object) {
                    if (this.dataSet != osmPrimitive.dataSet) continue;
                    arrayList.add(osmPrimitive);
                }
            }
        }
        return arrayList;
    }

    public final List<OsmPrimitive> getReferrers() {
        return this.getReferrers(false);
    }

    public void visitReferrers(Visitor visitor) {
        if (visitor == null) {
            return;
        }
        if (this.referrers == null) {
            return;
        }
        if (this.referrers instanceof OsmPrimitive) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)this.referrers;
            if (osmPrimitive.dataSet == this.dataSet) {
                osmPrimitive.accept(visitor);
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] osmPrimitiveArray;
            for (OsmPrimitive osmPrimitive : osmPrimitiveArray = (OsmPrimitive[])this.referrers) {
                if (osmPrimitive.dataSet != this.dataSet) continue;
                osmPrimitive.accept(visitor);
            }
        }
    }

    public final boolean isReferredByWays(int n) {
        Object object = this.referrers;
        if (object == null) {
            return false;
        }
        this.checkDataset();
        if (object instanceof OsmPrimitive) {
            return n <= 1 && object instanceof Way && ((OsmPrimitive)object).dataSet == this.dataSet;
        }
        int n2 = 0;
        for (OsmPrimitive osmPrimitive : (OsmPrimitive[])object) {
            if (this.dataSet != osmPrimitive.dataSet || !(osmPrimitive instanceof Way) || ++n2 < n) continue;
            return true;
        }
        return false;
    }

    public abstract void accept(Visitor var1);

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        if (this.id != osmPrimitive.id && this.dataSet != null) {
            throw new DataIntegrityProblemException("Osm id cannot be changed after primitive was added to the dataset");
        }
        super.cloneFrom(osmPrimitive);
        this.clearCachedStyle();
    }

    public void mergeFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "other");
            if (osmPrimitive.isNew() ^ this.isNew()) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge because either of the participating primitives is new and the other is not", new Object[0]));
            }
            if (!osmPrimitive.isNew() && osmPrimitive.getId() != this.id) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge primitives with different ids. This id is {0}, the other is {1}", this.id, osmPrimitive.getId()));
            }
            this.setKeys(osmPrimitive.hasKeys() ? osmPrimitive.getKeys() : null);
            this.timestamp = osmPrimitive.timestamp;
            this.version = osmPrimitive.version;
            this.setIncomplete(osmPrimitive.isIncomplete());
            this.flags = osmPrimitive.flags;
            this.user = osmPrimitive.user;
            this.changesetId = osmPrimitive.changesetId;
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public boolean hasSameInterestingTags(OsmPrimitive osmPrimitive) {
        return this.keys == null && osmPrimitive.keys == null || this.getInterestingTags().equals(osmPrimitive.getInterestingTags());
    }

    public final boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        return this.hasEqualSemanticAttributes(osmPrimitive, true);
    }

    boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive, boolean bl) {
        if (!this.isNew() && this.id != osmPrimitive.id) {
            return false;
        }
        if (this.isIncomplete() ^ osmPrimitive.isIncomplete()) {
            return false;
        }
        return bl ? this.hasSameInterestingTags(osmPrimitive) : this.getKeys().equals(osmPrimitive.getKeys());
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        return this.isDeleted() == osmPrimitive.isDeleted() && this.isModified() == osmPrimitive.isModified() && this.timestamp == osmPrimitive.timestamp && this.version == osmPrimitive.version && this.isVisible() == osmPrimitive.isVisible() && Objects.equals(this.user, osmPrimitive.user) && this.changesetId == osmPrimitive.changesetId;
    }

    public void load(PrimitiveData primitiveData) {
        this.setKeys(primitiveData.hasKeys() ? primitiveData.getKeys() : null);
        this.setRawTimestamp(primitiveData.getRawTimestamp());
        this.user = primitiveData.getUser();
        this.setChangesetId(primitiveData.getChangesetId());
        this.setDeleted(primitiveData.isDeleted());
        this.setModified(primitiveData.isModified());
        this.setIncomplete(primitiveData.isIncomplete());
        this.version = primitiveData.getVersion();
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData primitiveData) {
        primitiveData.setId(this.id);
        primitiveData.setKeys(this.hasKeys() ? this.getKeys() : null);
        primitiveData.setRawTimestamp(this.getRawTimestamp());
        primitiveData.setUser(this.user);
        primitiveData.setDeleted(this.isDeleted());
        primitiveData.setModified(this.isModified());
        primitiveData.setVisible(this.isVisible());
        primitiveData.setIncomplete(this.isIncomplete());
        primitiveData.setChangesetId(this.changesetId);
        primitiveData.setVersion(this.version);
    }

    public abstract BBox getBBox();

    public abstract void updatePosition();

    @Override
    protected String getFlagsAsString() {
        StringBuilder stringBuilder = new StringBuilder(super.getFlagsAsString());
        if (this.isDisabled()) {
            if (this.isDisabledAndHidden()) {
                stringBuilder.append('h');
            } else {
                stringBuilder.append('d');
            }
        }
        if (this.isTagged()) {
            stringBuilder.append('T');
        }
        if (this.hasDirectionKeys()) {
            if (this.reversedDirection()) {
                stringBuilder.append('<');
            } else {
                stringBuilder.append('>');
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OsmPrimitive osmPrimitive = (OsmPrimitive)object;
        return this.id == osmPrimitive.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public abstract String getDisplayName(NameFormatter var1);

    @Override
    public Collection<String> getTemplateKeys() {
        Collection<String> collection = this.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size() + 2);
        arrayList.add(SPECIAL_VALUE_ID);
        arrayList.add(SPECIAL_VALUE_LOCAL_NAME);
        arrayList.addAll(collection);
        return arrayList;
    }

    @Override
    public Object getTemplateValue(String string, boolean bl) {
        if (bl) {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            if (SPECIAL_VALUE_ID.equals(string2)) {
                return this.getId();
            }
            if (SPECIAL_VALUE_LOCAL_NAME.equals(string2)) {
                return this.getLocalName();
            }
            return null;
        }
        return this.getIgnoreCase(string);
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match match) {
        return match.match(this);
    }

    public static Set<Relation> getParentRelations(Collection<? extends OsmPrimitive> collection) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : collection) {
            hashSet.addAll(OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Relation.class));
        }
        return hashSet;
    }

    public final boolean hasAreaTags() {
        return this.hasKey("landuse") || "yes".equals(this.get("area")) || "riverbank".equals(this.get("waterway")) || this.hasKey("natural") || this.hasKey("amenity") || this.hasKey("leisure") || this.hasKey("building") || this.hasKey("building:part");
    }

    public abstract boolean concernsArea();

    public abstract boolean isOutsideDownloadArea();

    public boolean isMultipolygon() {
        return false;
    }

    static {
        String string = "oneway=\"-1\"";
        String string2 = "oneway? | (aerialway=* -aerialway=station) | waterway=stream | waterway=river | waterway=ditch | waterway=drain | (\"piste:type\"=downhill & -area=yes) | (\"piste:type\"=sled & -area=yes) | (man_made=\"piste:halfpipe\" & -area=yes) | junction=roundabout | (highway=motorway & -oneway=no & -oneway=reversible) | (highway=motorway_link & -oneway=no & -oneway=reversible)";
        reversedDirectionKeys = OsmPrimitive.compileDirectionKeys("tags.reversed_direction", string);
        directionKeys = OsmPrimitive.compileDirectionKeys("tags.direction", string2);
    }
}

