/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;

public class ChangesetContentTableModel
extends AbstractTableModel {
    private final transient List<ChangesetContentEntry> data = new ArrayList<ChangesetContentEntry>();
    private final DefaultListSelectionModel selectionModel;

    public ChangesetContentTableModel(DefaultListSelectionModel defaultListSelectionModel) {
        this.selectionModel = defaultListSelectionModel;
    }

    public boolean hasSelectedPrimitives() {
        return this.selectionModel.getMinSelectionIndex() >= 0;
    }

    public void setSelectedByIdx(int n) {
        this.selectionModel.setSelectionInterval(n, n);
    }

    public DefaultListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Set<HistoryOsmPrimitive> getSelectedPrimitives() {
        HashSet<HistoryOsmPrimitive> hashSet = new HashSet<HistoryOsmPrimitive>();
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            hashSet.add(this.data.get(i).getPrimitive());
        }
        return hashSet;
    }

    public void populate(ChangesetDataSet changesetDataSet) {
        this.data.clear();
        if (changesetDataSet == null) {
            this.fireTableDataChanged();
            return;
        }
        Iterator<ChangesetDataSet.ChangesetDataSetEntry> iterator = changesetDataSet.iterator();
        while (iterator.hasNext()) {
            this.data.add(new ChangesetContentEntry(iterator.next()));
        }
        this.sort();
        this.fireTableDataChanged();
    }

    protected void sort() {
        this.data.sort((changesetContentEntry, changesetContentEntry2) -> {
            if (changesetContentEntry.getModificationType().equals((Object)changesetContentEntry2.getModificationType())) {
                long l;
                long l2 = changesetContentEntry.getPrimitive().getId();
                if (l2 == (l = changesetContentEntry2.getPrimitive().getId())) {
                    return 0;
                }
                if (l2 < l) {
                    return -1;
                }
                return 1;
            }
            switch (changesetContentEntry.getModificationType()) {
                case CREATED: {
                    return -1;
                }
                case UPDATED: {
                    switch (changesetContentEntry2.getModificationType()) {
                        case CREATED: {
                            return 1;
                        }
                    }
                    return -1;
                }
                case DELETED: {
                    return 1;
                }
            }
            return 0;
        });
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.data.get(n).getModificationType();
            }
        }
        return this.data.get(n).getPrimitive();
    }

    private static class ChangesetContentEntry
    implements ChangesetDataSet.ChangesetDataSetEntry {
        private final ChangesetDataSet.ChangesetModificationType modificationType;
        private final HistoryOsmPrimitive primitive;

        ChangesetContentEntry(ChangesetDataSet.ChangesetModificationType changesetModificationType, HistoryOsmPrimitive historyOsmPrimitive) {
            this.modificationType = changesetModificationType;
            this.primitive = historyOsmPrimitive;
        }

        ChangesetContentEntry(ChangesetDataSet.ChangesetDataSetEntry changesetDataSetEntry) {
            this(changesetDataSetEntry.getModificationType(), changesetDataSetEntry.getPrimitive());
        }

        @Override
        public ChangesetDataSet.ChangesetModificationType getModificationType() {
            return this.modificationType;
        }

        @Override
        public HistoryOsmPrimitive getPrimitive() {
            return this.primitive;
        }
    }
}

