/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class RequestHandler {
    public static final String globalConfirmationKey = "remotecontrol.always-confirm";
    public static final boolean globalConfirmationDefault = false;
    public static final String loadInNewLayerKey = "remotecontrol.new-layer";
    public static final boolean loadInNewLayerDefault = false;
    protected Map<String, String> args;
    protected String request;
    protected String content = "OK\r\n";
    protected String contentType = "text/plain";
    protected String myCommand;
    protected String sender;

    public final void handle() throws RequestHandlerForbiddenException, RequestHandlerBadRequestException, RequestHandlerErrorException {
        this.checkMandatoryParams();
        this.validateRequest();
        this.checkPermission();
        this.handleRequest();
    }

    protected abstract void validateRequest() throws RequestHandlerBadRequestException;

    protected abstract void handleRequest() throws RequestHandlerErrorException, RequestHandlerBadRequestException;

    public abstract String getPermissionMessage();

    public abstract PermissionPrefWithDefault getPermissionPref();

    public abstract String[] getMandatoryParams();

    public String[] getOptionalParams() {
        return null;
    }

    public String getUsage() {
        return null;
    }

    public String[] getUsageExamples() {
        return null;
    }

    public String[] getUsageExamples(String string) {
        return this.getUsageExamples();
    }

    public final void checkPermission() throws RequestHandlerForbiddenException {
        PermissionPrefWithDefault permissionPrefWithDefault = this.getPermissionPref();
        if (permissionPrefWithDefault != null && permissionPrefWithDefault.pref != null && !Main.pref.getBoolean(permissionPrefWithDefault.pref, permissionPrefWithDefault.defaultVal)) {
            String string = MessageFormat.format("RemoteControl: ''{0}'' forbidden by preferences", this.myCommand);
            Main.info(string);
            throw new RequestHandlerForbiddenException(string);
        }
        if (Main.pref.getBoolean(globalConfirmationKey, false)) {
            Integer n = (int)Math.max(200.0, (double)Main.parent.getWidth() * 0.6);
            String string = "<html><div>" + this.getPermissionMessage() + "<br/>" + I18n.tr("Do you want to allow this?", new Object[0]) + "</div></html>";
            JLabel jLabel = new JLabel(string);
            if (jLabel.getPreferredSize().width > n) {
                jLabel.setText(string.replaceFirst("<div>", "<div style=\"width:" + n + "px;\">"));
            }
            if (JOptionPane.showConfirmDialog(Main.parent, jLabel, I18n.tr("Confirm Remote Control action", new Object[0]), 0) != 0) {
                String string2 = MessageFormat.format("RemoteControl: ''{0}'' forbidden by user''s choice", this.myCommand);
                throw new RequestHandlerForbiddenException(string2);
            }
        }
    }

    public void setUrl(String string) throws RequestHandlerBadRequestException {
        this.request = string;
        try {
            this.parseArgs();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RequestHandlerBadRequestException(uRISyntaxException);
        }
    }

    protected void parseArgs() throws URISyntaxException {
        this.args = RequestHandler.getRequestParameter(new URI(this.request));
    }

    static Map<String, String> getRequestParameter(URI uRI) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (uRI.getRawQuery() == null) {
            return hashMap;
        }
        for (String string : uRI.getRawQuery().split("&")) {
            String[] stringArray = Utils.decodeUrl(string).split("=", 2);
            hashMap.put(stringArray[0], stringArray.length > 1 ? stringArray[1] : null);
        }
        return hashMap;
    }

    void checkMandatoryParams() throws RequestHandlerBadRequestException {
        String[] stringArray = this.getMandatoryParams();
        String[] stringArray2 = this.getOptionalParams();
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        if (stringArray != null && this.args != null) {
            for (String string : stringArray) {
                String string2 = this.args.get(string);
                if (string2 != null && !string2.isEmpty()) continue;
                bl = true;
                Main.warn('\'' + this.myCommand + "' remote control request must have '" + string + "' parameter");
                linkedList.add(string);
            }
        }
        String[] stringArray3 = new HashSet();
        if (stringArray != null) {
            Collections.addAll(stringArray3, stringArray);
        }
        if (stringArray2 != null) {
            Collections.addAll(stringArray3, stringArray2);
        }
        if (this.args != null) {
            for (String string : this.args.keySet()) {
                if (stringArray3.contains(string)) continue;
                Main.warn("Unknown remote control parameter {0}, skipping it", string);
            }
        }
        if (bl) {
            throw new RequestHandlerBadRequestException(I18n.tr("The following keys are mandatory, but have not been provided: {0}", Utils.join(", ", linkedList)));
        }
    }

    public void setCommand(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        this.myCommand = string;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected boolean isLoadInNewLayer() {
        return this.args.get("new_layer") != null && !this.args.get("new_layer").isEmpty() ? Boolean.parseBoolean(this.args.get("new_layer")) : Main.pref.getBoolean(loadInNewLayerKey, false);
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public static abstract class RawURLParseRequestHandler
    extends RequestHandler {
        @Override
        protected void parseArgs() throws URISyntaxException {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.request.indexOf(63) != -1) {
                String string = this.request.substring(this.request.indexOf(63) + 1);
                if (string.indexOf("url=") == 0) {
                    hashMap.put("url", Utils.decodeUrl(string.substring(4)));
                } else {
                    String[] stringArray;
                    int n = string.indexOf("&url=");
                    if (n != -1) {
                        hashMap.put("url", Utils.decodeUrl(string.substring(n + 5)));
                        string = string.substring(0, n);
                    } else if (string.indexOf(35) != -1) {
                        string = string.substring(0, string.indexOf(35));
                    }
                    for (String string2 : stringArray = string.split("&", -1)) {
                        int n2 = string2.indexOf(61);
                        if (n2 == -1) continue;
                        hashMap.put(string2.substring(0, n2), Utils.decodeUrl(string2.substring(n2 + 1)));
                    }
                }
            }
            this.args = hashMap;
        }
    }

    public static class RequestHandlerForbiddenException
    extends RequestHandlerException {
        public RequestHandlerForbiddenException(String string) {
            super(string);
        }
    }

    public static class RequestHandlerBadRequestException
    extends RequestHandlerException {
        public RequestHandlerBadRequestException(String string) {
            super(string);
        }

        public RequestHandlerBadRequestException(Throwable throwable) {
            super(throwable);
        }

        public RequestHandlerBadRequestException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class RequestHandlerErrorException
    extends RequestHandlerException {
        public RequestHandlerErrorException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class RequestHandlerException
    extends Exception {
        public RequestHandlerException(String string) {
            super(string);
        }

        public RequestHandlerException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public RequestHandlerException(Throwable throwable) {
            super(throwable);
        }
    }
}

