/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002\u001a\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001e\u001a/\u0010!\u001a\u00020\"\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\n\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0%H\u0086\b\u001aE\u0010!\u001a\u00020\"\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"0%2\u0014\b\n\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0%H\u0086\b\u001a\u0012\u0010'\u001a\u00020\"*\u00020\u00022\u0006\u0010(\u001a\u00020\u0002\u001a5\u0010)\u001a\b\u0012\u0004\u0012\u0002H#0*\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\n\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0%H\u0086\b\u001aK\u0010)\u001a\b\u0012\u0004\u0012\u0002H#0*\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"0%2\u0014\b\n\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0%H\u0086\b\u001a\u0015\u0010+\u001a\u00020\"*\u00020,2\u0006\u0010(\u001a\u00020\u0002H\u0086\u0002\u001a\u0012\u0010-\u001a\u00020\"*\u00020\u00162\u0006\u0010.\u001a\u00020\u0006\u001a\u001f\u0010/\u001a\b\u0012\u0004\u0012\u0002H100\"\b\b\u0000\u00101*\u00020\u0002*\u0002H1\u00a2\u0006\u0002\u00102\u001a\u0018\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020**\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016\u001a6\u00104\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\n\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0%H\u0086\b\u00a2\u0006\u0002\u00105\u001aL\u00104\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"0%2\u0014\b\n\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0%H\u0086\b\u00a2\u0006\u0002\u00106\u001a/\u00107\u001a\u000208\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\b\u00109\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002080%H\u0086\b\u001aE\u00107\u001a\u000208\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0014\b\u0004\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"0%2\u0014\b\b\u00109\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002080%H\u0086\b\u001a \u0010:\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010;\u001a$\u0010<\u001a\b\u0012\u0004\u0012\u0002H#0=\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010>\u001a\n\u0010?\u001a\u00020@*\u00020\u0002\u001a>\u0010A\u001a\u0004\u0018\u0001H#\"\b\b\u0000\u0010#*\u00020\u0002*\u0002H#2\u0006\u0010(\u001a\u00020\u00022\u0019\u0010B\u001a\u0015\u0012\u0004\u0012\u0002H#\u0012\u0006\u0012\u0004\u0018\u00010\u00020%\u00a2\u0006\u0002\bC\u00a2\u0006\u0002\u0010D\u001aD\u0010E\u001a\u0004\u0018\u0001H#\"\b\b\u0000\u0010#*\u00020\u0002*\u0002H#2\u0006\u0010(\u001a\u00020\u00022\u001f\u0010F\u001a\u001b\u0012\u0004\u0012\u0002H#\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020G0%\u00a2\u0006\u0002\bC\u00a2\u0006\u0002\u0010D\u001a \u0010H\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010;\u001a\u0016\u0010I\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010J\u001a\u00020\"\u001a \u0010K\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010;\u001a)\u0010K\u001a\u0004\u0018\u0001H#\"\b\b\u0000\u0010#*\u00020\u0002*\u00020\u00022\f\u0010L\u001a\b\u0012\u0004\u0012\u0002H#0M\u00a2\u0006\u0002\u0010N\u001a\u0017\u0010O\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010P\u001a\u00020\u0002H\u0086\u0010\u001a(\u0010Q\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\u0006\u0010R\u001a\u00020\"H\u0086\b\u00a2\u0006\u0002\u0010S\u001aG\u0010T\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\b\b\u0002\u0010R\u001a\u00020\"2\u001b\b\b\u0010B\u001a\u0015\u0012\u0004\u0012\u0002H#\u0012\u0006\u0012\u0004\u0018\u00010\u00020%\u00a2\u0006\u0002\bCH\u0086\b\u00a2\u0006\u0002\u0010U\u001aM\u0010V\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u00022\b\b\u0002\u0010R\u001a\u00020\"2!\b\b\u0010F\u001a\u001b\u0012\u0004\u0012\u0002H#\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020G0%\u00a2\u0006\u0002\bCH\u0086\b\u00a2\u0006\u0002\u0010U\u001aY\u0010W\u001a\u0004\u0018\u0001H#\"\b\b\u0000\u0010#*\u00020\u0002*\u00020\u00022\b\b\u0002\u0010R\u001a\u00020\"2\u001e\u0010X\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H#0M0=\"\b\u0012\u0004\u0012\u0002H#0M2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0%\u00a2\u0006\u0002\u0010Y\u001a\u0016\u0010Z\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010J\u001a\u00020\"\u001a\u0012\u0010[\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\\\u001a\u00020\u0002\u001a \u0010]\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010;\u001a\n\u0010^\u001a\u00020@*\u00020\u0001\u001a\n\u0010_\u001a\u00020@*\u00020\u0002\u001a\u001e\u0010`\u001a\u00020\"*\u0004\u0018\u00010\u00022\u0006\u0010(\u001a\u00020\u00022\b\b\u0002\u0010R\u001a\u00020\"\u001a\u0018\u0010a\u001a\u00020\"*\u00020\u00022\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00020G\u001a \u0010c\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"0%\u001a\u0016\u0010c\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010e\u001a\u00020\"\u001a%\u0010f\u001a\t\u0018\u0001H#\u00a2\u0006\u0002\bg\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u0002H#H\u0086\b\u00a2\u0006\u0002\u0010;\u001a \u0010h\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\"0%\u001a\u0016\u0010h\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010e\u001a\u00020\"\u001a%\u0010i\u001a\t\u0018\u0001H#\u00a2\u0006\u0002\bg\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u0002*\u0002H#H\u0086\b\u00a2\u0006\u0002\u0010;\u001a$\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00022\b\b\u0002\u0010k\u001a\u00020\"2\b\b\u0002\u0010J\u001a\u00020\"\u001a\n\u0010l\u001a\u00020\u0001*\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\"\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\"\u0015\u0010\u0013\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006m"}, d2={"allChildren", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "Lcom/intellij/psi/PsiElement;", "getAllChildren", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "endOffset", "", "getEndOffset", "(Lcom/intellij/psi/PsiElement;)I", "nextLeafs", "Lkotlin/sequences/Sequence;", "getNextLeafs", "(Lcom/intellij/psi/PsiElement;)Lkotlin/sequences/Sequence;", "parents", "getParents", "parentsWithSelf", "getParentsWithSelf", "prevLeafs", "getPrevLeafs", "startOffset", "getStartOffset", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "(Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;)Lcom/intellij/openapi/util/TextRange;", "findFirstLeafWhollyInRange", "file", "Lcom/intellij/psi/PsiFile;", "range", "replaceFileAnnotationList", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "Lorg/jetbrains/kotlin/psi/KtFile;", "annotationList", "anyDescendantOfType", "", "T", "predicate", "Lkotlin/Function1;", "canGoInside", "before", "element", "collectDescendantsOfType", "", "contains", "Lcom/intellij/psi/search/SearchScope;", "containsInside", "offset", "createSmartPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "E", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/SmartPsiElementPointer;", "elementsInRange", "findDescendantOfType", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "forEachDescendantOfType", "", "action", "getChildOfType", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "getChildrenOfType", "", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiElement;", "getElementTextWithContext", "", "getIfChildIsInBranch", "branch", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "getIfChildIsInBranches", "branches", "", "getLastParentOfTypeInRow", "getNextSiblingIgnoringWhitespaceAndComments", "withItself", "getNonStrictParentOfType", "parentClass", "Ljava/lang/Class;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "getOutermostParentContainedIn", "container", "getParentOfType", "strict", "(Lcom/intellij/psi/PsiElement;Z)Lcom/intellij/psi/PsiElement;", "getParentOfTypeAndBranch", "(Lcom/intellij/psi/PsiElement;ZLkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "getParentOfTypeAndBranches", "getParentOfTypesAndPredicate", "parentClasses", "(Lcom/intellij/psi/PsiElement;Z[Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "getPrevSiblingIgnoringWhitespaceAndComments", "getStartOffsetIn", "ancestor", "getStrictParentOfType", "getText", "getTextWithLocation", "isAncestor", "isInsideOf", "elements", "nextLeaf", "filter", "skipEmptyElements", "nextSiblingOfSameType", "Lorg/jetbrains/annotations/Nullable;", "prevLeaf", "prevSiblingOfSameType", "siblings", "forward", "trimWhiteSpaces", "kotlin-compiler"})
public final class PsiUtilsKt {
    @NotNull
    public static final PsiChildRange getAllChildren(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        PsiElement first = $receiver.getFirstChild();
        return first != null ? new PsiChildRange(first, $receiver.getLastChild()) : PsiChildRange.Companion.getEMPTY();
    }

    @NotNull
    public static final Sequence<PsiElement> siblings(@NotNull PsiElement $receiver, boolean forward, boolean withItself) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new Sequence<PsiElement>($receiver, forward, withItself){
            final /* synthetic */ PsiElement receiver$0;
            final /* synthetic */ boolean $forward;
            final /* synthetic */ boolean $withItself;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Iterator<PsiElement> iterator() {
                void next;
                Ref.ObjectRef<T> objectRef = new Ref.ObjectRef<T>();
                objectRef.element = this.receiver$0;
                return new Iterator<PsiElement>(this, (Ref.ObjectRef)next){
                    final /* synthetic */ siblings.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $next;

                    public boolean hasNext() {
                        return (PsiElement)this.$next.element != null;
                    }

                    @NotNull
                    public PsiElement next() {
                        PsiElement psiElement = (PsiElement)this.$next.element;
                        if (psiElement == null) {
                            throw (Throwable)new NoSuchElementException();
                        }
                        PsiElement result2 = psiElement;
                        this.$next.element = this.this$0.$forward ? result2.getNextSibling() : result2.getPrevSibling();
                        return result2;
                    }
                    {
                        this.this$0 = $outer;
                        this.$next = $captured_local_variable$1;
                        if (!this.this$0.$withItself) {
                            this.next();
                        }
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            {
                this.receiver$0 = $receiver;
                this.$forward = $captured_local_variable$1;
                this.$withItself = $captured_local_variable$2;
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Sequence siblings$default(PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: siblings");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return PsiUtilsKt.siblings(psiElement, bl, bl2);
    }

    @NotNull
    public static final Sequence<PsiElement> getParentsWithSelf(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.generateSequence($receiver, (Function1)parentsWithSelf.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<PsiElement> getParents(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.drop(PsiUtilsKt.getParentsWithSelf($receiver), 1);
    }

    @Nullable
    public static final PsiElement prevLeaf(@NotNull PsiElement $receiver, boolean skipEmptyElements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return PsiTreeUtil.prevLeaf($receiver, skipEmptyElements);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement prevLeaf$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prevLeaf");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.prevLeaf(psiElement, bl);
    }

    @Nullable
    public static final PsiElement nextLeaf(@NotNull PsiElement $receiver, boolean skipEmptyElements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return PsiTreeUtil.nextLeaf($receiver, skipEmptyElements);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement nextLeaf$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextLeaf");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.nextLeaf(psiElement, bl);
    }

    @NotNull
    public static final Sequence<PsiElement> getPrevLeafs(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.generateSequence((Function0)new Function0<PsiElement>($receiver){
            final /* synthetic */ PsiElement receiver$0;

            @Nullable
            public final PsiElement invoke() {
                return PsiUtilsKt.prevLeaf$default(this.receiver$0, false, 1, null);
            }
            {
                this.receiver$0 = psiElement;
                super(0);
            }
        }, (Function1)prevLeafs.2.INSTANCE);
    }

    @NotNull
    public static final Sequence<PsiElement> getNextLeafs(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.generateSequence((Function0)new Function0<PsiElement>($receiver){
            final /* synthetic */ PsiElement receiver$0;

            @Nullable
            public final PsiElement invoke() {
                return PsiUtilsKt.nextLeaf$default(this.receiver$0, false, 1, null);
            }
            {
                this.receiver$0 = psiElement;
                super(0);
            }
        }, (Function1)nextLeafs.2.INSTANCE);
    }

    @Nullable
    public static final PsiElement prevLeaf(@NotNull PsiElement $receiver, @NotNull Function1<? super PsiElement, Boolean> filter2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(filter2, "filter");
        PsiElement leaf = PsiUtilsKt.prevLeaf$default($receiver, false, 1, null);
        while (leaf != null && !filter2.invoke(leaf).booleanValue()) {
            leaf = PsiUtilsKt.prevLeaf$default(leaf, false, 1, null);
        }
        return leaf;
    }

    @Nullable
    public static final PsiElement nextLeaf(@NotNull PsiElement $receiver, @NotNull Function1<? super PsiElement, Boolean> filter2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(filter2, "filter");
        PsiElement leaf = PsiUtilsKt.nextLeaf$default($receiver, false, 1, null);
        while (leaf != null && !filter2.invoke(leaf).booleanValue()) {
            leaf = PsiUtilsKt.nextLeaf$default(leaf, false, 1, null);
        }
        return leaf;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T extends PsiElement> T getParentOfTypesAndPredicate(@NotNull PsiElement $receiver, boolean strict, @NotNull Class<T>[] parentClasses, @NotNull Function1<? super T, Boolean> predicate) {
        void element;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(parentClasses, "parentClasses");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        PsiElement psiElement = objectRef.element = strict ? $receiver.getParent() : $receiver;
        while ((PsiElement)element.element != null) {
            block10: {
                block9: {
                    boolean bl;
                    block8: {
                        void $receiver$iv;
                        Object[] objectArray = parentClasses;
                        if (objectArray.length == 0) break block9;
                        objectArray = parentClasses;
                        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                            void element$iv = $receiver$iv[i];
                            Class parentClass = (Class)element$iv;
                            if (!parentClass.isInstance((PsiElement)element.element)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                    if (!bl) break block10;
                }
                PsiElement psiElement2 = (PsiElement)element.element;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                if (predicate.invoke(psiElement2).booleanValue()) {
                    return (T)((PsiElement)element.element);
                }
            }
            if ((PsiElement)element.element instanceof PsiFile) {
                return (T)((PsiElement)null);
            }
            element.element = ((PsiElement)element.element).getParent();
        }
        return (T)((PsiElement)null);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement getParentOfTypesAndPredicate$default(PsiElement psiElement, boolean bl, Class[] classArray, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getParentOfTypesAndPredicate");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.getParentOfTypesAndPredicate(psiElement, bl, classArray, function1);
    }

    @Nullable
    public static final <T extends PsiElement> T getNonStrictParentOfType(@NotNull PsiElement $receiver, @NotNull Class<T> parentClass) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(parentClass, "parentClass");
        return PsiTreeUtil.getParentOfType($receiver, parentClass, false);
    }

    @Nullable
    public static final PsiElement getNextSiblingIgnoringWhitespaceAndComments(@NotNull PsiElement $receiver, boolean withItself) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return (PsiElement)SequencesKt.firstOrNull(SequencesKt.filter(PsiUtilsKt.siblings$default($receiver, false, withItself, 1, null), getNextSiblingIgnoringWhitespaceAndComments.1.INSTANCE));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement getNextSiblingIgnoringWhitespaceAndComments$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNextSiblingIgnoringWhitespaceAndComments");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments(psiElement, bl);
    }

    @Nullable
    public static final PsiElement getPrevSiblingIgnoringWhitespaceAndComments(@NotNull PsiElement $receiver, boolean withItself) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        boolean bl = false;
        boolean bl2 = withItself;
        return SequencesKt.firstOrNull(SequencesKt.filter(PsiUtilsKt.siblings($receiver, bl, bl2), getPrevSiblingIgnoringWhitespaceAndComments.1.INSTANCE));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PsiElement getPrevSiblingIgnoringWhitespaceAndComments$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPrevSiblingIgnoringWhitespaceAndComments");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments(psiElement, bl);
    }

    public static final boolean isAncestor(@Nullable PsiElement $receiver, @NotNull PsiElement element, boolean strict) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return PsiTreeUtil.isAncestor($receiver, element, strict);
    }

    public static /* bridge */ /* synthetic */ boolean isAncestor$default(PsiElement psiElement, PsiElement psiElement2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isAncestor");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return PsiUtilsKt.isAncestor(psiElement, psiElement2, bl);
    }

    @Nullable
    public static final <T extends PsiElement> T getIfChildIsInBranch(@NotNull T $receiver, @NotNull PsiElement element, @NotNull Function1<? super T, ? extends PsiElement> branch) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        return (T)(PsiUtilsKt.isAncestor$default(branch.invoke($receiver), element, false, 2, null) ? $receiver : (PsiElement)null);
    }

    @Nullable
    public static final <T extends PsiElement> T getIfChildIsInBranches(@NotNull T $receiver, @NotNull PsiElement element, @NotNull Function1<? super T, ? extends Iterable<? extends PsiElement>> branches) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(element, "element");
            Intrinsics.checkParameterIsNotNull(branches, "branches");
            Iterable<PsiElement> $receiver$iv = branches.invoke($receiver);
            for (PsiElement psiElement : $receiver$iv) {
                PsiElement it = psiElement;
                if (!PsiUtilsKt.isAncestor$default(it, element, false, 2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return (T)(bl ? $receiver : (PsiElement)null);
    }

    @Nullable
    public static final PsiElement getOutermostParentContainedIn(@NotNull PsiElement $receiver, @NotNull PsiElement container) {
        PsiElement psiElement;
        block2: {
            while (true) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Intrinsics.checkParameterIsNotNull(container, "container");
                PsiElement parent2 = $receiver.getParent();
                if (Intrinsics.areEqual(parent2, container)) {
                    psiElement = $receiver;
                    break block2;
                }
                if (parent2 == null) break;
            }
            psiElement = null;
        }
        return psiElement;
    }

    public static final boolean isInsideOf(@NotNull PsiElement $receiver, @NotNull Iterable<? extends PsiElement> elements) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(elements, "elements");
            Iterable<? extends PsiElement> $receiver$iv = elements;
            for (PsiElement psiElement : $receiver$iv) {
                PsiElement it = psiElement;
                if (!PsiUtilsKt.isAncestor$default(it, $receiver, false, 2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final PsiChildRange trimWhiteSpaces(@NotNull PsiChildRange $receiver) {
        Object v4;
        PsiElement psiElement;
        PsiChildRange psiChildRange;
        PsiChildRange psiChildRange2;
        block5: {
            PsiElement psiElement2;
            PsiElement it;
            Object element$iv;
            Iterator iterator2;
            Sequence $receiver$iv;
            block4: {
                PsiChildRange psiChildRange3;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if ($receiver.getFirst() == null) {
                    return $receiver;
                }
                Sequence sequence2 = PsiUtilsKt.siblings$default($receiver.getFirst(), false, false, 3, null);
                psiChildRange2 = psiChildRange3;
                psiChildRange = psiChildRange3;
                iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (PsiElement)element$iv;
                    if (!(!(it instanceof PsiWhiteSpace))) continue;
                    psiElement2 = (PsiElement)element$iv;
                    break block4;
                }
                psiElement2 = null;
            }
            psiElement = psiElement2;
            PsiElement psiElement3 = psiElement;
            PsiElement psiElement4 = $receiver.getLast();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = PsiUtilsKt.siblings$default(psiElement4, false, false, 2, null);
            psiElement = psiElement3;
            iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (PsiElement)element$iv;
                if (!(!(it instanceof PsiWhiteSpace))) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        Object var10_8 = v4;
        psiChildRange2(psiElement, var10_8);
        return psiChildRange;
    }

    public static final int getStartOffset(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getTextRange().getStartOffset();
    }

    public static final int getEndOffset(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getTextRange().getEndOffset();
    }

    public static final int getStartOffsetIn(@NotNull PsiElement $receiver, @NotNull PsiElement ancestor) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(ancestor, "ancestor");
        int offset2 = 0;
        PsiElement parent2 = $receiver;
        while (Intrinsics.areEqual(parent2, ancestor) ^ true) {
            offset2 += parent2.getStartOffsetInParent();
            Intrinsics.checkExpressionValueIsNotNull(parent2.getParent(), "parent.parent");
        }
        return offset2;
    }

    public static final boolean containsInside(@NotNull TextRange $receiver, int offset2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getStartOffset() < offset2 && offset2 < $receiver.getEndOffset();
    }

    @Nullable
    public static final TextRange getTextRange(@NotNull PsiChildRange $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isEmpty()) {
            return null;
        }
        PsiElement psiElement = $receiver.getFirst();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        int n = PsiUtilsKt.getStartOffset(psiElement);
        PsiElement psiElement2 = $receiver.getLast();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return new TextRange(n, PsiUtilsKt.getEndOffset(psiElement2));
    }

    @NotNull
    public static final String getText(@NotNull PsiChildRange $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isEmpty()) {
            return "";
        }
        return SequencesKt.joinToString$default(SequencesKt.map($receiver, getText.1.INSTANCE), "", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiElement> elementsInRange(@NotNull PsiFile $receiver, @NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(range, "range");
        int offset2 = range.getStartOffset();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        while (offset2 < range.getEndOffset()) {
            Object element$iv2;
            block3: {
                void $receiver$iv;
                PsiElement leaf;
                TextRange currentRange = new TextRange(offset2, range.getEndOffset());
                if (PsiUtilsKt.findFirstLeafWhollyInRange($receiver, currentRange) == null) {
                    break;
                }
                Sequence<PsiElement> sequence2 = PsiUtilsKt.getParentsWithSelf(leaf);
                for (Object element$iv2 : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv2;
                    PsiElement parent2 = it.getParent();
                    if (!(it instanceof PsiFile || currentRange.contains(parent2.getTextRange()) ^ true)) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            PsiElement element = (PsiElement)element$iv2;
            result2.add(element);
            offset2 = PsiUtilsKt.getEndOffset(element);
        }
        return result2;
    }

    private static final PsiElement findFirstLeafWhollyInRange(PsiFile file, TextRange range) {
        PsiElement psiElement = file.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        TextRange elementRange = element.getTextRange();
        if (elementRange.getStartOffset() < range.getStartOffset()) {
            PsiElement psiElement2 = PsiUtilsKt.nextLeaf(element, true);
            if (psiElement2 == null) {
                return null;
            }
            element = psiElement2;
            elementRange = element.getTextRange();
        }
        boolean bl = elementRange.getStartOffset() >= range.getStartOffset();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return elementRange.getEndOffset() <= range.getEndOffset() ? element : (PsiElement)null;
    }

    @NotNull
    public static final String getElementTextWithContext(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        boolean bl = $receiver.isValid();
        if (_Assertions.ENABLED && !bl) {
            String string = "Invalid element " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if ($receiver instanceof PsiFile) {
            String string = ((PsiFile)$receiver).getContainingFile().getText();
            Intrinsics.checkExpressionValueIsNotNull(string, "containingFile.text");
            return string;
        }
        PsiElement psiElement = PsiTreeUtil.findFirstParent($receiver, getElementTextWithContext.topLevelElement.1.INSTANCE);
        if (psiElement == null) {
            throw (Throwable)((Object)new AssertionError((Object)"For non-file element we should always be able to find parent in file children"));
        }
        PsiElement topLevelElement2 = psiElement;
        int startContextOffset = PsiUtilsKt.getStartOffset(topLevelElement2);
        int elementContextOffset = $receiver.getTextRange().getStartOffset();
        int inFileParentOffset = elementContextOffset - startContextOffset;
        String string = new StringBuilder(topLevelElement2.getText()).insert(inFileParentOffset, "<caret>").insert(0, "File name: " + $receiver.getContainingFile().getName() + " Physical: " + $receiver.getContainingFile().isPhysical() + "\n").toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder(topLevelEl\u2026)\n            .toString()");
        return string;
    }

    @NotNull
    public static final String getTextWithLocation(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return "'" + $receiver.getText() + "' at " + DiagnosticUtils.atLocation($receiver);
    }

    @NotNull
    public static final KtFileAnnotationList replaceFileAnnotationList(@NotNull KtFile file, @NotNull KtFileAnnotationList annotationList) {
        PsiElement beforeAnchor;
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(annotationList, "annotationList");
        if (file.getFileAnnotationList() != null) {
            KtFileAnnotationList ktFileAnnotationList = file.getFileAnnotationList();
            if (ktFileAnnotationList == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement2 = ktFileAnnotationList.replace(annotationList);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
            }
            return (KtFileAnnotationList)psiElement2;
        }
        KtPackageDirective ktPackageDirective = file.getPackageDirective();
        if ((ktPackageDirective != null ? ktPackageDirective.getPackageKeyword() : null) != null) {
            KtPackageDirective ktPackageDirective2 = file.getPackageDirective();
            if (ktPackageDirective2 == null) {
                Intrinsics.throwNpe();
            }
            psiElement = ktPackageDirective2;
        } else if (file.getImportList() != null) {
            KtImportList ktImportList = file.getImportList();
            if (ktImportList == null) {
                Intrinsics.throwNpe();
            }
            psiElement = ktImportList;
        } else {
            psiElement = beforeAnchor = CollectionsKt.firstOrNull(file.getDeclarations()) != null ? (PsiElement)CollectionsKt.first(file.getDeclarations()) : (PsiElement)null;
        }
        if (beforeAnchor != null) {
            PsiElement psiElement3 = file.addBefore(annotationList, beforeAnchor);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
            }
            return (KtFileAnnotationList)psiElement3;
        }
        if (file.getLastChild() == null) {
            PsiElement psiElement4 = file.add(annotationList);
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
            }
            return (KtFileAnnotationList)psiElement4;
        }
        PsiElement psiElement5 = file.addAfter(annotationList, file.getLastChild());
        if (psiElement5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
        }
        return (KtFileAnnotationList)psiElement5;
    }

    public static final boolean contains(@NotNull SearchScope $receiver, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(element, "element");
        return PsiSearchScopeUtil.isInScope($receiver, element);
    }

    @NotNull
    public static final <E extends PsiElement> SmartPsiElementPointer<E> createSmartPointer(@NotNull E $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        SmartPsiElementPointer<E> smartPsiElementPointer = SmartPointerManager.getInstance($receiver.getProject()).createSmartPsiElementPointer($receiver);
        Intrinsics.checkExpressionValueIsNotNull(smartPsiElementPointer, "SmartPointerManager.getI\u2026rtPsiElementPointer(this)");
        return smartPsiElementPointer;
    }

    public static final boolean before(@NotNull PsiElement $receiver, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(element, "element");
        return $receiver.getTextRange().getEndOffset() <= element.getTextRange().getStartOffset();
    }
}

