-- EFL LuaJIT bindings: efl_event_pointer.eo (class Efl.Event.Pointer)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.efl_event_pointer_class_get()
    eo.class_register("Efl_Event_Pointer", {"Eo_Base"}, {"Efl_Event", "Efl_Input_State", "Efl_Event_Input"}, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *efl_event_pointer_class_get(void);
    void efl_event_pointer_action_set(Efl_Pointer_Action act);
    Efl_Pointer_Action efl_event_pointer_action_get(void);
    void efl_event_pointer_button_set(int but);
    int efl_event_pointer_button_get(void);
    void efl_event_pointer_button_pressed_set(int button, Eina_Bool pressed);
    Eina_Bool efl_event_pointer_button_pressed_get(int button);
    void efl_event_pointer_position_set(int x, int y);
    void efl_event_pointer_position_get(int *x, int *y);
    void efl_event_pointer_position_precise_set(double x, double y);
    void efl_event_pointer_position_precise_get(double *x, double *y);
    void efl_event_pointer_previous_position_set(int x, int y);
    void efl_event_pointer_previous_position_get(int *x, int *y);
    void efl_event_pointer_previous_position_precise_set(double x, double y);
    void efl_event_pointer_previous_position_precise_get(double *x, double *y);
    void efl_event_pointer_finger_set(int id);
    int efl_event_pointer_finger_get(void);
    void efl_event_pointer_touch_set(double radius, double rad_x, double rad_y, double pressure, double angle);
    void efl_event_pointer_touch_get(double *radius, double *rad_x, double *rad_y, double *pressure, double *angle);
    void efl_event_pointer_source_set(Eo_Base * src);
    Eo_Base *efl_event_pointer_source_get(void);
    void efl_event_pointer_button_flags_set(Efl_Pointer_Flags flags);
    Efl_Pointer_Flags efl_event_pointer_button_flags_get(void);
    void efl_event_pointer_double_click_set(Eina_Bool val);
    Eina_Bool efl_event_pointer_double_click_get(void);
    void efl_event_pointer_triple_click_set(Eina_Bool val);
    Eina_Bool efl_event_pointer_triple_click_get(void);
    void efl_event_pointer_wheel_direction_set(Efl_Orient dir);
    Efl_Orient efl_event_pointer_wheel_direction_get(void);
    void efl_event_pointer_wheel_distance_set(int dist);
    int efl_event_pointer_wheel_distance_get(void);
]]

local __M = util.get_namespace(M, { "event" })
__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    action_set = function(self, act)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_action_set(act)
        eo.__do_end()
    end,

    action_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_action_get()
        eo.__do_end()
        return v
    end,

    button_set = function(self, but)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_button_set(but)
        eo.__do_end()
    end,

    button_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_button_get()
        eo.__do_end()
        return tonumber(v)
    end,

    button_pressed_set = function(self, button, pressed)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_button_pressed_set(button, pressed)
        eo.__do_end()
    end,

    button_pressed_get = function(self, button)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_button_pressed_get(button)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    position_set = function(self, x, y)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_position_set(x, y)
        eo.__do_end()
    end,

    position_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("int[1]")
        local y = ffi.new("int[1]")
        __lib.efl_event_pointer_position_get(x, y)
        eo.__do_end()
        return tonumber(x[0]), tonumber(y[0])
    end,

    position_precise_set = function(self, x, y)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_position_precise_set(x, y)
        eo.__do_end()
    end,

    position_precise_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("double[1]")
        local y = ffi.new("double[1]")
        __lib.efl_event_pointer_position_precise_get(x, y)
        eo.__do_end()
        return tonumber(x[0]), tonumber(y[0])
    end,

    previous_position_set = function(self, x, y)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_previous_position_set(x, y)
        eo.__do_end()
    end,

    previous_position_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("int[1]")
        local y = ffi.new("int[1]")
        __lib.efl_event_pointer_previous_position_get(x, y)
        eo.__do_end()
        return tonumber(x[0]), tonumber(y[0])
    end,

    previous_position_precise_set = function(self, x, y)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_previous_position_precise_set(x, y)
        eo.__do_end()
    end,

    previous_position_precise_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("double[1]")
        local y = ffi.new("double[1]")
        __lib.efl_event_pointer_previous_position_precise_get(x, y)
        eo.__do_end()
        return tonumber(x[0]), tonumber(y[0])
    end,

    finger_set = function(self, id)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_finger_set(id)
        eo.__do_end()
    end,

    finger_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_finger_get()
        eo.__do_end()
        return tonumber(v)
    end,

    touch_set = function(self, radius, rad_x, rad_y, pressure, angle)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_touch_set(radius, rad_x, rad_y, pressure, angle)
        eo.__do_end()
    end,

    touch_get = function(self)
        eo.__do_start(self, __class)
        local radius = ffi.new("double[1]")
        local rad_x = ffi.new("double[1]")
        local rad_y = ffi.new("double[1]")
        local pressure = ffi.new("double[1]")
        local angle = ffi.new("double[1]")
        __lib.efl_event_pointer_touch_get(radius, rad_x, rad_y, pressure, angle)
        eo.__do_end()
        return tonumber(radius[0]), tonumber(rad_x[0]), tonumber(rad_y[0]), tonumber(pressure[0]), tonumber(angle[0])
    end,

    source_set = function(self, src)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_source_set(src)
        eo.__do_end()
    end,

    source_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_source_get()
        eo.__do_end()
        return v
    end,

    button_flags_set = function(self, flags)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_button_flags_set(flags)
        eo.__do_end()
    end,

    button_flags_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_button_flags_get()
        eo.__do_end()
        return v
    end,

    double_click_set = function(self, val)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_double_click_set(val)
        eo.__do_end()
    end,

    double_click_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_double_click_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    triple_click_set = function(self, val)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_triple_click_set(val)
        eo.__do_end()
    end,

    triple_click_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_triple_click_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    wheel_direction_set = function(self, dir)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_wheel_direction_set(dir)
        eo.__do_end()
    end,

    wheel_direction_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_wheel_direction_get()
        eo.__do_end()
        return v
    end,

    wheel_distance_set = function(self, dist)
        eo.__do_start(self, __class)
        __lib.efl_event_pointer_wheel_distance_set(dist)
        eo.__do_end()
    end,

    wheel_distance_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_pointer_wheel_distance_get()
        eo.__do_end()
        return tonumber(v)
    end,

    __properties = {
        ["wheel_direction"] = { 0, 0, 1, 1, true, true },
        ["position"] = { 0, 0, 2, 2, true, true },
        ["button_pressed"] = { 1, 1, 1, 1, true, true },
        ["position_precise"] = { 0, 0, 2, 2, true, true },
        ["button"] = { 0, 0, 1, 1, true, true },
        ["triple_click"] = { 0, 0, 1, 1, true, true },
        ["double_click"] = { 0, 0, 1, 1, true, true },
        ["button_flags"] = { 0, 0, 1, 1, true, true },
        ["source"] = { 0, 0, 1, 1, true, true },
        ["previous_position_precise"] = { 0, 0, 2, 2, true, true },
        ["touch"] = { 0, 0, 5, 5, true, true },
        ["previous_position"] = { 0, 0, 2, 2, true, true },
        ["action"] = { 0, 0, 1, 1, true, true },
        ["wheel_distance"] = { 0, 0, 1, 1, true, true },
        ["finger"] = { 0, 0, 1, 1, true, true }
    }
}

__M.Pointer = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Efl_Event_Pointer").__eo_ctor,
                            1, ...)
end

return M
