/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.BaseGatewayShardAllocator;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public abstract class ReplicaShardAllocator
extends BaseGatewayShardAllocator {
    public ReplicaShardAllocator(Settings settings) {
        super(settings);
    }

    public void processExistingRecoveries(RoutingAllocation allocation) {
        MetaData metaData = allocation.metaData();
        RoutingNodes routingNodes = allocation.routingNodes();
        ArrayList<Runnable> shardCancellationActions = new ArrayList<Runnable>();
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shard : routingNode) {
                if (shard.primary() || !shard.initializing() || shard.relocatingNodeId() != null || shard.unassignedInfo() != null && shard.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED) continue;
                AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(shard, allocation);
                if (!shardStores.hasData()) {
                    this.logger.trace("{}: fetching new stores for initializing shard", (Object)shard);
                    continue;
                }
                ShardRouting primaryShard = allocation.routingNodes().activePrimary(shard.shardId());
                assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
                if (primaryStore == null) {
                    this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)shard);
                    continue;
                }
                MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, primaryStore, shardStores, false);
                if (matchingNodes.getNodeWithHighestMatch() == null) continue;
                DiscoveryNode currentNode = allocation.nodes().get(shard.currentNodeId());
                DiscoveryNode nodeWithHighestMatch = matchingNodes.getNodeWithHighestMatch();
                String currentSyncId = shardStores.getData().containsKey(currentNode) ? shardStores.getData().get(currentNode).storeFilesMetaData().syncId() : null;
                if (currentNode.equals(nodeWithHighestMatch) || Objects.equals(currentSyncId, primaryStore.syncId()) || !matchingNodes.isNodeMatchBySyncID(nodeWithHighestMatch)) continue;
                this.logger.debug("cancelling allocation of replica on [{}], sync id match found on node [{}]", (Object)currentNode, (Object)nodeWithHighestMatch);
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.REALLOCATED_REPLICA, "existing allocation of replica to [" + currentNode + "] cancelled, sync id match found on node [" + nodeWithHighestMatch + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT);
                shardCancellationActions.add(() -> routingNodes.failShard(this.logger, shard, unassignedInfo, metaData.getIndexSafe(shard.index()), allocation.changes()));
            }
        }
        for (Runnable action : shardCancellationActions) {
            action.run();
        }
    }

    private static boolean isResponsibleFor(ShardRouting shard) {
        return !shard.primary() && shard.unassigned() && shard.unassignedInfo().getReason() != UnassignedInfo.Reason.INDEX_CREATED;
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        if (!ReplicaShardAllocator.isResponsibleFor(unassignedShard)) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        boolean explain = allocation.debugDecision();
        Tuple<Decision, Map<String, Decision>> allocateDecision = this.canBeAllocatedToAtLeastOneNode(unassignedShard, allocation, explain);
        if (allocateDecision.v1().type() != Decision.Type.YES) {
            logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)unassignedShard);
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.v1().type()), explain ? "all nodes returned a " + (Object)((Object)allocateDecision.v1().type()) + " decision for allocating the replica shard" : null, allocateDecision.v2());
        }
        AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(unassignedShard, allocation);
        if (!shardStores.hasData()) {
            logger.trace("{}: ignoring allocation, still fetching shard stores", (Object)unassignedShard);
            allocation.setHasPendingAsyncFetch();
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, explain ? "still fetching shard state from the nodes in the cluster" : null);
        }
        ShardRouting primaryShard = routingNodes.activePrimary(unassignedShard.shardId());
        assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
        TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
        if (primaryStore == null) {
            logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)unassignedShard);
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        MatchingNodes matchingNodes = this.findMatchingNodes(unassignedShard, allocation, primaryStore, shardStores, explain);
        assert (!explain || matchingNodes.nodeDecisions != null) : "in explain mode, we must have individual node decisions";
        if (matchingNodes.getNodeWithHighestMatch() != null) {
            RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.getNodeWithHighestMatch().getId());
            Decision decision = allocation.deciders().canAllocate(unassignedShard, nodeWithHighestMatch, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
                return AllocateUnassignedDecision.throttle(explain ? "returned a THROTTLE decision on each node that has an existing copy of the shard, so waiting to re-use one of those copies" : null, matchingNodes.nodeDecisions);
            }
            logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
            return AllocateUnassignedDecision.yes(nodeWithHighestMatch.nodeId(), "allocating to node [" + nodeWithHighestMatch.nodeId() + "] in order to re-use its unallocated persistent store", null, matchingNodes.nodeDecisions);
        }
        if (!matchingNodes.hasAnyData() && unassignedShard.unassignedInfo().isDelayed()) {
            logger.debug("{}: allocation of [{}] is delayed", (Object)unassignedShard.shardId(), (Object)unassignedShard);
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, explain ? "not allocating this shard, no nodes contain data for the replica and allocation is delayed" : null);
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    private Tuple<Decision, Map<String, Decision>> canBeAllocatedToAtLeastOneNode(ShardRouting shard, RoutingAllocation allocation, boolean explain) {
        Decision madeDecision = Decision.NO;
        HashMap<String, Decision> nodeDecisions = new HashMap<String, Decision>();
        for (ObjectCursor cursor : allocation.nodes().getDataNodes().values()) {
            RoutingNode node = allocation.routingNodes().node(((DiscoveryNode)cursor.value).getId());
            if (node == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            if (explain) {
                nodeDecisions.put(node.nodeId(), decision);
            }
            if (decision.type() == Decision.Type.YES) {
                return Tuple.tuple(decision, null);
            }
            if (madeDecision.type() != Decision.Type.NO || decision.type() != Decision.Type.THROTTLE) continue;
            madeDecision = decision;
        }
        return Tuple.tuple(madeDecision, explain ? nodeDecisions : null);
    }

    private TransportNodesListShardStoreMetaData.StoreFilesMetaData findStore(ShardRouting shard, RoutingAllocation allocation, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data) {
        assert (shard.currentNodeId() != null);
        DiscoveryNode primaryNode = allocation.nodes().get(shard.currentNodeId());
        if (primaryNode == null) {
            return null;
        }
        TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData primaryNodeFilesStore = data.getData().get(primaryNode);
        if (primaryNodeFilesStore == null) {
            return null;
        }
        return primaryNodeFilesStore.storeFilesMetaData();
    }

    private MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data, boolean explain) {
        ObjectLongHashMap nodesToSize = new ObjectLongHashMap();
        HashMap<String, Decision> nodeDecisions = new HashMap<String, Decision>();
        for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> nodeStoreEntry : data.getData().entrySet()) {
            RoutingNode node;
            DiscoveryNode discoNode = nodeStoreEntry.getKey();
            TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = nodeStoreEntry.getValue().storeFilesMetaData();
            if (storeFilesMetaData.isEmpty() || (node = allocation.routingNodes().node(discoNode.getId())) == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            if (explain) {
                nodeDecisions.put(node.nodeId(), decision);
            }
            if (decision.type() == Decision.Type.NO) continue;
            String primarySyncId = primaryStore.syncId();
            String replicaSyncId = storeFilesMetaData.syncId();
            if (replicaSyncId != null && replicaSyncId.equals(primarySyncId)) {
                this.logger.trace("{}: node [{}] has same sync id {} as primary", (Object)shard, (Object)discoNode.getName(), (Object)replicaSyncId);
                nodesToSize.put((Object)discoNode, Long.MAX_VALUE);
                continue;
            }
            long sizeMatched = 0L;
            for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                String metaDataFileName = storeFileMetaData.name();
                if (!primaryStore.fileExists(metaDataFileName) || !primaryStore.file(metaDataFileName).isSame(storeFileMetaData)) continue;
                sizeMatched += storeFileMetaData.length();
            }
            this.logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable data", (Object)shard, (Object)discoNode.getName(), (Object)new ByteSizeValue(sizeMatched), (Object)sizeMatched);
            nodesToSize.put((Object)discoNode, sizeMatched);
        }
        return new MatchingNodes((ObjectLongMap<DiscoveryNode>)nodesToSize, explain ? nodeDecisions : null);
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting var1, RoutingAllocation var2);

    static class MatchingNodes {
        private final ObjectLongMap<DiscoveryNode> nodesToSize;
        private final DiscoveryNode nodeWithHighestMatch;
        @Nullable
        private final Map<String, Decision> nodeDecisions;

        public MatchingNodes(ObjectLongMap<DiscoveryNode> nodesToSize, @Nullable Map<String, Decision> nodeDecisions) {
            this.nodesToSize = nodesToSize;
            this.nodeDecisions = nodeDecisions;
            long highestMatchSize = 0L;
            DiscoveryNode highestMatchNode = null;
            for (ObjectLongCursor cursor : nodesToSize) {
                if (cursor.value <= highestMatchSize) continue;
                highestMatchSize = cursor.value;
                highestMatchNode = (DiscoveryNode)cursor.key;
            }
            this.nodeWithHighestMatch = highestMatchNode;
        }

        @Nullable
        public DiscoveryNode getNodeWithHighestMatch() {
            return this.nodeWithHighestMatch;
        }

        public boolean isNodeMatchBySyncID(DiscoveryNode node) {
            return this.nodesToSize.get((Object)node) == Long.MAX_VALUE;
        }

        public boolean hasAnyData() {
            return !this.nodesToSize.isEmpty();
        }

        @Nullable
        public Map<String, Decision> getNodeDecisions() {
            return this.nodeDecisions;
        }
    }
}

