/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.FromXContentBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;

public abstract class BlobStoreFormat<T extends ToXContent> {
    protected final String blobNameFormat;
    protected final FromXContentBuilder<T> reader;
    protected final ParseFieldMatcher parseFieldMatcher;
    protected static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;

    protected BlobStoreFormat(String blobNameFormat, FromXContentBuilder<T> reader, ParseFieldMatcher parseFieldMatcher) {
        this.reader = reader;
        this.blobNameFormat = blobNameFormat;
        this.parseFieldMatcher = parseFieldMatcher;
    }

    public abstract T readBlob(BlobContainer var1, String var2) throws IOException;

    public T read(BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        return this.readBlob(blobContainer, blobName);
    }

    public void delete(BlobContainer blobContainer, String name) throws IOException {
        blobContainer.deleteBlob(this.blobName(name));
    }

    public boolean exists(BlobContainer blobContainer, String name) throws IOException {
        return blobContainer.blobExists(this.blobName(name));
    }

    protected String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    protected T read(BytesReference bytes) throws IOException {
        try (XContentParser parser = XContentHelper.createParser(bytes);){
            ToXContent obj;
            ToXContent toXContent = obj = (ToXContent)this.reader.fromXContent(parser, this.parseFieldMatcher);
            return (T)toXContent;
        }
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", MetaData.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

