/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public class InternalAggregations
implements Aggregations,
ToXContent,
Streamable {
    public static final InternalAggregations EMPTY = new InternalAggregations();
    private List<InternalAggregation> aggregations = Collections.emptyList();
    private Map<String, Aggregation> aggregationsAsMap;

    private InternalAggregations() {
    }

    public InternalAggregations(List<InternalAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public Iterator<Aggregation> iterator() {
        return this.aggregations.stream().map(p -> p).iterator();
    }

    @Override
    public List<Aggregation> asList() {
        return this.aggregations.stream().map(p -> p).collect(Collectors.toList());
    }

    @Override
    public Map<String, Aggregation> asMap() {
        return this.getAsMap();
    }

    @Override
    public Map<String, Aggregation> getAsMap() {
        if (this.aggregationsAsMap == null) {
            HashMap<String, InternalAggregation> newAggregationsAsMap = new HashMap<String, InternalAggregation>();
            for (InternalAggregation aggregation : this.aggregations) {
                newAggregationsAsMap.put(aggregation.getName(), aggregation);
            }
            this.aggregationsAsMap = Collections.unmodifiableMap(newAggregationsAsMap);
        }
        return this.aggregationsAsMap;
    }

    @Override
    public <A extends Aggregation> A get(String name) {
        return (A)this.asMap().get(name);
    }

    @Override
    public Object getProperty(String path) {
        AggregationPath aggPath = AggregationPath.parse(path);
        return this.getProperty(aggPath.getPathElementsAsStringList());
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        String aggName = path.get(0);
        InternalAggregation aggregation = (InternalAggregation)this.get(aggName);
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find an aggregation named [" + aggName + "]");
        }
        return aggregation.getProperty(path.subList(1, path.size()));
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        HashMap<String, ArrayList<InternalAggregation>> aggByName = new HashMap<String, ArrayList<InternalAggregation>>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (InternalAggregation aggregation : aggregations.aggregations) {
                ArrayList<InternalAggregation> aggs = (ArrayList<InternalAggregation>)aggByName.get(aggregation.getName());
                if (aggs == null) {
                    aggs = new ArrayList<InternalAggregation>(aggregationsList.size());
                    aggByName.put(aggregation.getName(), aggs);
                }
                aggs.add(aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            reducedAggregations.add(first.reduce(aggregations, context));
        }
        return new InternalAggregations(reducedAggregations);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.aggregations.isEmpty()) {
            return builder;
        }
        builder.startObject("aggregations");
        this.toXContentInternal(builder, params);
        return builder.endObject();
    }

    public XContentBuilder toXContentInternal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Aggregation aggregation : this.aggregations) {
            ((InternalAggregation)aggregation).toXContent(builder, params);
        }
        return builder;
    }

    public static InternalAggregations readAggregations(StreamInput in) throws IOException {
        InternalAggregations result = new InternalAggregations();
        result.readFrom(in);
        return result;
    }

    public static InternalAggregations readOptionalAggregations(StreamInput in) throws IOException {
        return in.readOptionalStreamable(InternalAggregations::new);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.aggregations = in.readList(stream -> in.readNamedWriteable(InternalAggregation.class));
        if (this.aggregations.isEmpty()) {
            this.aggregationsAsMap = Collections.emptyMap();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.aggregations);
    }

    static class Fields {
        public static final String AGGREGATIONS = "aggregations";

        Fields() {
        }
    }
}

