/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.TemplateService;

public final class RemoveProcessor
extends AbstractProcessor {
    public static final String TYPE = "remove";
    private final TemplateService.Template field;

    RemoveProcessor(String tag, TemplateService.Template field) {
        super(tag);
        this.field = field;
    }

    public TemplateService.Template getField() {
        return this.field;
    }

    public void execute(IngestDocument document) {
        document.removeField(this.field);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final TemplateService templateService;

        public Factory(TemplateService templateService) {
            this.templateService = templateService;
        }

        public RemoveProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)RemoveProcessor.TYPE, (String)processorTag, config, (String)"field");
            TemplateService.Template compiledTemplate = ConfigurationUtils.compileTemplate((String)RemoveProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (TemplateService)this.templateService);
            return new RemoveProcessor(processorTag, compiledTemplate);
        }
    }
}

