/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.tools.Diff;
import org.openstreetmap.josm.tools.Utils;

class TwoColumnDiff {
    public List<Item> referenceDiff;
    public List<Item> currentDiff;
    private final Object[] reference;
    private final Object[] current;
    boolean referenceReversed;

    TwoColumnDiff(Object[] objectArray, Object ... objectArray2) {
        this.reference = Utils.copyArray(objectArray);
        this.current = Utils.copyArray(objectArray2);
        this.referenceDiff = new ArrayList<Item>();
        this.currentDiff = new ArrayList<Item>();
        this.diff();
    }

    private void diff() {
        Diff.Change change = new Diff(this.reference, this.current).diff2(false);
        Object[] objectArray = Utils.copyArray(this.reference);
        Collections.reverse(Arrays.asList(objectArray));
        Diff.Change change2 = new Diff(objectArray, this.current).diff2(false);
        if (change2 == null || change != null && change2.getTotalNumberOfChanges() < change.getTotalNumberOfChanges()) {
            this.referenceReversed = true;
            this.twoColumnDiffFromScript(change2, objectArray, this.current, true);
        } else {
            this.referenceReversed = false;
            this.twoColumnDiffFromScript(change, this.reference, this.current, false);
        }
    }

    private void twoColumnDiffFromScript(Diff.Change change, Object[] objectArray, Object[] objectArray2, boolean bl) {
        int n = 0;
        int n2 = 0;
        while (change != null) {
            int n3 = change.deleted;
            int n4 = change.inserted;
            while (n < change.line0 && n2 < change.line1) {
                this.referenceDiff.add(new Item(bl ? Item.DiffItemType.REVERSED : Item.DiffItemType.SAME, objectArray[n++]));
                this.currentDiff.add(new Item(Item.DiffItemType.SAME, objectArray2[n2++]));
            }
            while (n4 > 0 || n3 > 0) {
                if (n4 > 0 && n3 > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.CHANGED, objectArray[n++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.CHANGED, objectArray2[n2++]));
                } else if (n4 > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                    this.currentDiff.add(new Item(Item.DiffItemType.INSERTED, objectArray2[n2++]));
                } else {
                    this.referenceDiff.add(new Item(Item.DiffItemType.DELETED, objectArray[n++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                }
                --n4;
                --n3;
            }
            change = change.link;
        }
        while (n < objectArray.length && n2 < objectArray2.length) {
            this.referenceDiff.add(new Item(bl ? Item.DiffItemType.REVERSED : Item.DiffItemType.SAME, objectArray[n++]));
            this.currentDiff.add(new Item(Item.DiffItemType.SAME, objectArray2[n2++]));
        }
    }

    public static class Item {
        public final Object value;
        public final DiffItemType state;

        Item(DiffItemType diffItemType, Object object) {
            this.state = diffItemType;
            this.value = diffItemType == DiffItemType.EMPTY ? null : object;
        }

        public static enum DiffItemType {
            INSERTED(new Color(221, 255, 221)),
            DELETED(new Color(255, 197, 197)),
            CHANGED(new Color(255, 234, 213)),
            REVERSED(new Color(255, 255, 204)),
            SAME(new Color(234, 234, 234)),
            EMPTY(new Color(234, 234, 234));

            private final Color color;

            private DiffItemType(Color color) {
                this.color = color;
            }

            public Color getColor() {
                return this.color;
            }
        }
    }
}

