/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;

public class RaiseIfFrozenNode
extends RubyNode {
    private final BranchProfile errorProfile = BranchProfile.create();
    @Node.Child
    private RubyNode child;
    @Node.Child
    private IsFrozenNode isFrozenNode;

    public RaiseIfFrozenNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
        this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result = this.child.execute(frame);
        if (this.isFrozenNode.executeIsFrozen(result)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().frozenError(result, this));
        }
        return result;
    }
}

