/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509StoreContext;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Store
extends RubyObject {
    private static final long serialVersionUID = -2969708892287379665L;
    private static ObjectAllocator X509STORE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Store(runtime, klass);
        }
    };
    private final Store store = new Store();
    private static Store.VerifyCallbackFunction verifyCallback = new Store.VerifyCallbackFunction(){

        @Override
        public int call(StoreContext context2, Integer outcome) {
            int ok = outcome;
            IRubyObject proc = (IRubyObject)context2.getExtraData(1);
            if (proc == null) {
                proc = (IRubyObject)context2.getStore().getExtraData(0);
            }
            if (proc == null) {
                return ok;
            }
            if (!proc.isNil()) {
                Ruby runtime = proc.getRuntime();
                X509StoreContext store_context = X509StoreContext.newStoreContext(runtime, context2);
                IRubyObject ret = proc.callMethod(runtime.getCurrentContext(), "call", new IRubyObject[]{runtime.newBoolean(ok != 0), store_context});
                if (ret.isTrue()) {
                    context2.setError(0);
                    ok = 1;
                } else {
                    if (context2.getError() == 0) {
                        context2.setError(28);
                    }
                    ok = 0;
                }
            }
            return ok;
        }
    };

    public static void createX509Store(Ruby runtime, RubyModule X5092) {
        RubyClass Store2 = X5092.defineClassUnder("Store", runtime.getObject(), X509STORE_ALLOCATOR);
        RubyClass OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        X5092.defineClassUnder("StoreError", OpenSSLError, OpenSSLError.getAllocator());
        ThreadContext context2 = runtime.getCurrentContext();
        Store2.addReadWriteAttribute(context2, "error");
        Store2.addReadWriteAttribute(context2, "error_string");
        Store2.addReadWriteAttribute(context2, "chain");
        Store2.defineAnnotatedMethods(X509Store.class);
        X509StoreContext.createX509StoreContext(runtime, X5092);
    }

    public X509Store(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private X509Store(Ruby runtime) {
        super(runtime, X509._X509(runtime).getClass("Store"));
    }

    static X509Store newStore(Ruby runtime) {
        X509Store store = new X509Store(runtime);
        store.initialize(runtime.getCurrentContext(), NULL_ARRAY);
        return store;
    }

    final Store getStore() {
        return this.store;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        IRubyObject nil = runtime.getNil();
        RubyFixnum zero = RubyFixnum.zero((Ruby)runtime);
        this.store.setVerifyCallbackFunction(verifyCallback);
        this.set_verify_callback(nil);
        this.setInstanceVariable("@flags", (IRubyObject)zero);
        this.setInstanceVariable("@purpose", (IRubyObject)zero);
        this.setInstanceVariable("@trust", (IRubyObject)zero);
        this.setInstanceVariable("@error", nil);
        this.setInstanceVariable("@error_string", nil);
        this.setInstanceVariable("@chain", nil);
        this.setInstanceVariable("@time", nil);
        return this;
    }

    @JRubyMethod
    public IRubyObject verify_callback() {
        return this.getInstanceVariable("@verify_callback");
    }

    @JRubyMethod(name={"verify_callback="})
    public IRubyObject set_verify_callback(IRubyObject callback) {
        this.store.setExtraData(1, callback);
        this.setInstanceVariable("@verify_callback", callback);
        return callback;
    }

    @JRubyMethod(name={"flags="})
    public IRubyObject set_flags(IRubyObject arg) {
        this.store.setFlags(RubyNumeric.fix2long((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"purpose="})
    public IRubyObject set_purpose(IRubyObject arg) {
        this.store.setPurpose(RubyNumeric.fix2int((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"trust="})
    public IRubyObject set_trust(IRubyObject arg) {
        this.store.setTrust(RubyNumeric.fix2int((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(IRubyObject arg) {
        this.setInstanceVariable("@time", arg);
        return arg;
    }

    @JRubyMethod
    public IRubyObject add_path(ThreadContext context2, IRubyObject arg) {
        OpenSSL.warn(context2, "WARNING: unimplemented method called: Store#add_path");
        return context2.nil;
    }

    @JRubyMethod
    public IRubyObject add_file(IRubyObject arg) {
        String file = arg.toString();
        Ruby runtime = this.getRuntime();
        try {
            this.store.loadLocations(runtime, file, null);
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509Store.newStoreError(runtime, "loading file failed: ", e);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_default_paths(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        try {
            this.store.setDefaultPaths(runtime);
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509Store.newStoreError(runtime, "setting default path failed: ", e);
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public X509Store add_cert(IRubyObject cert2) {
        X509AuxCertificate auxCert;
        X509AuxCertificate x509AuxCertificate = auxCert = cert2 instanceof X509Cert ? ((X509Cert)cert2).getAuxCert() : (X509AuxCertificate)null;
        if (this.store.addCertificate(auxCert) != 1) {
            throw X509Store.newStoreError(this.getRuntime(), X509Error.getLastErrorMessage());
        }
        return this;
    }

    @JRubyMethod
    public X509Store add_crl(IRubyObject crl2) {
        java.security.cert.X509CRL jCRL;
        java.security.cert.X509CRL x509CRL = jCRL = crl2 instanceof X509CRL ? ((X509CRL)crl2).getCRL() : null;
        if (this.store.addCRL(jCRL) != 1) {
            throw X509Store.newStoreError(this.getRuntime(), X509Error.getLastErrorMessage());
        }
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject verify(ThreadContext context2, IRubyObject[] args, Block block) {
        Ruby runtime = context2.runtime;
        IRubyObject cert2 = args[0];
        IRubyObject chain2 = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)2) == 2 ? args[1] : runtime.getNil();
        Object verify_callback2 = block.isGiven() ? runtime.newProc(Block.Type.PROC, block) : this.getInstanceVariable("@verify_callback");
        X509StoreContext store_context = X509StoreContext.newStoreContext(context2, this, cert2, chain2);
        store_context.setInstanceVariable("@verify_callback", (IRubyObject)verify_callback2);
        IRubyObject result = store_context.callMethod(context2, "verify");
        this.setInstanceVariable("@error", store_context.error(context2));
        this.setInstanceVariable("@error_string", store_context.error_string(context2));
        this.setInstanceVariable("@chain", store_context.chain(context2));
        return result;
    }

    private static RubyClass _StoreError(Ruby runtime) {
        return X509._X509(runtime).getClass("StoreError");
    }

    private static RaiseException newStoreError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509Store._StoreError(runtime), message);
    }

    private static RaiseException newStoreError(Ruby runtime, String message, Exception e) {
        return X509Store.newStoreError(runtime, message + (e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()));
    }
}

