/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath(ClassPath.getClassPath());
    private static final FilenameFilter ARCHIVE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
        }
    };
    private final PathEntry[] paths;
    private final String class_path;
    private ClassPath parent;

    public ClassPath(ClassPath parent, String class_path) {
        this(class_path);
        this.parent = parent;
    }

    public ClassPath(String class_path) {
        this.class_path = class_path;
        ArrayList<PathEntry> list = new ArrayList<PathEntry>();
        StringTokenizer tok = new StringTokenizer(class_path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.isEmpty()) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    list.add(new Dir(path));
                    continue;
                }
                list.add(new Zip(new ZipFile(file)));
            }
            catch (IOException e) {
                if (!path.endsWith(".zip") && !path.endsWith(".jar")) continue;
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[list.size()];
        list.toArray(this.paths);
    }

    @Deprecated
    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public String toString() {
        if (this.parent != null) {
            return this.parent + File.pathSeparator + this.class_path;
        }
        return this.class_path;
    }

    public int hashCode() {
        if (this.parent != null) {
            return this.class_path.hashCode() + this.parent.hashCode();
        }
        return this.class_path.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPath) {
            ClassPath cp = (ClassPath)o;
            return this.class_path.equals(cp.toString());
        }
        return false;
    }

    private static void getPathComponents(String path, List<String> list) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    public static String getClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        ArrayList<String> list = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        ArrayList<String> dirs = new ArrayList<String>();
        ClassPath.getPathComponents(ext_path, dirs);
        for (String d : dirs) {
            File ext_dir = new File(d);
            String[] extensions = ext_dir.list(ARCHIVE_FILTER);
            if (extensions == null) continue;
            for (String extension : extensions) {
                list.add(ext_dir.getPath() + File.separatorChar + extension);
            }
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        for (String path : list) {
            buf.append(separator);
            separator = File.pathSeparator;
            buf.append(path);
        }
        return buf.toString().intern();
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name.replace('.', '/'), ".class");
    }

    public InputStream getInputStream(String name, String suffix) throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(name + suffix);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public InputStream getResourceAsStream(String name) {
        for (PathEntry path : this.paths) {
            InputStream is = path.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public URL getResource(String name) {
        for (PathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) {
        Vector<URL> results = new Vector<URL>();
        for (PathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            results.add(url);
        }
        return results.elements();
    }

    public ClassFile getClassFile(String name, String suffix) throws IOException {
        ClassFile cf = null;
        if (this.parent != null) {
            cf = this.parent.getClassFileInternal(name, suffix);
        }
        if (cf == null) {
            cf = this.getClassFileInternal(name, suffix);
        }
        if (cf != null) {
            return cf;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    private ClassFile getClassFileInternal(String name, String suffix) throws IOException {
        for (PathEntry path : this.paths) {
            ClassFile cf = path.getClassFile(name, suffix);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    public ClassFile getClassFile(String name) throws IOException {
        return this.getClassFile(name, ".class");
    }

    /*
     * Loose catch block
     */
    public byte[] getBytes(String name, String suffix) throws IOException {
        try (FilterInputStream dis = null;){
            try (InputStream is = this.getInputStream(name, suffix);){
                if (is == null) {
                    throw new IOException("Couldn't find: " + name + suffix);
                }
                dis = new DataInputStream(is);
                byte[] bytes = new byte[is.available()];
                ((DataInputStream)dis).readFully(bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public byte[] getBytes(String name) throws IOException {
        return this.getBytes(name, ".class");
    }

    public String getPath(String name) throws IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public String getPath(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    private static class Zip
    extends PathEntry {
        private final ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        @Override
        URL getResource(String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? new URL("jar:file:" + this.zip.getName() + "!/" + name) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? this.zip.getInputStream(entry) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            final ZipEntry entry = this.zip.getEntry(name.replace('.', '/') + suffix);
            if (entry == null) {
                return null;
            }
            return new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return Zip.this.zip.getInputStream(entry);
                }

                @Override
                public String getPath() {
                    return entry.toString();
                }

                @Override
                public long getTime() {
                    return entry.getTime();
                }

                @Override
                public long getSize() {
                    return entry.getSize();
                }

                @Override
                public String getBase() {
                    return Zip.this.zip.getName();
                }
            };
        }
    }

    private static class Dir
    extends PathEntry {
        private final String dir;

        Dir(String d) {
            this.dir = d;
        }

        @Override
        URL getResource(String name) {
            File file = new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? file.toURI().toURL() : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            File file = new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? new FileInputStream(file) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            final File file = new File(this.dir + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                @Override
                public long getTime() {
                    return file.lastModified();
                }

                @Override
                public long getSize() {
                    return file.length();
                }

                @Override
                public String getBase() {
                    return Dir.this.dir;
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;

        abstract URL getResource(String var1);

        abstract InputStream getResourceAsStream(String var1);
    }
}

