/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.ToJavaNodeGen;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.Method;

public final class JavaInterop {
    private JavaInterop() {
    }

    public static <T> T asJavaObject(Class<T> type, TruffleObject foreignObject) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(TruffleLanguage.class, ToJavaNodeGen.create(), foreignObject, type);
        Object convertedValue = Truffle.getRuntime().createCallTarget(root).call(new Object[0]);
        return type.cast(convertedValue);
    }

    public static TruffleObject asTruffleObject(Object obj) {
        if (obj instanceof TruffleObject) {
            return (TruffleObject)obj;
        }
        if (obj instanceof Class) {
            return new JavaObject(null, (Class)obj);
        }
        if (obj == null) {
            return JavaObject.NULL;
        }
        return new JavaObject(obj, obj.getClass());
    }

    public static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(TruffleLanguage.class, ToJavaNodeGen.create(), function, functionalType);
        return functionalType.cast(Truffle.getRuntime().createCallTarget(root).call(new Object[0]));
    }

    public static <T> TruffleObject asTruffleFunction(Class<T> functionalType, T implementation) {
        Method method = JavaInterop.functionalInterfaceMethod(functionalType);
        if (method == null) {
            throw new IllegalArgumentException();
        }
        return new JavaFunctionObject(method, implementation);
    }

    private static <T> Method functionalInterfaceMethod(Class<T> functionalType) {
        if (!functionalType.isInterface()) {
            return null;
        }
        Method[] arr = functionalType.getMethods();
        if (arr.length == 1) {
            return arr[0];
        }
        Method found = null;
        for (Method m : arr) {
            if ((m.getModifiers() & 0x400) == 0) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (found != null) {
                    return null;
                }
                found = m;
            }
        }
        return found;
    }

    private static class TemporaryConvertRoot
    extends RootNode {
        @Node.Child
        private ToJavaNode node;
        private final Object value;
        private final Class<?> type;

        TemporaryConvertRoot(Class<? extends TruffleLanguage> lang, ToJavaNode node, Object value, Class<?> type) {
            super(lang, null, null);
            this.node = node;
            this.value = value;
            this.type = type;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.value, this.type);
        }
    }
}

