/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.klass.ClassNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.FreezeNode;
import org.jruby.truffle.language.objects.FreezeNodeGen;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;
import org.jruby.truffle.language.objects.ObjectIDOperations;
import org.jruby.truffle.util.StringUtils;

@NodeChild(value="value", type=RubyNode.class)
public abstract class SingletonClassNode
extends RubyNode {
    @Node.Child
    private IsFrozenNode isFrozenNode;
    @Node.Child
    private FreezeNode freezeNode;

    public SingletonClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeSingletonClass(Object var1);

    @Specialization(guards={"value"})
    protected DynamicObject singletonClassTrue(boolean value) {
        return this.coreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected DynamicObject singletonClassFalse(boolean value) {
        return this.coreLibrary().getFalseClass();
    }

    @Specialization(guards={"isNil(value)"})
    protected DynamicObject singletonClassNil(DynamicObject value) {
        return this.coreLibrary().getNilClass();
    }

    @Specialization
    protected DynamicObject singletonClass(int value) {
        return this.noSingletonClass();
    }

    @Specialization
    protected DynamicObject singletonClass(long value) {
        return this.noSingletonClass();
    }

    @Specialization
    protected DynamicObject singletonClass(double value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    protected DynamicObject singletonClassBignum(DynamicObject value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubySymbol(value)"})
    protected DynamicObject singletonClassSymbol(DynamicObject value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubyClass(rubyClass)", "rubyClass.getShape() == cachedShape", "cachedSingletonClass != null"}, limit="getCacheLimit()")
    protected DynamicObject singletonClassClassCached(DynamicObject rubyClass, @Cached(value="rubyClass.getShape()") Shape cachedShape, @Cached(value="getSingletonClassOrNull(rubyClass)") DynamicObject cachedSingletonClass) {
        return cachedSingletonClass;
    }

    @Specialization(guards={"isRubyClass(rubyClass)"}, contains={"singletonClassClassCached"})
    protected DynamicObject singletonClassClassUncached(DynamicObject rubyClass) {
        return ClassNodes.getSingletonClass(this.getContext(), rubyClass);
    }

    @Specialization(guards={"object == cachedObject", "!isNil(cachedObject)", "!isRubyBignum(cachedObject)", "!isRubySymbol(cachedObject)", "!isRubyClass(cachedObject)"}, limit="getCacheLimit()")
    protected DynamicObject singletonClassInstanceCached(DynamicObject object, @Cached(value="object") DynamicObject cachedObject, @Cached(value="getSingletonClassForInstance(object)") DynamicObject cachedSingletonClass) {
        return cachedSingletonClass;
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubySymbol(object)", "!isRubyClass(object)"}, contains={"singletonClassInstanceCached"})
    protected DynamicObject singletonClassInstanceUncached(DynamicObject object) {
        return this.getSingletonClassForInstance(object);
    }

    private DynamicObject noSingletonClass() {
        throw new RaiseException(this.coreExceptions().typeErrorCantDefineSingleton(this));
    }

    protected DynamicObject getSingletonClassOrNull(DynamicObject object) {
        return ClassNodes.getSingletonClassOrNull(this.getContext(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected DynamicObject getSingletonClassForInstance(DynamicObject object) {
        DynamicObject dynamicObject = object;
        synchronized (dynamicObject) {
            DynamicObject metaClass = Layouts.BASIC_OBJECT.getMetaClass(object);
            if (Layouts.CLASS.getIsSingleton(metaClass)) {
                return metaClass;
            }
            DynamicObject logicalClass = Layouts.BASIC_OBJECT.getLogicalClass(object);
            String name = StringUtils.format("#<Class:#<%s:0x%x>>", Layouts.MODULE.getFields(logicalClass).getName(), ObjectIDOperations.verySlowGetObjectID(this.getContext(), object));
            DynamicObject singletonClass = ClassNodes.createSingletonClassOfObject(this.getContext(), logicalClass, object, name);
            if (this.isFrozen(object)) {
                this.freeze(singletonClass);
            }
            Layouts.BASIC_OBJECT.setMetaClass(object, singletonClass);
            return singletonClass;
        }
    }

    public void freeze(DynamicObject singletonClass) {
        if (this.freezeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.freezeNode = this.insert(FreezeNodeGen.create(this.getContext(), null, null));
        }
        this.freezeNode.executeFreeze(singletonClass);
    }

    protected boolean isFrozen(Object object) {
        if (this.isFrozenNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), null, null));
        }
        return this.isFrozenNode.executeIsFrozen(object);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().CLASS_CACHE;
    }
}

