/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.discovery.zen.MasterFaultDetection;
import org.elasticsearch.discovery.zen.MembershipAction;
import org.elasticsearch.discovery.zen.NodeJoinController;
import org.elasticsearch.discovery.zen.NodesFaultDetection;
import org.elasticsearch.discovery.zen.PendingClusterStateStats;
import org.elasticsearch.discovery.zen.PendingClusterStatesQueue;
import org.elasticsearch.discovery.zen.PingContextProvider;
import org.elasticsearch.discovery.zen.PublishClusterStateAction;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastZenPing;
import org.elasticsearch.discovery.zen.ZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ZenDiscovery
extends AbstractLifecycleComponent
implements Discovery,
PingContextProvider {
    public static final Setting<TimeValue> PING_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.zen.ping_timeout", TimeValue.timeValueSeconds(3L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> JOIN_TIMEOUT_SETTING = Setting.timeSetting("discovery.zen.join_timeout", settings -> TimeValue.timeValueMillis(PING_TIMEOUT_SETTING.get((Settings)settings).millis() * 20L), TimeValue.timeValueMillis(0L), Setting.Property.NodeScope);
    public static final Setting<Integer> JOIN_RETRY_ATTEMPTS_SETTING = Setting.intSetting("discovery.zen.join_retry_attempts", 3, 1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> JOIN_RETRY_DELAY_SETTING = Setting.positiveTimeSetting("discovery.zen.join_retry_delay", TimeValue.timeValueMillis(100L), Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_PINGS_FROM_ANOTHER_MASTER_SETTING = Setting.intSetting("discovery.zen.max_pings_from_another_master", 3, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> SEND_LEAVE_REQUEST_SETTING = Setting.boolSetting("discovery.zen.send_leave_request", true, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MASTER_ELECTION_WAIT_FOR_JOINS_TIMEOUT_SETTING = Setting.timeSetting("discovery.zen.master_election.wait_for_joins_timeout", settings -> TimeValue.timeValueMillis(JOIN_TIMEOUT_SETTING.get((Settings)settings).millis() / 2L), TimeValue.timeValueMillis(0L), Setting.Property.NodeScope);
    public static final Setting<Boolean> MASTER_ELECTION_IGNORE_NON_MASTER_PINGS_SETTING = Setting.boolSetting("discovery.zen.master_election.ignore_non_master_pings", false, Setting.Property.NodeScope);
    public static final String DISCOVERY_REJOIN_ACTION_NAME = "internal:discovery/zen/rejoin";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private AllocationService allocationService;
    private final ClusterName clusterName;
    private final DiscoverySettings discoverySettings;
    protected final ZenPing zenPing;
    private final MasterFaultDetection masterFD;
    private final NodesFaultDetection nodesFD;
    private final PublishClusterStateAction publishClusterState;
    private final MembershipAction membership;
    private final TimeValue pingTimeout;
    private final TimeValue joinTimeout;
    private final int joinRetryAttempts;
    private final TimeValue joinRetryDelay;
    private final int maxPingsFromAnotherMaster;
    private final boolean sendLeaveRequest;
    private final ElectMasterService electMaster;
    private final boolean masterElectionIgnoreNonMasters;
    private final TimeValue masterElectionWaitForJoinsTimeout;
    private final JoinThreadControl joinThreadControl;
    private volatile NodeJoinController nodeJoinController;
    private volatile NodeRemovalClusterStateTaskExecutor nodeRemovalExecutor;

    public ZenDiscovery(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, UnicastHostsProvider hostsProvider) {
        super(settings);
        this.clusterService = clusterService;
        this.clusterName = clusterService.getClusterName();
        this.transportService = transportService;
        this.discoverySettings = new DiscoverySettings(settings, clusterService.getClusterSettings());
        this.zenPing = this.newZenPing(settings, threadPool, transportService, hostsProvider);
        this.electMaster = new ElectMasterService(settings);
        this.pingTimeout = PING_TIMEOUT_SETTING.get(settings);
        this.joinTimeout = JOIN_TIMEOUT_SETTING.get(settings);
        this.joinRetryAttempts = JOIN_RETRY_ATTEMPTS_SETTING.get(settings);
        this.joinRetryDelay = JOIN_RETRY_DELAY_SETTING.get(settings);
        this.maxPingsFromAnotherMaster = MAX_PINGS_FROM_ANOTHER_MASTER_SETTING.get(settings);
        this.sendLeaveRequest = SEND_LEAVE_REQUEST_SETTING.get(settings);
        this.masterElectionIgnoreNonMasters = MASTER_ELECTION_IGNORE_NON_MASTER_PINGS_SETTING.get(settings);
        this.masterElectionWaitForJoinsTimeout = MASTER_ELECTION_WAIT_FOR_JOINS_TIMEOUT_SETTING.get(settings);
        this.logger.debug("using ping_timeout [{}], join.timeout [{}], master_election.ignore_non_master [{}]", (Object)this.pingTimeout, (Object)this.joinTimeout, (Object)this.masterElectionIgnoreNonMasters);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING, this::handleMinimumMasterNodesChanged, value -> {
            ClusterState clusterState = clusterService.state();
            int masterNodes = clusterState.nodes().getMasterNodes().size();
            if (value > masterNodes) {
                throw new IllegalArgumentException("cannot set " + ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey() + " to more than the current master nodes count [" + masterNodes + "]");
            }
        });
        this.masterFD = new MasterFaultDetection(settings, threadPool, transportService, clusterService);
        this.masterFD.addListener(new MasterNodeFailureListener());
        this.nodesFD = new NodesFaultDetection(settings, threadPool, transportService, clusterService.getClusterName());
        this.nodesFD.addListener(new NodeFaultDetectionListener());
        this.publishClusterState = new PublishClusterStateAction(settings, transportService, clusterService::state, new NewPendingClusterStateListener(), this.discoverySettings, clusterService.getClusterName());
        this.membership = new MembershipAction(settings, transportService, this, new MembershipListener());
        this.joinThreadControl = new JoinThreadControl(threadPool);
        transportService.registerRequestHandler(DISCOVERY_REJOIN_ACTION_NAME, RejoinClusterRequest::new, "same", new RejoinClusterRequestHandler());
    }

    protected ZenPing newZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, UnicastHostsProvider hostsProvider) {
        return new UnicastZenPing(settings, threadPool, transportService, hostsProvider);
    }

    @Override
    public void setAllocationService(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    protected void doStart() {
        this.nodesFD.setLocalNode(this.clusterService.localNode());
        this.joinThreadControl.start();
        this.zenPing.start(this);
        this.nodeJoinController = new NodeJoinController(this.clusterService, this.allocationService, this.electMaster, this.discoverySettings, this.settings);
        this.nodeRemovalExecutor = new NodeRemovalClusterStateTaskExecutor(this.allocationService, this.electMaster, this::rejoin, this.logger);
    }

    @Override
    public void startInitialJoin() {
        this.clusterService.submitStateUpdateTask("initial_join", new ClusterStateUpdateTask(){

            @Override
            public boolean runOnlyOnMaster() {
                return false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ZenDiscovery.this.joinThreadControl.startNewThreadIfNotRunning();
                return currentState;
            }

            @Override
            public void onFailure(String source, @org.elasticsearch.common.Nullable Exception e) {
                ZenDiscovery.this.logger.warn("failed to start initial join process", (Throwable)e);
            }
        });
    }

    @Override
    protected void doStop() {
        this.joinThreadControl.stop();
        this.masterFD.stop("zen disco stop");
        this.nodesFD.stop();
        Releasables.close(this.zenPing);
        DiscoveryNodes nodes = this.nodes();
        if (this.sendLeaveRequest && nodes.getMasterNode() != null) {
            if (!nodes.isLocalNodeElectedMaster()) {
                try {
                    this.membership.sendLeaveRequestBlocking(nodes.getMasterNode(), nodes.getLocalNode(), TimeValue.timeValueSeconds(1L));
                }
                catch (Exception e) {
                    this.logger.debug(() -> new ParameterizedMessage("failed to send leave request to master [{}]", (Object)nodes.getMasterNode()), (Throwable)e);
                }
            } else {
                DiscoveryNode[] possibleMasters;
                for (DiscoveryNode possibleMaster : possibleMasters = this.electMaster.nextPossibleMasters(nodes.getNodes().values(), 5)) {
                    if (nodes.getLocalNode().equals(possibleMaster)) continue;
                    try {
                        this.membership.sendLeaveRequest(nodes.getLocalNode(), possibleMaster);
                    }
                    catch (Exception e) {
                        this.logger.debug(() -> new ParameterizedMessage("failed to send leave request from master [{}] to possible master [{}]", (Object)nodes.getMasterNode(), (Object)possibleMaster), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected void doClose() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.masterFD, this.nodesFD});
    }

    @Override
    public DiscoveryNode localNode() {
        return this.clusterService.localNode();
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.clusterService.localNode().getId();
    }

    @Override
    public DiscoveryNodes nodes() {
        return this.clusterService.state().nodes();
    }

    @Override
    public ClusterState clusterState() {
        return this.clusterService.state();
    }

    @Override
    public void publish(ClusterChangedEvent clusterChangedEvent, Discovery.AckListener ackListener) {
        if (!clusterChangedEvent.state().getNodes().isLocalNodeElectedMaster()) {
            throw new IllegalStateException("Shouldn't publish state when not master");
        }
        try {
            this.publishClusterState.publish(clusterChangedEvent, this.electMaster.minimumMasterNodes(), ackListener);
        }
        catch (Discovery.FailedToCommitClusterStateException t) {
            this.logger.debug("failed to publish cluster state version [{}] (not enough nodes acknowledged, min master nodes [{}])", (Object)clusterChangedEvent.state().version(), (Object)this.electMaster.minimumMasterNodes());
            this.clusterService.submitStateUpdateTask("zen-disco-failed-to-publish", new ClusterStateUpdateTask(Priority.IMMEDIATE){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return ZenDiscovery.this.rejoin(currentState, "failed to publish to min_master_nodes");
                }

                @Override
                public void onFailure(String source, Exception e) {
                    ZenDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                }
            });
            throw t;
        }
        this.nodesFD.updateNodesAndPing(clusterChangedEvent.state());
        this.publishClusterState.pendingStatesQueue().failAllStatesAndClear(new ElasticsearchException("elected as master", new Object[0]));
    }

    public Set<DiscoveryNode> getFaultDetectionNodes() {
        return this.nodesFD.getNodes();
    }

    @Override
    public DiscoveryStats stats() {
        PendingClusterStateStats queueStats = this.publishClusterState.pendingStatesQueue().stats();
        return new DiscoveryStats(queueStats);
    }

    @Override
    public DiscoverySettings getDiscoverySettings() {
        return this.discoverySettings;
    }

    @Override
    public int getMinimumMasterNodes() {
        return this.electMaster.minimumMasterNodes();
    }

    public boolean joiningCluster() {
        return this.joinThreadControl.joinThreadActive();
    }

    public ClusterState[] pendingClusterStates() {
        return this.publishClusterState.pendingStatesQueue().pendingClusterStates();
    }

    PendingClusterStatesQueue pendingClusterStatesQueue() {
        return this.publishClusterState.pendingStatesQueue();
    }

    private void innerJoinCluster() {
        DiscoveryNode masterNode = null;
        final Thread currentThread = Thread.currentThread();
        this.nodeJoinController.startElectionContext();
        while (masterNode == null && this.joinThreadControl.joinThreadActive(currentThread)) {
            masterNode = this.findMaster();
        }
        if (!this.joinThreadControl.joinThreadActive(currentThread)) {
            this.logger.trace("thread is no longer in currentJoinThread. Stopping.");
            return;
        }
        if (this.clusterService.localNode().equals(masterNode)) {
            int requiredJoins = Math.max(0, this.electMaster.minimumMasterNodes() - 1);
            this.logger.debug("elected as master, waiting for incoming joins ([{}] needed)", (Object)requiredJoins);
            this.nodeJoinController.waitToBeElectedAsMaster(requiredJoins, this.masterElectionWaitForJoinsTimeout, new NodeJoinController.ElectionCallback(){

                @Override
                public void onElectedAsMaster(ClusterState state) {
                    ZenDiscovery.this.joinThreadControl.markThreadAsDone(currentThread);
                    ZenDiscovery.this.nodesFD.updateNodesAndPing(state);
                }

                @Override
                public void onFailure(Throwable t) {
                    ZenDiscovery.this.logger.trace("failed while waiting for nodes to join, rejoining", t);
                    ZenDiscovery.this.joinThreadControl.markThreadAsDoneAndStartNew(currentThread);
                }
            });
        } else {
            this.nodeJoinController.stopElectionContext(masterNode + " elected");
            final boolean success = this.joinElectedMaster(masterNode);
            final DiscoveryNode finalMasterNode = masterNode;
            this.clusterService.submitStateUpdateTask("finalize_join (" + masterNode + ")", new ClusterStateUpdateTask(){

                @Override
                public boolean runOnlyOnMaster() {
                    return false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    if (!success) {
                        ZenDiscovery.this.joinThreadControl.markThreadAsDoneAndStartNew(currentThread);
                        return currentState;
                    }
                    if (currentState.getNodes().getMasterNode() == null) {
                        ZenDiscovery.this.logger.debug("no master node is set, despite of join request completing. retrying pings.");
                        ZenDiscovery.this.joinThreadControl.markThreadAsDoneAndStartNew(currentThread);
                        return currentState;
                    }
                    if (!currentState.getNodes().getMasterNode().equals(finalMasterNode)) {
                        return ZenDiscovery.this.joinThreadControl.stopRunningThreadAndRejoin(currentState, "master_switched_while_finalizing_join");
                    }
                    ZenDiscovery.this.joinThreadControl.markThreadAsDone(currentThread);
                    return currentState;
                }

                @Override
                public void onFailure(String source, @Nullable Exception e) {
                    ZenDiscovery.this.logger.error("unexpected error while trying to finalize cluster join", (Throwable)e);
                    ZenDiscovery.this.joinThreadControl.markThreadAsDoneAndStartNew(currentThread);
                }
            });
        }
    }

    private boolean joinElectedMaster(DiscoveryNode masterNode) {
        try {
            this.transportService.connectToNode(masterNode);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("failed to connect to master [{}], retrying...", (Object)masterNode), (Throwable)e);
            return false;
        }
        int joinAttempt = 0;
        while (true) {
            try {
                this.logger.trace("joining master {}", (Object)masterNode);
                this.membership.sendJoinRequestBlocking(masterNode, this.clusterService.localNode(), this.joinTimeout);
                return true;
            }
            catch (Exception e) {
                Throwable unwrap = ExceptionsHelper.unwrapCause(e);
                if (unwrap instanceof NotMasterException) {
                    if (++joinAttempt == this.joinRetryAttempts) {
                        this.logger.info("failed to send join request to master [{}], reason [{}], tried [{}] times", (Object)masterNode, (Object)ExceptionsHelper.detailedMessage(e), (Object)joinAttempt);
                        return false;
                    }
                } else {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace(() -> new ParameterizedMessage("failed to send join request to master [{}]", (Object)masterNode), (Throwable)e);
                    } else {
                        this.logger.info("failed to send join request to master [{}], reason [{}]", (Object)masterNode, (Object)ExceptionsHelper.detailedMessage(e));
                    }
                    return false;
                }
                this.logger.trace("master {} failed with [{}]. retrying... (attempts done: [{}])", (Object)masterNode, (Object)ExceptionsHelper.detailedMessage(e), (Object)joinAttempt);
                try {
                    Thread.sleep(this.joinRetryDelay.millis());
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }

    private void removeNode(DiscoveryNode node, String source, String reason) {
        this.clusterService.submitStateUpdateTask(source + "(" + node + "), reason(" + reason + ")", new NodeRemovalClusterStateTaskExecutor.Task(node, reason), ClusterStateTaskConfig.build(Priority.IMMEDIATE), this.nodeRemovalExecutor, this.nodeRemovalExecutor);
    }

    private void handleLeaveRequest(DiscoveryNode node) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (this.localNodeMaster()) {
            this.removeNode(node, "zen-disco-node-left", "left");
        } else if (node.equals(this.nodes().getMasterNode())) {
            this.handleMasterGone(node, null, "shut_down");
        }
    }

    private void handleNodeFailure(DiscoveryNode node, String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (!this.localNodeMaster()) {
            return;
        }
        this.removeNode(node, "zen-disco-node-failed", reason);
    }

    private void handleMinimumMasterNodesChanged(final int minimumMasterNodes) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        final int prevMinimumMasterNode = this.electMaster.minimumMasterNodes();
        this.electMaster.minimumMasterNodes(minimumMasterNodes);
        if (!this.localNodeMaster()) {
            return;
        }
        this.clusterService.submitStateUpdateTask("zen-disco-mini-master-nodes-changed", new ClusterStateUpdateTask(Priority.IMMEDIATE){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (!ZenDiscovery.this.electMaster.hasEnoughMasterNodes(currentState.nodes())) {
                    return ZenDiscovery.this.rejoin(currentState, "not enough master nodes on change of minimum_master_nodes from [" + prevMinimumMasterNode + "] to [" + minimumMasterNodes + "]");
                }
                return currentState;
            }

            @Override
            public void onNoLongerMaster(String source) {
            }

            @Override
            public void onFailure(String source, Exception e) {
                ZenDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ZenDiscovery.this.electMaster.logMinimumMasterNodesWarningIfNecessary(oldState, newState);
            }
        });
    }

    private void handleMasterGone(final DiscoveryNode masterNode, Throwable cause, final String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (this.localNodeMaster()) {
            return;
        }
        this.logger.info(() -> new ParameterizedMessage("master_left [{}], reason [{}]", (Object)masterNode, (Object)reason), cause);
        this.clusterService.submitStateUpdateTask("master_failed (" + masterNode + ")", new ClusterStateUpdateTask(Priority.IMMEDIATE){

            @Override
            public boolean runOnlyOnMaster() {
                return false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (!masterNode.equals(currentState.nodes().getMasterNode())) {
                    return currentState;
                }
                DiscoveryNodes discoveryNodes = DiscoveryNodes.builder(currentState.nodes()).remove(masterNode).masterNodeId(null).build();
                ZenDiscovery.this.publishClusterState.pendingStatesQueue().failAllStatesAndClear(new ElasticsearchException("master left [{}]", reason));
                return ZenDiscovery.this.rejoin(ClusterState.builder(currentState).nodes(discoveryNodes).build(), "master left (reason = " + reason + ")");
            }

            @Override
            public void onFailure(String source, Exception e) {
                ZenDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }

    void processNextPendingClusterState(String reason) {
        this.clusterService.submitStateUpdateTask("zen-disco-receive(from master [" + reason + "])", new ClusterStateUpdateTask(Priority.URGENT){
            ClusterState newClusterState;
            {
                this.newClusterState = null;
            }

            @Override
            public boolean runOnlyOnMaster() {
                return false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                this.newClusterState = ZenDiscovery.this.publishClusterState.pendingStatesQueue().getNextClusterStateToProcess();
                if (this.newClusterState == null) {
                    return currentState;
                }
                assert (this.newClusterState.nodes().getMasterNode() != null) : "received a cluster state without a master";
                assert (!this.newClusterState.blocks().hasGlobalBlock(ZenDiscovery.this.discoverySettings.getNoMasterBlock())) : "received a cluster state with a master block";
                if (currentState.nodes().isLocalNodeElectedMaster()) {
                    return ZenDiscovery.this.handleAnotherMaster(currentState, this.newClusterState.nodes().getMasterNode(), this.newClusterState.version(), "via a new cluster state");
                }
                if (ZenDiscovery.shouldIgnoreOrRejectNewClusterState(ZenDiscovery.this.logger, currentState, this.newClusterState)) {
                    return currentState;
                }
                if (ZenDiscovery.this.masterFD.masterNode() == null || !ZenDiscovery.this.masterFD.masterNode().equals(this.newClusterState.nodes().getMasterNode())) {
                    ZenDiscovery.this.masterFD.restart(this.newClusterState.nodes().getMasterNode(), "new cluster state received and we are monitoring the wrong master [" + ZenDiscovery.this.masterFD.masterNode() + "]");
                }
                if (currentState.blocks().hasGlobalBlock(ZenDiscovery.this.discoverySettings.getNoMasterBlock())) {
                    ZenDiscovery.this.logger.debug("got first state from fresh master [{}]", (Object)this.newClusterState.nodes().getMasterNodeId());
                    return this.newClusterState;
                }
                ClusterState.Builder builder = ClusterState.builder(this.newClusterState);
                if (this.newClusterState.routingTable().version() == currentState.routingTable().version()) {
                    builder.routingTable(currentState.routingTable());
                }
                if (this.newClusterState.metaData().version() == currentState.metaData().version()) {
                    builder.metaData(currentState.metaData());
                } else {
                    MetaData.Builder metaDataBuilder = MetaData.builder(this.newClusterState.metaData()).removeAllIndices();
                    for (IndexMetaData indexMetaData : this.newClusterState.metaData()) {
                        IndexMetaData currentIndexMetaData = currentState.metaData().index(indexMetaData.getIndex());
                        if (currentIndexMetaData != null && currentIndexMetaData.isSameUUID(indexMetaData.getIndexUUID()) && currentIndexMetaData.getVersion() == indexMetaData.getVersion()) {
                            metaDataBuilder.put(currentIndexMetaData, false);
                            continue;
                        }
                        metaDataBuilder.put(indexMetaData, false);
                    }
                    builder.metaData(metaDataBuilder);
                }
                return builder.build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                ZenDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                if (this.newClusterState != null) {
                    try {
                        ZenDiscovery.this.publishClusterState.pendingStatesQueue().markAsFailed(this.newClusterState, e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        ZenDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected exception while failing [{}]", (Object)source), (Throwable)inner);
                    }
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                try {
                    if (this.newClusterState != null) {
                        ZenDiscovery.this.publishClusterState.pendingStatesQueue().markAsProcessed(this.newClusterState);
                    }
                }
                catch (Exception e) {
                    this.onFailure(source, e);
                }
            }
        });
    }

    public static boolean shouldIgnoreOrRejectNewClusterState(Logger logger, ClusterState currentState, ClusterState newClusterState) {
        ZenDiscovery.validateStateIsFromCurrentMaster(logger, currentState.nodes(), newClusterState);
        if (currentState.supersedes(newClusterState) || newClusterState.nodes().getMasterNodeId().equals(currentState.nodes().getMasterNodeId()) && currentState.version() == newClusterState.version()) {
            logger.debug("received a cluster state that is not newer than the current one, ignoring (received {}, current {})", (Object)newClusterState.version(), (Object)currentState.version());
            return true;
        }
        if (currentState.nodes().getMasterNodeId() != null && newClusterState.version() < currentState.version()) {
            logger.debug("received a cluster state that has a lower version than the current one, ignoring (received {}, current {})", (Object)newClusterState.version(), (Object)currentState.version());
            return true;
        }
        return false;
    }

    public static void validateStateIsFromCurrentMaster(Logger logger, DiscoveryNodes currentNodes, ClusterState newClusterState) {
        if (currentNodes.getMasterNodeId() == null) {
            return;
        }
        if (!currentNodes.getMasterNodeId().equals(newClusterState.nodes().getMasterNodeId())) {
            logger.warn("received a cluster state from a different master than the current one, rejecting (received {}, current {})", (Object)newClusterState.nodes().getMasterNode(), (Object)currentNodes.getMasterNode());
            throw new IllegalStateException("cluster state from a different master than the current one, rejecting (received " + newClusterState.nodes().getMasterNode() + ", current " + currentNodes.getMasterNode() + ")");
        }
    }

    void handleJoinRequest(DiscoveryNode node, ClusterState state, MembershipAction.JoinCallback callback) {
        if (!this.transportService.addressSupported(node.getAddress().getClass())) {
            this.logger.warn("received a wrong address type from [{}], ignoring...", (Object)node);
        } else {
            if (this.nodeJoinController == null) {
                throw new IllegalStateException("discovery module is not yet started");
            }
            this.transportService.connectToNode(node);
            try {
                this.membership.sendValidateJoinRequestBlocking(node, state, this.joinTimeout);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to validate incoming join request from node [{}]", (Object)node), (Throwable)e);
                callback.onFailure(new IllegalStateException("failure when sending a validation request to node", e));
                return;
            }
            this.nodeJoinController.handleJoinRequest(node, callback);
        }
    }

    private DiscoveryNode findMaster() {
        this.logger.trace("starting to ping");
        List<ZenPing.PingResponse> fullPingResponses = this.pingAndWait(this.pingTimeout).toList();
        if (fullPingResponses == null) {
            this.logger.trace("No full ping responses");
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (fullPingResponses.size() == 0) {
                sb.append(" {none}");
            } else {
                for (ZenPing.PingResponse pingResponse : fullPingResponses) {
                    sb.append("\n\t--> ").append(pingResponse);
                }
            }
            this.logger.trace("full ping responses:{}", (Object)sb);
        }
        DiscoveryNode localNode = this.clusterService.localNode();
        assert (!fullPingResponses.stream().map(ZenPing.PingResponse::node).filter(n -> n.equals(localNode)).findAny().isPresent());
        fullPingResponses.add(new ZenPing.PingResponse(localNode, null, this.clusterService.state()));
        List<ZenPing.PingResponse> pingResponses = ZenDiscovery.filterPingResponses(fullPingResponses, this.masterElectionIgnoreNonMasters, this.logger);
        ArrayList<DiscoveryNode> activeMasters = new ArrayList<DiscoveryNode>();
        for (ZenPing.PingResponse pingResponse : pingResponses) {
            if (pingResponse.master() == null || localNode.equals(pingResponse.master())) continue;
            activeMasters.add(pingResponse.master());
        }
        ArrayList<ElectMasterService.MasterCandidate> masterCandidates = new ArrayList<ElectMasterService.MasterCandidate>();
        for (ZenPing.PingResponse pingResponse : pingResponses) {
            if (!pingResponse.node().isMasterNode()) continue;
            masterCandidates.add(new ElectMasterService.MasterCandidate(pingResponse.node(), pingResponse.getClusterStateVersion()));
        }
        if (activeMasters.isEmpty()) {
            if (this.electMaster.hasEnoughCandidates(masterCandidates)) {
                ElectMasterService.MasterCandidate masterCandidate = this.electMaster.electMaster(masterCandidates);
                this.logger.trace("candidate {} won election", (Object)masterCandidate);
                return masterCandidate.getNode();
            }
            this.logger.trace("not enough master nodes [{}]", masterCandidates);
            return null;
        }
        assert (!activeMasters.contains(localNode)) : "local node should never be elected as master when other nodes indicate an active master";
        return this.electMaster.tieBreakActiveMasters(activeMasters);
    }

    static List<ZenPing.PingResponse> filterPingResponses(List<ZenPing.PingResponse> fullPingResponses, boolean masterElectionIgnoreNonMasters, Logger logger) {
        List<ZenPing.PingResponse> pingResponses = masterElectionIgnoreNonMasters ? fullPingResponses.stream().filter(ping -> ping.node().isMasterNode()).collect(Collectors.toList()) : fullPingResponses;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (pingResponses.isEmpty()) {
                sb.append(" {none}");
            } else {
                for (ZenPing.PingResponse pingResponse : pingResponses) {
                    sb.append("\n\t--> ").append(pingResponse);
                }
            }
            logger.debug("filtered ping responses: (ignore_non_masters [{}]){}", (Object)masterElectionIgnoreNonMasters, (Object)sb);
        }
        return pingResponses;
    }

    protected ClusterState rejoin(ClusterState clusterState, String reason) {
        assert (Thread.currentThread().getName().contains("clusterService#updateTask"));
        this.logger.warn("{}, current nodes: {}", (Object)reason, (Object)clusterState.nodes());
        this.nodesFD.stop();
        this.masterFD.stop(reason);
        ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(clusterState.blocks()).addGlobalBlock(this.discoverySettings.getNoMasterBlock()).build();
        DiscoveryNodes discoveryNodes = new DiscoveryNodes.Builder(clusterState.nodes()).masterNodeId(null).build();
        this.joinThreadControl.startNewThreadIfNotRunning();
        return ClusterState.builder(clusterState).blocks(clusterBlocks).nodes(discoveryNodes).build();
    }

    private boolean localNodeMaster() {
        return this.nodes().isLocalNodeElectedMaster();
    }

    private ClusterState handleAnotherMaster(ClusterState localClusterState, final DiscoveryNode otherMaster, long otherClusterStateVersion, String reason) {
        assert (localClusterState.nodes().isLocalNodeElectedMaster()) : "handleAnotherMaster called but current node is not a master";
        assert (Thread.currentThread().getName().contains("clusterService#updateTask")) : "not called from the cluster state update thread";
        if (otherClusterStateVersion > localClusterState.version()) {
            return this.rejoin(localClusterState, "zen-disco-discovered another master with a new cluster_state [" + otherMaster + "][" + reason + "]");
        }
        this.logger.warn("discovered [{}] which is also master but with an older cluster_state, telling [{}] to rejoin the cluster ([{}])", (Object)otherMaster, (Object)otherMaster, (Object)reason);
        try {
            this.transportService.connectToNode(otherMaster);
            this.transportService.sendRequest(otherMaster, DISCOVERY_REJOIN_ACTION_NAME, new RejoinClusterRequest(localClusterState.nodes().getLocalNodeId()), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    ZenDiscovery.this.logger.warn(() -> new ParameterizedMessage("failed to send rejoin request to [{}]", (Object)otherMaster), (Throwable)exp);
                }
            });
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("failed to send rejoin request to [{}]", (Object)otherMaster), (Throwable)e);
        }
        return localClusterState;
    }

    private ZenPing.PingCollection pingAndWait(TimeValue timeout) {
        ZenPing.PingCollection response = new ZenPing.PingCollection();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.zenPing.ping(pings -> {
                response.addPings(pings);
                latch.countDown();
            }, timeout);
        }
        catch (Exception ex) {
            this.logger.warn("Ping execution failed", (Throwable)ex);
            latch.countDown();
        }
        try {
            latch.await();
            return response;
        }
        catch (InterruptedException e) {
            this.logger.trace("pingAndWait interrupted");
            return response;
        }
    }

    private class JoinThreadControl {
        private final ThreadPool threadPool;
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final AtomicReference<Thread> currentJoinThread = new AtomicReference();

        public JoinThreadControl(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public boolean joinThreadActive() {
            Thread currentThread = this.currentJoinThread.get();
            return this.running.get() && currentThread != null && currentThread.isAlive();
        }

        public boolean joinThreadActive(Thread joinThread) {
            return this.running.get() && joinThread.equals(this.currentJoinThread.get());
        }

        public ClusterState stopRunningThreadAndRejoin(ClusterState clusterState, String reason) {
            ClusterService.assertClusterStateThread();
            this.currentJoinThread.set(null);
            return ZenDiscovery.this.rejoin(clusterState, reason);
        }

        public void startNewThreadIfNotRunning() {
            ClusterService.assertClusterStateThread();
            if (this.joinThreadActive()) {
                return;
            }
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    if (!JoinThreadControl.this.currentJoinThread.compareAndSet(null, currentThread)) {
                        return;
                    }
                    while (JoinThreadControl.this.running.get() && JoinThreadControl.this.joinThreadActive(currentThread)) {
                        try {
                            ZenDiscovery.this.innerJoinCluster();
                            return;
                        }
                        catch (Exception e) {
                            ZenDiscovery.this.logger.error("unexpected error while joining cluster, trying again", (Throwable)e);
                            assert (ExceptionsHelper.reThrowIfNotNull(e));
                        }
                    }
                }
            });
        }

        public void markThreadAsDoneAndStartNew(Thread joinThread) {
            ClusterService.assertClusterStateThread();
            if (!this.markThreadAsDone(joinThread)) {
                return;
            }
            this.startNewThreadIfNotRunning();
        }

        public boolean markThreadAsDone(Thread joinThread) {
            ClusterService.assertClusterStateThread();
            return this.currentJoinThread.compareAndSet(joinThread, null);
        }

        public void stop() {
            this.running.set(false);
            Thread joinThread = this.currentJoinThread.getAndSet(null);
            if (joinThread != null) {
                joinThread.interrupt();
            }
        }

        public void start() {
            this.running.set(true);
        }
    }

    class RejoinClusterRequestHandler
    implements TransportRequestHandler<RejoinClusterRequest> {
        RejoinClusterRequestHandler() {
        }

        @Override
        public void messageReceived(final RejoinClusterRequest request, final TransportChannel channel) throws Exception {
            ZenDiscovery.this.clusterService.submitStateUpdateTask("received a request to rejoin the cluster from [" + request.fromNodeId + "]", new ClusterStateUpdateTask(Priority.IMMEDIATE){

                @Override
                public boolean runOnlyOnMaster() {
                    return false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    try {
                        channel.sendResponse(TransportResponse.Empty.INSTANCE);
                    }
                    catch (Exception e) {
                        ZenDiscovery.this.logger.warn("failed to send response on rejoin cluster request handling", (Throwable)e);
                    }
                    return ZenDiscovery.this.rejoin(currentState, "received a request to rejoin the cluster from [" + request.fromNodeId + "]");
                }

                @Override
                public void onFailure(String source, Exception e) {
                    ZenDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                }
            });
        }
    }

    public static class RejoinClusterRequest
    extends TransportRequest {
        private String fromNodeId;

        RejoinClusterRequest(String fromNodeId) {
            this.fromNodeId = fromNodeId;
        }

        public RejoinClusterRequest() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.fromNodeId = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.fromNodeId);
        }
    }

    private class MasterNodeFailureListener
    implements MasterFaultDetection.Listener {
        private MasterNodeFailureListener() {
        }

        @Override
        public void onMasterFailure(DiscoveryNode masterNode, Throwable cause, String reason) {
            ZenDiscovery.this.handleMasterGone(masterNode, cause, reason);
        }
    }

    private class NodeFaultDetectionListener
    extends NodesFaultDetection.Listener {
        private final AtomicInteger pingsWhileMaster = new AtomicInteger(0);

        private NodeFaultDetectionListener() {
        }

        @Override
        public void onNodeFailure(DiscoveryNode node, String reason) {
            ZenDiscovery.this.handleNodeFailure(node, reason);
        }

        @Override
        public void onPingReceived(final NodesFaultDetection.PingRequest pingRequest) {
            if (!ZenDiscovery.this.localNodeMaster()) {
                this.pingsWhileMaster.set(0);
                return;
            }
            if (this.pingsWhileMaster.incrementAndGet() < ZenDiscovery.this.maxPingsFromAnotherMaster) {
                ZenDiscovery.this.logger.trace("got a ping from another master {}. current ping count: [{}]", (Object)pingRequest.masterNode(), (Object)this.pingsWhileMaster.get());
                return;
            }
            ZenDiscovery.this.logger.debug("got a ping from another master {}. resolving who should rejoin. current ping count: [{}]", (Object)pingRequest.masterNode(), (Object)this.pingsWhileMaster.get());
            ZenDiscovery.this.clusterService.submitStateUpdateTask("ping from another master", new ClusterStateUpdateTask(Priority.IMMEDIATE){

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    NodeFaultDetectionListener.this.pingsWhileMaster.set(0);
                    return ZenDiscovery.this.handleAnotherMaster(currentState, pingRequest.masterNode(), pingRequest.clusterStateVersion(), "node fd ping");
                }

                @Override
                public void onFailure(String source, Exception e) {
                    ZenDiscovery.this.logger.debug("unexpected error during cluster state update task after pings from another master", (Throwable)e);
                }
            });
        }
    }

    private class MembershipListener
    implements MembershipAction.MembershipListener {
        private MembershipListener() {
        }

        @Override
        public void onJoin(DiscoveryNode node, MembershipAction.JoinCallback callback) {
            ZenDiscovery.this.handleJoinRequest(node, ZenDiscovery.this.clusterService.state(), callback);
        }

        @Override
        public void onLeave(DiscoveryNode node) {
            ZenDiscovery.this.handleLeaveRequest(node);
        }
    }

    private class NewPendingClusterStateListener
    implements PublishClusterStateAction.NewPendingClusterStateListener {
        private NewPendingClusterStateListener() {
        }

        @Override
        public void onNewClusterState(String reason) {
            ZenDiscovery.this.processNextPendingClusterState(reason);
        }
    }

    static class NodeRemovalClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        private final AllocationService allocationService;
        private final ElectMasterService electMasterService;
        private final BiFunction<ClusterState, String, ClusterState> rejoin;
        private final Logger logger;

        NodeRemovalClusterStateTaskExecutor(AllocationService allocationService, ElectMasterService electMasterService, BiFunction<ClusterState, String, ClusterState> rejoin, Logger logger) {
            this.allocationService = allocationService;
            this.electMasterService = electMasterService;
            this.rejoin = rejoin;
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.BatchResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
            DiscoveryNodes.Builder remainingNodesBuilder = DiscoveryNodes.builder(currentState.nodes());
            boolean removed = false;
            for (Task task : tasks) {
                if (currentState.nodes().nodeExists(task.node())) {
                    remainingNodesBuilder.remove(task.node());
                    removed = true;
                    continue;
                }
                this.logger.debug("node [{}] does not exist in cluster state, ignoring", (Object)task);
            }
            if (!removed) {
                return ClusterStateTaskExecutor.BatchResult.builder().successes(tasks).build(currentState);
            }
            ClusterState remainingNodesClusterState = this.remainingNodesClusterState(currentState, remainingNodesBuilder);
            ClusterStateTaskExecutor.BatchResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.BatchResult.builder().successes(tasks);
            if (!this.electMasterService.hasEnoughMasterNodes(remainingNodesClusterState.nodes())) {
                return resultBuilder.build(this.rejoin.apply(remainingNodesClusterState, "not enough master nodes"));
            }
            return resultBuilder.build(this.allocationService.deassociateDeadNodes(remainingNodesClusterState, true, this.describeTasks(tasks)));
        }

        ClusterState remainingNodesClusterState(ClusterState currentState, DiscoveryNodes.Builder remainingNodesBuilder) {
            return ClusterState.builder(currentState).nodes(remainingNodesBuilder).build();
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            this.logger.debug("no longer master while processing node removal [{}]", (Object)source);
        }

        static class Task {
            private final DiscoveryNode node;
            private final String reason;

            public Task(DiscoveryNode node, String reason) {
                this.node = node;
                this.reason = reason;
            }

            public DiscoveryNode node() {
                return this.node;
            }

            public String reason() {
                return this.reason;
            }

            public String toString() {
                return this.node + " " + this.reason;
            }
        }
    }
}

