#ifndef _EFL_PACK_LAYOUT_EO_H_
#define _EFL_PACK_LAYOUT_EO_H_

#ifndef _EFL_PACK_LAYOUT_EO_CLASS_TYPE
#define _EFL_PACK_LAYOUT_EO_CLASS_TYPE

typedef Eo Efl_Pack_Layout;

#endif

#ifndef _EFL_PACK_LAYOUT_EO_TYPES
#define _EFL_PACK_LAYOUT_EO_TYPES


#endif
/**
 * @brief Low-level APIs for object that can lay their children out.
 *
 * Used for containers (box, grid).
 *
 * @ingroup Efl_Pack_Layout
 */
#define EFL_PACK_LAYOUT_INTERFACE efl_pack_layout_interface_get()

EWAPI const Eo_Class *efl_pack_layout_interface_get(void);

/**
 * @brief Implementation of this container's layout algorithm.
 *
 * The default value is the same as the widget class.
 *
 * @param[out] engine Must be an @c Efl.Pack.Layout subclass.
 * @param[out] data Any data to pass along to @c Efl.Pack.Layout.layout_do.
 * Owned by the caller. Depends on the layout engine.
 *
 * @ingroup Efl_Pack_Layout
 */
EOAPI void efl_pack_layout_engine_get(const Eo *obj, const Eo_Base **engine, const void **data);

/**
 * @brief Implementation of this container's layout algorithm.
 *
 * The default value is the same as the widget class.
 *
 * @param[in] engine Must be an @c Efl.Pack.Layout subclass.
 * @param[in] data Any data to pass along to @c Efl.Pack.Layout.layout_do.
 * Owned by the caller. Depends on the layout engine.
 *
 * @ingroup Efl_Pack_Layout
 */
EOAPI void efl_pack_layout_engine_set(Eo *obj, const Eo_Base *engine, const void *data);

/** Requests EFL to call the @ref efl_pack_layout_update method on this object.
 *
 * @ingroup Efl_Pack_Layout
 */
EOAPI void efl_pack_layout_request(Eo *obj);

#ifdef EFL_PACK_LAYOUT_PROTECTED
/**
 * @brief Implementation of this container's layout algorithm.
 *
 * EFL will call this function whenever the contents of this container need to
 * be re-layed out on the canvas.
 *
 * This can be overriden to implement highly specific layout behaviours.
 *
 * @ingroup Efl_Pack_Layout
 */
EOAPI void efl_pack_layout_update(Eo *obj);
#endif

#ifdef EFL_PACK_LAYOUT_PROTECTED
/**
 * @brief Lay out (resize and move) children objects of @c pack.
 *
 * @param[in] pack The container to lay out.
 * @param[in] data Extra data passed by the caller.
 *
 * @ingroup Efl_Pack_Layout
 */
EOAPI void efl_pack_layout_do(const Eo *obj, Efl_Gfx *pack, const void *data);
#endif


#endif
