/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.DocumentMapper;

public class MappingMetaData
extends AbstractDiffable<MappingMetaData> {
    public static final MappingMetaData PROTO = new MappingMetaData();
    private final String type;
    private final CompressedXContent source;
    private Routing routing;
    private Timestamp timestamp;
    private boolean hasParentField;

    public MappingMetaData(DocumentMapper docMapper) {
        this.type = docMapper.type();
        this.source = docMapper.mappingSource();
        this.routing = new Routing(docMapper.routingFieldMapper().required());
        this.timestamp = new Timestamp(docMapper.timestampFieldMapper().enabled(), docMapper.timestampFieldMapper().fieldType().dateTimeFormatter().format(), docMapper.timestampFieldMapper().defaultTimestamp(), docMapper.timestampFieldMapper().ignoreMissing());
        this.hasParentField = docMapper.parentFieldMapper().active();
    }

    public MappingMetaData(CompressedXContent mapping) throws IOException {
        Map<String, Object> mappingMap;
        this.source = mapping;
        try (XContentParser parser = XContentHelper.createParser(mapping.compressedReference());){
            mappingMap = parser.mapOrdered();
        }
        if (mappingMap.size() != 1) {
            throw new IllegalStateException("Can't derive type from mapping, no root type: " + mapping.string());
        }
        this.type = mappingMap.keySet().iterator().next();
        this.initMappers((Map)mappingMap.get(this.type));
    }

    public MappingMetaData(Map<String, Object> mapping) throws IOException {
        this(mapping.keySet().iterator().next(), mapping);
    }

    public MappingMetaData(String type, Map<String, Object> mapping) throws IOException {
        this.type = type;
        XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().map(mapping);
        this.source = new CompressedXContent(mappingBuilder.bytes());
        Map withoutType = mapping;
        if (mapping.size() == 1 && mapping.containsKey(type)) {
            withoutType = (Map)mapping.get(type);
        }
        this.initMappers(withoutType);
    }

    private MappingMetaData() {
        this.type = "";
        try {
            this.source = new CompressedXContent("{}");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create MappingMetaData prototype", ex);
        }
    }

    private void initMappers(Map<String, Object> withoutType) {
        if (withoutType.containsKey("_routing")) {
            boolean required = false;
            Map routingNode = (Map)withoutType.get("_routing");
            for (Map.Entry entry : routingNode.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("required")) continue;
                required = XContentMapValues.lenientNodeBooleanValue(fieldNode);
            }
            this.routing = new Routing(required);
        } else {
            this.routing = Routing.EMPTY;
        }
        if (withoutType.containsKey("_timestamp")) {
            boolean enabled = false;
            String format = "epoch_millis||strictDateOptionalTime";
            String defaultTimestamp = "now";
            Boolean ignoreMissing = null;
            Map timestampNode = (Map)withoutType.get("_timestamp");
            for (Map.Entry entry : timestampNode.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    enabled = XContentMapValues.lenientNodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("format")) {
                    format = fieldNode.toString();
                    continue;
                }
                if (fieldName.equals("default") && fieldNode != null) {
                    defaultTimestamp = fieldNode.toString();
                    continue;
                }
                if (!fieldName.equals("ignore_missing")) continue;
                ignoreMissing = XContentMapValues.lenientNodeBooleanValue(fieldNode);
            }
            this.timestamp = new Timestamp(enabled, format, defaultTimestamp, ignoreMissing);
        } else {
            this.timestamp = Timestamp.EMPTY;
        }
        this.hasParentField = withoutType.containsKey("_parent");
    }

    public MappingMetaData(String type, CompressedXContent source, Routing routing, Timestamp timestamp, boolean hasParentField) {
        this.type = type;
        this.source = source;
        this.routing = routing;
        this.timestamp = timestamp;
        this.hasParentField = hasParentField;
    }

    void updateDefaultMapping(MappingMetaData defaultMapping) {
        if (this.routing == Routing.EMPTY) {
            this.routing = defaultMapping.routing();
        }
        if (this.timestamp == Timestamp.EMPTY) {
            this.timestamp = defaultMapping.timestamp();
        }
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent source() {
        return this.source;
    }

    public boolean hasParentField() {
        return this.hasParentField;
    }

    public Map<String, Object> sourceAsMap() throws IOException {
        Map mapping = XContentHelper.convertToMap(this.source.compressedReference(), true).v2();
        if (mapping.size() == 1 && mapping.containsKey(this.type())) {
            mapping = (Map)mapping.get(this.type());
        }
        return mapping;
    }

    public Map<String, Object> getSourceAsMap() throws IOException {
        return this.sourceAsMap();
    }

    public Routing routing() {
        return this.routing;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type());
        this.source().writeTo(out);
        out.writeBoolean(this.routing().required());
        out.writeBoolean(this.timestamp().enabled());
        out.writeString(this.timestamp().format());
        out.writeOptionalString(this.timestamp().defaultTimestamp());
        out.writeOptionalBoolean(this.timestamp().ignoreMissing());
        out.writeBoolean(this.hasParentField());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingMetaData that = (MappingMetaData)o;
        if (!this.routing.equals(that.routing)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (!this.timestamp.equals(that.timestamp)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.routing.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        return result;
    }

    @Override
    public MappingMetaData readFrom(StreamInput in) throws IOException {
        String type = in.readString();
        CompressedXContent source = CompressedXContent.readCompressedString(in);
        Routing routing = new Routing(in.readBoolean());
        boolean enabled = in.readBoolean();
        String format = in.readString();
        String defaultTimestamp = in.readOptionalString();
        Boolean ignoreMissing = null;
        ignoreMissing = in.readOptionalBoolean();
        Timestamp timestamp = new Timestamp(enabled, format, defaultTimestamp, ignoreMissing);
        boolean hasParentField = in.readBoolean();
        return new MappingMetaData(type, source, routing, timestamp, hasParentField);
    }

    public static class Timestamp {
        public static final Timestamp EMPTY = new Timestamp(false, "epoch_millis||strictDateOptionalTime", "now", null);
        private final boolean enabled;
        private final String format;
        private final FormatDateTimeFormatter dateTimeFormatter;
        private final String defaultTimestamp;
        private final Boolean ignoreMissing;

        public static String parseStringTimestamp(String timestampAsString, FormatDateTimeFormatter dateTimeFormatter) throws TimestampParsingException {
            try {
                return Long.toString(dateTimeFormatter.parser().parseMillis(timestampAsString));
            }
            catch (RuntimeException e) {
                throw new TimestampParsingException(timestampAsString, e);
            }
        }

        public Timestamp(boolean enabled, String format, String defaultTimestamp, Boolean ignoreMissing) {
            this.enabled = enabled;
            this.format = format;
            this.dateTimeFormatter = Joda.forPattern(format);
            this.defaultTimestamp = defaultTimestamp;
            this.ignoreMissing = ignoreMissing;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public String format() {
            return this.format;
        }

        public String defaultTimestamp() {
            return this.defaultTimestamp;
        }

        public boolean hasDefaultTimestamp() {
            return this.defaultTimestamp != null;
        }

        public Boolean ignoreMissing() {
            return this.ignoreMissing;
        }

        public FormatDateTimeFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timestamp timestamp = (Timestamp)o;
            if (this.enabled != timestamp.enabled) {
                return false;
            }
            if (this.format != null ? !this.format.equals(timestamp.format) : timestamp.format != null) {
                return false;
            }
            if (this.defaultTimestamp != null ? !this.defaultTimestamp.equals(timestamp.defaultTimestamp) : timestamp.defaultTimestamp != null) {
                return false;
            }
            return !(this.ignoreMissing != null ? !this.ignoreMissing.equals(timestamp.ignoreMissing) : timestamp.ignoreMissing != null);
        }

        public int hashCode() {
            int result = this.enabled ? 1 : 0;
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            result = 31 * result + (this.dateTimeFormatter != null ? this.dateTimeFormatter.hashCode() : 0);
            result = 31 * result + (this.defaultTimestamp != null ? this.defaultTimestamp.hashCode() : 0);
            result = 31 * result + (this.ignoreMissing != null ? this.ignoreMissing.hashCode() : 0);
            return result;
        }
    }

    public static class Routing {
        public static final Routing EMPTY = new Routing(false);
        private final boolean required;

        public Routing(boolean required) {
            this.required = required;
        }

        public boolean required() {
            return this.required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Routing routing = (Routing)o;
            return this.required == routing.required;
        }

        public int hashCode() {
            return this.getClass().hashCode() + (this.required ? 1 : 0);
        }
    }
}

