/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ProgressBarDrawData
extends RangeDrawData {
    public ProgressBarDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n = theme.progressHandle;
        int n2 = this.gtk_widget_get_style(n);
        int n3 = gC.getGCData().drawable;
        theme.transferClipping(gC, n2);
        byte[] byArray = Converter.wcsToMbcs(null, "trough", true);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        this.gtk_render_box(n2, n3, this.getStateType(0), 1, null, n, byArray, n4, n5, n6, n7);
        int n8 = OS.gtk_style_get_xthickness(n2);
        int n9 = OS.gtk_style_get_ythickness(n2);
        if ((this.style & 0x200) != 0) {
            this.gtk_orientable_set_orientation(n, 2);
            n4 += n8;
            n6 -= n8 * 2;
            n7 -= n9 * 2;
            n7 = (int)((float)n7 * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
            n5 += rectangle.height - n9 - n7;
        } else {
            this.gtk_orientable_set_orientation(n, 0);
            n4 += n8;
            n5 += n9;
            n6 -= n8 * 2;
            n7 -= n9 * 2;
            n6 = (int)((float)n6 * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
        }
        byArray = Converter.wcsToMbcs(null, "bar", true);
        this.gtk_render_box(n2, n3, 2, 2, null, n, byArray, n4, n5, n6, n7);
    }

    @Override
    int getStateType(int n) {
        return 0;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }

    void gtk_orientable_set_orientation(int n, int n2) {
        if (OS.GTK3) {
            switch (n2) {
                case 2: {
                    OS.gtk_orientable_set_orientation(n, 1);
                    OS.gtk_progress_bar_set_inverted(n, true);
                    break;
                }
                case 0: {
                    OS.gtk_orientable_set_orientation(n, 0);
                    OS.gtk_progress_bar_set_inverted(n, false);
                }
            }
        } else {
            OS.gtk_progress_bar_set_orientation(n, n2);
        }
    }
}

