# From 2.6 to 3.0
*Make sure you view this [upgrade guide from the `master` branch](../../../master/doc/update/2.6-to-3.0.md) for the most up to date instructions.*

## 1. Stop server & resque

    sudo service gitlab stop

## 2. Update code & db


```bash
# Get latest code
git fetch origin
git checkout v3.0.3

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u gitlab -H vim Gemfile

# Install libs
sudo -u gitlab bundle install --without development test postgres

# update db
sudo -u gitlab bundle exec rake db:migrate RAILS_ENV=production

# !!! Config should be replaced with a new one. Check it after replace
cp config/gitlab.yml.example config/gitlab.yml

# update Gitolite hooks

# Gitolite v2:
sudo cp ./lib/hooks/post-receive /home/git/share/gitolite/hooks/common/post-receive
sudo chown git:git /home/git/share/gitolite/hooks/common/post-receive

# Gitolite v3:
sudo cp ./lib/hooks/post-receive /home/git/.gitolite/hooks/common/post-receive
sudo chown git:git /home/git/.gitolite/hooks/common/post-receive

# set valid path to hooks in gitlab.yml in git_host section
# like this
git_host:
  # Gitolite 2
  hooks_path: /home/git/share/gitolite/hooks
  # Gitolite 3
  hooks_path: /home/git/.gitolite/hooks/


# Make some changes to Gitolite config
# For more information visit https://github.com/gitlabhq/gitlabhq/pull/1719

# Gitolite v2
sudo -u git -H sed -i 's/\(GL_GITCONFIG_KEYS\s*=>*\s*\).\{2\}/\\1"\.\*"/g' /home/git/.gitolite.rc

# gitlite v3
sudo -u git -H sed -i "s/\(GIT_CONFIG_KEYS\s*=>*\s*\).\{2\}/\\1'\.\*'/g" /home/git/.gitolite.rc


# Check app status
sudo -u gitlab bundle exec rake gitlab:app:status RAILS_ENV=production

```

## 3. Start all

    sudo service gitlab start
